/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.Enumeration;
import java.util.Hashtable;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.NucleusLogger;

public class ObjectProviderPool {
    private long maxIdle = 100L;
    private long expirationTime;
    private Hashtable<ObjectProvider, Long> recyclableOps;
    private CleanUpThread cleaner;

    public ObjectProviderPool(int maxIdle, boolean reaperThread) {
        this.maxIdle = maxIdle;
        this.expirationTime = 30000L;
        this.recyclableOps = new Hashtable();
        if (reaperThread) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of ObjectProviders (maxPool=" + maxIdle + ", reaperThread=" + reaperThread + ")");
        }
    }

    public void close() {
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
    }

    protected ObjectProvider create(ExecutionContext ec, AbstractClassMetaData cmd) {
        return new JDOStateManager(ec, cmd);
    }

    public boolean validate(ObjectProvider op) {
        return true;
    }

    public void expire(ObjectProvider op) {
    }

    public synchronized ObjectProvider checkOut(ExecutionContext ec, AbstractClassMetaData cmd) {
        ObjectProvider op;
        long now = System.currentTimeMillis();
        if (this.recyclableOps.size() > 0) {
            Enumeration<ObjectProvider> e = this.recyclableOps.keys();
            while (e.hasMoreElements()) {
                op = e.nextElement();
                if (now - this.recyclableOps.get(op) > this.expirationTime) {
                    this.recyclableOps.remove(op);
                    this.expire(op);
                    op = null;
                    continue;
                }
                if (this.validate(op)) {
                    this.recyclableOps.remove(op);
                    op.connect(ec, cmd);
                    return op;
                }
                this.recyclableOps.remove(op);
                this.expire(op);
                op = null;
            }
        }
        op = this.create(ec, cmd);
        return op;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Enumeration<ObjectProvider> e = this.recyclableOps.keys();
        while (e.hasMoreElements()) {
            ObjectProvider op = e.nextElement();
            if (now - this.recyclableOps.get(op) <= this.expirationTime) continue;
            this.recyclableOps.remove(op);
            this.expire(op);
            op = null;
        }
        System.gc();
    }

    public synchronized void checkIn(ObjectProvider op) {
        if ((long)this.recyclableOps.size() < this.maxIdle) {
            this.recyclableOps.put(op, System.currentTimeMillis());
        }
    }

    class CleanUpThread
    extends Thread {
        private ObjectProviderPool pool;
        private long sleepTime;

        CleanUpThread(ObjectProviderPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        public void run() {
            boolean needsStopping = false;
            while (!needsStopping) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    needsStopping = true;
                }
                this.pool.cleanUp();
            }
        }
    }
}

