/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager
implements Serializable {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected transient ApiAdapter api;
    protected transient ClassLoaderResolver clr;
    Map<String, JavaType> javaTypes = new HashMap<String, JavaType>();
    Map<String, TypeConverter> convertersByName = null;
    Map<Class, Map<Class, TypeConverter>> typeConverterMap = null;

    public TypeManager(ApiAdapter api, PluginManager mgr, ClassLoaderResolver clr) {
        this.api = api;
        this.clr = clr;
        this.loadJavaTypes(mgr, clr);
        this.loadTypeConverters(mgr, clr);
    }

    public Set<String> getSupportedSecondClassTypes() {
        return new HashSet<String>(this.javaTypes.keySet());
    }

    public boolean isSupportedSecondClassType(String className) {
        if (className == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(className);
        if (type == null) {
            try {
                Class cls = this.clr.classForName(className);
                type = this.findJavaTypeForClass(cls);
                return type != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String[] filterOutSupportedSecondClassNames(String[] inputClassNames) {
        int filteredClasses = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (!this.isSupportedSecondClassType(inputClassNames[i])) continue;
            inputClassNames[i] = null;
            ++filteredClasses;
        }
        if (filteredClasses == 0) {
            return inputClassNames;
        }
        String[] restClasses = new String[inputClassNames.length - filteredClasses];
        int m = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (inputClassNames[i] == null) continue;
            restClasses[m++] = inputClassNames[i];
        }
        return restClasses;
    }

    public boolean isDefaultPersistent(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return true;
        }
        type = this.findJavaTypeForClass(c);
        return type != null;
    }

    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        if (this.api.isPersistable(c)) {
            return this.api.getDefaultDFGForPersistableField();
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    public boolean isDefaultFetchGroupForCollection(Class c, Class genericType) {
        if (c != null && genericType == null) {
            return this.isDefaultFetchGroup(c);
        }
        if (c == null) {
            return false;
        }
        String name = c.getName() + "<" + genericType.getName() + ">";
        JavaType type = this.javaTypes.get(name);
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForCollectionClass(c, genericType);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    public boolean isDefaultEmbeddedType(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.embedded;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.embedded;
        }
        return false;
    }

    public boolean isSecondClassMutableType(String className) {
        return this.getWrapperTypeForType(className) != null;
    }

    public Class getWrapperTypeForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperType;
    }

    public Class getWrappedTypeBackedForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperTypeBacked;
    }

    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return true;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public Class getTypeForSecondClassWrapper(String className) {
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return type.cls;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return type.cls;
        }
        return null;
    }

    public TypeConverter getTypeConverterForName(String converterName) {
        if (this.convertersByName == null) {
            return null;
        }
        return this.convertersByName.get(converterName);
    }

    public void registerConverter(String name, TypeConverter converter) {
        if (this.convertersByName == null) {
            this.convertersByName = new HashMap<String, TypeConverter>();
        }
        this.convertersByName.put(name, converter);
    }

    public TypeConverter getDefaultTypeConverterForType(Class memberType) {
        JavaType javaType = this.javaTypes.get(memberType.getName());
        if (javaType == null) {
            return null;
        }
        String typeConverterName = javaType.typeConverterName;
        if (typeConverterName == null) {
            return null;
        }
        return this.getTypeConverterForName(typeConverterName);
    }

    public TypeConverter getTypeConverterForType(Class memberType, Class datastoreType) {
        if (this.typeConverterMap == null) {
            return null;
        }
        Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
        if (convertersForMember == null) {
            return null;
        }
        return convertersForMember.get(datastoreType);
    }

    protected JavaType findJavaTypeForClass(Class cls) {
        if (cls == null) {
            return null;
        }
        JavaType type2 = this.javaTypes.get(cls.getName());
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            Class<?> componentCls;
            if (type2.cls == cls && type2.genericType == null) {
                return type2;
            }
            if (type2.cls.getName().equals("java.lang.Object") || type2.cls.getName().equals("java.io.Serializable")) continue;
            Class<?> clazz = componentCls = cls.isArray() ? cls.getComponentType() : null;
            if (componentCls != null) {
                if (!type2.cls.isArray() || !type2.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.javaTypes.put(cls.getName(), type2);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
                }
                return type2;
            }
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType != null) continue;
            this.javaTypes.put(cls.getName(), type2);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
            }
            return type2;
        }
        return null;
    }

    protected JavaType findJavaTypeForCollectionClass(Class cls, Class genericType) {
        if (cls == null) {
            return null;
        }
        if (genericType == null) {
            return this.findJavaTypeForClass(cls);
        }
        String typeName = cls.getName() + "<" + genericType.getName() + ">";
        JavaType type2 = this.javaTypes.get(typeName);
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType == null || !type2.genericType.isAssignableFrom(genericType)) continue;
            this.javaTypes.put(typeName, type2);
            return type2;
        }
        return this.findJavaTypeForClass(cls);
    }

    private void loadJavaTypes(PluginManager mgr, ClassLoaderResolver clr) {
        ConfigurationElement[] elems;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016003"));
        }
        if ((elems = mgr.getConfigurationElementsForExtension("org.datanucleus.java_type", (String)null, (String)null)) != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("name").trim();
                String genericTypeName = elems[i].getAttribute("generic-type");
                String embeddedString = elems[i].getAttribute("embedded");
                String dfgString = elems[i].getAttribute("dfg");
                String wrapperType = elems[i].getAttribute("wrapper-type");
                String wrapperTypeBacked = elems[i].getAttribute("wrapper-type-backed");
                String typeConverterName = elems[i].getAttribute("converter-name");
                boolean embedded = false;
                if (embeddedString != null && embeddedString.equalsIgnoreCase("true")) {
                    embedded = true;
                }
                boolean dfg = false;
                if (dfgString != null && dfgString.equalsIgnoreCase("true")) {
                    dfg = true;
                }
                wrapperType = !StringUtils.isWhitespace(wrapperType) ? wrapperType.trim() : null;
                wrapperTypeBacked = !StringUtils.isWhitespace(wrapperTypeBacked) ? wrapperTypeBacked.trim() : null;
                try {
                    Class cls = clr.classForName(javaName);
                    Class genericType = null;
                    String javaTypeName = cls.getName();
                    if (!StringUtils.isWhitespace(genericTypeName)) {
                        genericType = clr.classForName(genericTypeName);
                        javaTypeName = javaTypeName + "<" + genericTypeName + ">";
                    }
                    if (this.javaTypes.containsKey(javaTypeName)) continue;
                    Class wrapperClass = null;
                    if (wrapperType != null) {
                        try {
                            wrapperClass = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), wrapperType);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperType));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperType));
                        }
                    }
                    Class wrapperClassBacked = null;
                    if (wrapperTypeBacked != null) {
                        try {
                            wrapperClassBacked = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), wrapperTypeBacked);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                        }
                    }
                    JavaType type = new JavaType(cls, genericType, embedded, dfg, wrapperClass, wrapperClassBacked, typeConverterName);
                    this.addJavaType(type);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016006", (Object)StringUtils.collectionToString(this.javaTypes.keySet())));
        }
    }

    protected void addJavaType(JavaType type) {
        String typeName = type.cls.getName();
        if (type.genericType != null) {
            typeName = typeName + "<" + type.genericType.getName() + ">";
        }
        this.javaTypes.put(typeName, type);
    }

    private void loadTypeConverters(PluginManager mgr, ClassLoaderResolver clr) {
        ConfigurationElement[] elems;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016007"));
        }
        if ((elems = mgr.getConfigurationElementsForExtension("org.datanucleus.type_converter", (String)null, (String)null)) != null) {
            for (int i = 0; i < elems.length; ++i) {
                String name = elems[i].getAttribute("name").trim();
                String memberTypeName = elems[i].getAttribute("member-type").trim();
                String datastoreTypeName = elems[i].getAttribute("datastore-type").trim();
                String converterClsName = elems[i].getAttribute("converter-class").trim();
                Class memberType = null;
                try {
                    TypeConverter conv = (TypeConverter)mgr.createExecutableExtension("org.datanucleus.type_converter", "name", name, "converter-class", null, null);
                    this.registerConverter(name, conv);
                    if (this.typeConverterMap == null) {
                        this.typeConverterMap = new HashMap<Class, Map<Class, TypeConverter>>();
                    }
                    memberType = clr.classForName(memberTypeName);
                    Class datastoreType = clr.classForName(datastoreTypeName);
                    Map<Class, TypeConverter> convertersForMember = this.typeConverterMap.get(memberType);
                    if (convertersForMember == null) {
                        convertersForMember = new HashMap<Class, TypeConverter>();
                        this.typeConverterMap.put(memberType, convertersForMember);
                    }
                    convertersForMember.put(datastoreType, conv);
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    NucleusLogger.PERSISTENCE.debug("Added converter for " + memberTypeName + "<->" + datastoreTypeName + " using " + converterClsName);
                    continue;
                }
                catch (Exception e) {
                    if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
                    if (memberType != null) {
                        NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " using " + converterClsName + " not instantiable (missing dependencies?) so ignoring");
                        continue;
                    }
                    NucleusLogger.PERSISTENCE.debug("TypeConverter for " + memberTypeName + "<->" + datastoreTypeName + " ignored since java type not present in CLASSPATH");
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016008"));
        }
    }

    public static Class getDatastoreTypeForTypeConverter(TypeConverter conv, Class memberType) {
        try {
            Method m = conv.getClass().getDeclaredMethod("toDatastoreType", memberType);
            return m.getReturnType();
        }
        catch (Exception e) {
            try {
                Method m = conv.getClass().getDeclaredMethod("getDatastoreClass", null);
                return (Class)m.invoke((Object)conv, null);
            }
            catch (Exception e2) {
                NucleusLogger.GENERAL.warn(">> Converter " + conv + " didn't have adequate information from toDatastoreType nor from getDatastoreClass");
                return null;
            }
        }
    }

    static class JavaType
    implements Serializable {
        final Class cls;
        final Class genericType;
        final boolean embedded;
        final boolean dfg;
        final Class wrapperType;
        final Class wrapperTypeBacked;
        final String typeConverterName;

        public JavaType(Class cls, Class genericType, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, String typeConverterName) {
            this.cls = cls;
            this.genericType = genericType;
            this.embedded = embedded;
            this.dfg = dfg;
            this.wrapperType = wrapperType;
            this.wrapperTypeBacked = wrapperTypeBacked != null ? wrapperTypeBacked : wrapperType;
            this.typeConverterName = typeConverterName;
        }
    }
}

