/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.util.StringTokenizer;

public class JavaUtils {
    private static boolean versionInitialised = false;
    private static int majorVersion = 1;
    private static int minorVersion = 0;

    public static boolean isJRE1_5OrAbove() {
        return JavaUtils.getJREMajorVersion() != 1 || JavaUtils.getJREMinorVersion() >= 5;
    }

    public static boolean isJRE1_6OrAbove() {
        return JavaUtils.getJREMajorVersion() != 1 || JavaUtils.getJREMinorVersion() >= 6;
    }

    public static boolean useStackMapFrames() {
        return !JavaUtils.isJRE1_6OrBelow();
    }

    public static boolean isJRE1_6OrBelow() {
        return JavaUtils.getJREMajorVersion() != 1 || JavaUtils.getJREMinorVersion() > 6;
    }

    public static boolean isJRE1_7OrAbove() {
        return JavaUtils.getJREMajorVersion() != 1 || JavaUtils.getJREMinorVersion() >= 7;
    }

    public static int getJREMajorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return majorVersion;
    }

    public static int getJREMinorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return minorVersion;
    }

    private static void initialiseJREVersion() {
        String version = System.getProperty("java.version");
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = Integer.valueOf(token);
            majorVersion = ver;
            token = tokeniser.nextToken();
            ver = Integer.valueOf(token);
            minorVersion = ver;
        }
        catch (Exception exception) {
            // empty catch block
        }
        versionInitialised = true;
    }

    public static boolean isGreaterEqualsThan(String version) {
        boolean greaterEquals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = Integer.valueOf(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = Integer.valueOf(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() >= majorVersion && JavaUtils.getJREMinorVersion() >= minorVersion) {
                greaterEquals = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return greaterEquals;
    }

    public static boolean isEqualsThan(String version) {
        boolean equals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = Integer.valueOf(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = Integer.valueOf(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() == majorVersion && JavaUtils.getJREMinorVersion() == minorVersion) {
                equals = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return equals;
    }
}

