/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.types.queued;

import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.Store;

/**
 * Interface for an operation that a SCO wrapper should support when queueing
 * its operations (optimistic transactions).
 */
public interface QueuedOperation
{
    /**
     * The backing store that this queued operation relates to.
     * @return The backing store
     */
    Store getStore();

    /**
     * The object provider that this operation is performed on.
     * @return ObjectProvider
     */
    ObjectProvider getObjectProvider();

    /**
     * Method to perform the operation once we are no longer queueing.
     */
    void perform();
}