/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.WeakValueMap;

public class ClassLoaderResolverImpl
implements ClassLoaderResolver {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final ClassLoader ecContextLoader;
    protected int ecContextLoaderHashCode = 0;
    protected ClassLoader runtimeLoader;
    protected int runtimeLoaderHashCode = 0;
    protected ClassLoader userRegisteredLoader;
    protected int userRegisteredLoaderHashCode = 0;
    protected Map<String, Class> loadedClasses = Collections.synchronizedMap(new WeakValueMap());
    protected Map<String, Class> unloadedClasses = Collections.synchronizedMap(new WeakValueMap());
    protected Map<String, URL> resources = Collections.synchronizedMap(new WeakValueMap());
    ThreadLocal primary = new ThreadLocal();

    public ClassLoaderResolverImpl(ClassLoader pmLoader) {
        this.ecContextLoader = pmLoader;
        if (pmLoader != null) {
            this.ecContextLoaderHashCode = this.ecContextLoader.hashCode();
        }
    }

    public ClassLoaderResolverImpl() {
        this.ecContextLoader = null;
    }

    public Class classForName(String name, ClassLoader primary) {
        if (name == null) {
            String msg = LOCALISER.msg("001000", null);
            throw new ClassNotResolvedException(msg);
        }
        if (name.equals(ClassNameConstants.BYTE)) {
            return Byte.TYPE;
        }
        if (name.equals(ClassNameConstants.CHAR)) {
            return Character.TYPE;
        }
        if (name.equals(ClassNameConstants.INT)) {
            return Integer.TYPE;
        }
        if (name.equals(ClassNameConstants.LONG)) {
            return Long.TYPE;
        }
        if (name.equals(ClassNameConstants.DOUBLE)) {
            return Double.TYPE;
        }
        if (name.equals(ClassNameConstants.FLOAT)) {
            return Float.TYPE;
        }
        if (name.equals(ClassNameConstants.SHORT)) {
            return Short.TYPE;
        }
        if (name.equals(ClassNameConstants.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (name.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return String.class;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String cacheKey = this.newCacheKey(name, primary, contextClassLoader);
        Class cls = this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        cls = this.unloadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        if (cls == null) {
            cls = this.classOrNull(name, primary);
        }
        if (cls == null && this.primary.get() != null) {
            cls = this.classOrNull(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.classOrNull(name, contextClassLoader);
        }
        if (cls == null) {
            cls = this.classOrNull(name, this.ecContextLoader);
        }
        if (cls == null && this.runtimeLoader != null) {
            cls = this.classOrNull(name, this.runtimeLoader);
        }
        if (cls == null && this.userRegisteredLoader != null) {
            cls = this.classOrNull(name, this.userRegisteredLoader);
        }
        if (cls == null) {
            throw new ClassNotResolvedException(LOCALISER.msg("001000", (Object)name));
        }
        this.unloadedClasses.put(cacheKey, cls);
        return cls;
    }

    private Class classForNameWithInitialize(String name, ClassLoader primary) {
        if (name == null) {
            String msg = LOCALISER.msg("001000", null);
            throw new ClassNotResolvedException(msg);
        }
        if (name.equals(ClassNameConstants.BYTE)) {
            return Byte.TYPE;
        }
        if (name.equals(ClassNameConstants.CHAR)) {
            return Character.TYPE;
        }
        if (name.equals(ClassNameConstants.INT)) {
            return Integer.TYPE;
        }
        if (name.equals(ClassNameConstants.LONG)) {
            return Long.TYPE;
        }
        if (name.equals(ClassNameConstants.DOUBLE)) {
            return Double.TYPE;
        }
        if (name.equals(ClassNameConstants.FLOAT)) {
            return Float.TYPE;
        }
        if (name.equals(ClassNameConstants.SHORT)) {
            return Short.TYPE;
        }
        if (name.equals(ClassNameConstants.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (name.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return String.class;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String cacheKey = this.newCacheKey(name, primary, contextClassLoader);
        Class cls = this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, primary);
        }
        if (cls == null && this.primary.get() != null) {
            cls = this.ClassOrNullWithInitialize(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, contextClassLoader);
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, this.ecContextLoader);
        }
        if (cls == null && this.runtimeLoader != null) {
            cls = this.ClassOrNullWithInitialize(name, this.runtimeLoader);
        }
        if (cls == null && this.userRegisteredLoader != null) {
            cls = this.ClassOrNullWithInitialize(name, this.userRegisteredLoader);
        }
        if (cls == null) {
            String msg = LOCALISER.msg("001000", (Object)name);
            throw new ClassNotResolvedException(msg);
        }
        this.loadedClasses.put(cacheKey, cls);
        return cls;
    }

    private String newCacheKey(String prefix, ClassLoader primary, ClassLoader contextClassLoader) {
        int h = 3;
        if (primary != null) {
            h ^= primary.hashCode();
        }
        if (contextClassLoader != null) {
            h ^= contextClassLoader.hashCode();
        }
        h ^= this.ecContextLoaderHashCode;
        h ^= this.runtimeLoaderHashCode;
        return prefix + (h ^= this.userRegisteredLoaderHashCode);
    }

    public Class classForName(String name, ClassLoader primary, boolean initialize) {
        if (initialize) {
            return this.classForNameWithInitialize(name, primary);
        }
        return this.classForName(name, primary);
    }

    public Class classForName(String name) {
        return this.classForName(name, null);
    }

    public Class classForName(String name, boolean initialize) {
        return this.classForName(name, null, initialize);
    }

    public boolean isAssignableFrom(String class_name_1, String class_name_2) {
        if (class_name_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_name_2)) {
            return true;
        }
        Class class_1 = this.classForName(class_name_1);
        Class class_2 = this.classForName(class_name_2);
        return class_1.isAssignableFrom(class_2);
    }

    public boolean isAssignableFrom(String class_name_1, Class class_2) {
        if (class_name_1 == null || class_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_2.getName())) {
            return true;
        }
        try {
            Class<?> class_1 = null;
            class_1 = class_2.getClassLoader() != null ? class_2.getClassLoader().loadClass(class_name_1) : Class.forName(class_name_1);
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAssignableFrom(Class class_1, String class_name_2) {
        if (class_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_1.getName().equals(class_name_2)) {
            return true;
        }
        try {
            Class<?> class_2 = null;
            class_2 = class_1.getClassLoader() != null ? class_1.getClassLoader().loadClass(class_name_2) : Class.forName(class_name_2);
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Class classOrNull(String name, ClassLoader loader) {
        try {
            return loader == null ? null : Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    private Class ClassOrNullWithInitialize(String name, ClassLoader loader) {
        try {
            return loader == null ? null : Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    public void setRuntimeClassLoader(ClassLoader loader) {
        this.runtimeLoader = loader;
        this.runtimeLoaderHashCode = this.runtimeLoader == null ? 0 : loader.hashCode();
    }

    public void registerUserClassLoader(ClassLoader loader) {
        this.userRegisteredLoader = loader;
        this.userRegisteredLoaderHashCode = this.userRegisteredLoader == null ? 0 : loader.hashCode();
    }

    public Enumeration getResources(final String resourceName, final ClassLoader primary) throws IOException {
        final ArrayList list = new ArrayList();
        final ClassLoader userClassLoader = (ClassLoader)this.primary.get();
        final ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Enumeration<URL> loaderResourceEnum;
                    Enumeration<URL> primaryResourceEnum;
                    String name = resourceName;
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if (primary != null) {
                        primaryResourceEnum = primary.getResources(name);
                        while (primaryResourceEnum.hasMoreElements()) {
                            list.add(primaryResourceEnum.nextElement());
                        }
                    }
                    if (userClassLoader != null) {
                        primaryResourceEnum = userClassLoader.getResources(name);
                        while (primaryResourceEnum.hasMoreElements()) {
                            list.add(primaryResourceEnum.nextElement());
                        }
                    }
                    if (ctxClassLoader != null) {
                        Enumeration<URL> resourceEnum = ctxClassLoader.getResources(name);
                        while (resourceEnum.hasMoreElements()) {
                            list.add(resourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.ecContextLoader != null) {
                        Enumeration<URL> pmResourceEnum = ClassLoaderResolverImpl.this.ecContextLoader.getResources(name);
                        while (pmResourceEnum.hasMoreElements()) {
                            list.add(pmResourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.runtimeLoader != null) {
                        loaderResourceEnum = ClassLoaderResolverImpl.this.runtimeLoader.getResources(name);
                        while (loaderResourceEnum.hasMoreElements()) {
                            list.add(loaderResourceEnum.nextElement());
                        }
                    }
                    if (ClassLoaderResolverImpl.this.userRegisteredLoader != null) {
                        loaderResourceEnum = ClassLoaderResolverImpl.this.userRegisteredLoader.getResources(name);
                        while (loaderResourceEnum.hasMoreElements()) {
                            list.add(loaderResourceEnum.nextElement());
                        }
                    }
                }
                catch (IOException ex) {
                    throw new NucleusException(ex.getMessage(), ex);
                }
                return null;
            }
        });
        return Collections.enumeration(new LinkedHashSet(list));
    }

    public URL getResource(final String resourceName, final ClassLoader primary) {
        final ClassLoader userClassLoader = (ClassLoader)this.primary.get();
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String resName = resourceName;
                URL url = ClassLoaderResolverImpl.this.resources.get(resName);
                if (url != null) {
                    return url;
                }
                if (resName.startsWith("/")) {
                    resName = resName.substring(1);
                }
                if (primary != null && (url = primary.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (userClassLoader != null && (url = userClassLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
                if (ctxClassLoader != null && (url = ctxClassLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.ecContextLoader != null && (url = ClassLoaderResolverImpl.this.ecContextLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.runtimeLoader != null && (url = ClassLoaderResolverImpl.this.runtimeLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                if (ClassLoaderResolverImpl.this.userRegisteredLoader != null && (url = ClassLoaderResolverImpl.this.userRegisteredLoader.getResource(resName)) != null) {
                    ClassLoaderResolverImpl.this.resources.put(resName, url);
                    return url;
                }
                return null;
            }
        });
        return url;
    }

    public void setPrimary(ClassLoader primary) {
        this.primary.set(primary);
    }

    public void unsetPrimary() {
        this.primary.set(null);
    }

    public String toString() {
        return "ClassLoaderResolver: primary=" + this.primary + " pmContextLoader=" + this.ecContextLoader + " runtimeLoader=" + this.runtimeLoader + " registeredLoader=" + this.userRegisteredLoader;
    }
}

