/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.StoreNucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;
import org.datanucleus.util.StringUtils;

public class SchemaTool {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance("DataNucleus.SchemaTool");
    private String apiName = "JDO";
    private String schemaName = null;
    private String ddlFilename = null;
    private boolean completeDdl = false;
    private boolean includeAutoStart = false;
    private boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        StoreManager storeMgr;
        String ddlFilename;
        SchemaTool tool = new SchemaTool();
        CommandLine cmd = new CommandLine();
        cmd.addOption("createSchema", "createSchema", "createSchema", LOCALISER.msg(false, "014024"));
        cmd.addOption("deleteSchema", "deleteSchema", "deleteSchema", LOCALISER.msg(false, "014025"));
        cmd.addOption("create", "create", null, LOCALISER.msg(false, "014026"));
        cmd.addOption("delete", "delete", null, LOCALISER.msg(false, "014027"));
        cmd.addOption("deletecreate", "deletecreate", null, LOCALISER.msg(false, "014044"));
        cmd.addOption("validate", "validate", null, LOCALISER.msg(false, "014028"));
        cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg(false, "014029"));
        cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg(false, "014030"));
        cmd.addOption("help", "help", null, LOCALISER.msg(false, "014033"));
        cmd.addOption("ddlFile", "ddlFile", "ddlFile", LOCALISER.msg(false, "014031"));
        cmd.addOption("completeDdl", "completeDdl", null, LOCALISER.msg(false, "014032"));
        cmd.addOption("includeAutoStart", "includeAutoStart", null, "Include Auto-Start Mechanisms");
        cmd.addOption("api", "api", "api", "API Adapter (JDO, JPA, etc)");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("pu", "persistenceUnit", "<persistence-unit>", "name of the persistence unit to handle the schema for");
        cmd.addOption("props", "properties", "props", "path to a properties file");
        cmd.parse(args);
        String[] filenames = cmd.getDefaultArgs();
        if (cmd.hasOption("api")) {
            tool.setApi(cmd.getOptionArg("api"));
        }
        String msg = null;
        Mode mode = Mode.CREATE;
        if (cmd.hasOption("create")) {
            mode = Mode.CREATE;
            msg = LOCALISER.msg(false, "014000");
        } else if (cmd.hasOption("delete")) {
            mode = Mode.DELETE;
            msg = LOCALISER.msg(false, "014001");
        } else if (cmd.hasOption("deletecreate")) {
            mode = Mode.DELETE_CREATE;
            msg = LOCALISER.msg(false, "014045");
        } else if (cmd.hasOption("validate")) {
            mode = Mode.VALIDATE;
            msg = LOCALISER.msg(false, "014002");
        } else if (cmd.hasOption("createSchema")) {
            mode = Mode.CREATE_SCHEMA;
            if (cmd.hasOption("deleteSchema")) {
                tool.setSchemaName(cmd.getOptionArg("createSchema"));
            }
            msg = LOCALISER.msg(false, "014034", (Object)tool.getSchemaName());
        } else if (cmd.hasOption("deleteSchema")) {
            mode = Mode.DELETE_SCHEMA;
            if (cmd.hasOption("deleteSchema")) {
                tool.setSchemaName(cmd.getOptionArg("deleteSchema"));
            }
            msg = LOCALISER.msg(false, "014035", (Object)tool.getSchemaName());
        } else if (cmd.hasOption("dbinfo")) {
            mode = Mode.DATABASE_INFO;
            msg = LOCALISER.msg(false, "014003");
        } else if (cmd.hasOption("schemainfo")) {
            mode = Mode.SCHEMA_INFO;
            msg = LOCALISER.msg(false, "014004");
        } else if (cmd.hasOption("help")) {
            System.out.println(LOCALISER.msg(false, "014023", (Object)cmd.toString()));
            System.exit(0);
        }
        LOGGER.info(msg);
        System.out.println(msg);
        String propsFileName = null;
        String persistenceUnitName = null;
        if (cmd.hasOption("ddlFile")) {
            tool.setDdlFile(cmd.getOptionArg("ddlFile"));
        }
        if (cmd.hasOption("completeDdl")) {
            tool.setCompleteDdl(true);
        }
        if (cmd.hasOption("includeAutoStart")) {
            tool.setIncludeAutoStart(true);
        }
        if (cmd.hasOption("v")) {
            tool.setVerbose(true);
        }
        if (cmd.hasOption("pu")) {
            persistenceUnitName = cmd.getOptionArg("pu");
        }
        if (cmd.hasOption("props")) {
            propsFileName = cmd.getOptionArg("props");
        }
        msg = LOCALISER.msg(false, "014005");
        LOGGER.info(msg);
        if (tool.isVerbose()) {
            System.out.println(msg);
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            msg = LOCALISER.msg(false, "014006", (Object)tokeniser.nextToken());
            LOGGER.info(msg);
            if (!tool.isVerbose()) continue;
            System.out.println(msg);
        }
        if (tool.isVerbose()) {
            System.out.println();
        }
        if ((ddlFilename = tool.getDdlFile()) != null) {
            msg = LOCALISER.msg(false, tool.getCompleteDdl() ? "014018" : "014019", (Object)ddlFilename);
            LOGGER.info(msg);
            if (tool.isVerbose()) {
                System.out.println(msg);
                System.out.println();
            }
        }
        StoreNucleusContext nucleusCtx = null;
        try {
            if (propsFileName != null) {
                Properties props = PersistenceUtils.setPropertiesUsingFile(propsFileName);
                nucleusCtx = SchemaTool.getNucleusContextForMode(mode, tool.getApi(), props, persistenceUnitName, ddlFilename, tool.isVerbose());
            } else {
                nucleusCtx = SchemaTool.getNucleusContextForMode(mode, tool.getApi(), null, persistenceUnitName, ddlFilename, tool.isVerbose());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating NucleusContext", e);
            System.out.println(LOCALISER.msg(false, "014008", (Object)e.getMessage()));
            System.exit(1);
            return;
        }
        TreeSet<String> classNames = null;
        if (mode != Mode.SCHEMA_INFO && mode != Mode.DATABASE_INFO) {
            try {
                int i;
                MetaDataManager metaDataMgr = nucleusCtx.getMetaDataManager();
                ClassLoaderResolver clr = nucleusCtx.getClassLoaderResolver(null);
                if (filenames == null && persistenceUnitName == null) {
                    msg = LOCALISER.msg(false, "014007");
                    LOGGER.error(msg);
                    System.out.println(msg);
                    throw new NucleusUserException(msg);
                }
                FileMetaData[] filemds = null;
                if (persistenceUnitName != null) {
                    msg = LOCALISER.msg(false, "014015", (Object)persistenceUnitName);
                    LOGGER.info(msg);
                    if (tool.isVerbose()) {
                        System.out.println(msg);
                        System.out.println();
                    }
                    filemds = metaDataMgr.getFileMetaData();
                } else {
                    msg = LOCALISER.msg(false, "014009");
                    LOGGER.info(msg);
                    if (tool.isVerbose()) {
                        System.out.println(msg);
                    }
                    for (i = 0; i < filenames.length; ++i) {
                        String entry = LOCALISER.msg(false, "014010", (Object)filenames[i]);
                        LOGGER.info(entry);
                        if (!tool.isVerbose()) continue;
                        System.out.println(entry);
                    }
                    if (tool.isVerbose()) {
                        System.out.println();
                    }
                    LOGGER.debug(LOCALISER.msg(false, "014011", (Object)("" + filenames.length)));
                    filemds = MetaDataUtils.getFileMetaDataForInputFiles(metaDataMgr, clr, filenames);
                    LOGGER.debug(LOCALISER.msg(false, "014012", (Object)("" + filenames.length)));
                }
                classNames = new TreeSet<String>();
                if (filemds == null) {
                    msg = LOCALISER.msg(false, "014021");
                    LOGGER.error(msg);
                    System.out.println(msg);
                    System.exit(2);
                    return;
                }
                for (i = 0; i < filemds.length; ++i) {
                    for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                        for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                            String className = filemds[i].getPackage(j).getClass(k).getFullClassName();
                            if (classNames.contains(className)) continue;
                            classNames.add(className);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.exit(2);
                return;
            }
        }
        if (!((storeMgr = nucleusCtx.getStoreManager()) instanceof SchemaAwareStoreManager)) {
            LOGGER.error("StoreManager of type " + storeMgr.getClass().getName() + " is not schema-aware so cannot be used with SchemaTool");
            System.exit(2);
            return;
        }
        SchemaAwareStoreManager schemaStoreMgr = (SchemaAwareStoreManager)((Object)storeMgr);
        try {
            if (mode == Mode.CREATE_SCHEMA) {
                tool.createSchema(schemaStoreMgr, tool.getSchemaName());
            } else if (mode == Mode.DELETE_SCHEMA) {
                tool.deleteSchema(schemaStoreMgr, tool.getSchemaName());
            } else if (mode == Mode.CREATE) {
                tool.createSchemaForClasses(schemaStoreMgr, classNames);
            } else if (mode == Mode.DELETE) {
                tool.deleteSchemaForClasses(schemaStoreMgr, classNames);
            } else if (mode == Mode.DELETE_CREATE) {
                tool.deleteSchemaForClasses(schemaStoreMgr, classNames);
                tool.createSchemaForClasses(schemaStoreMgr, classNames);
            } else if (mode == Mode.VALIDATE) {
                tool.validateSchemaForClasses(schemaStoreMgr, classNames);
            } else if (mode == Mode.DATABASE_INFO) {
                storeMgr.printInformation("DATASTORE", System.out);
            } else if (mode == Mode.SCHEMA_INFO) {
                storeMgr.printInformation("SCHEMA", System.out);
            }
            msg = LOCALISER.msg(false, "014043");
            LOGGER.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            msg = LOCALISER.msg(false, "014037", (Object)e.getMessage());
            System.out.println(msg);
            LOGGER.error(msg, e);
            System.exit(2);
            return;
        }
        finally {
            storeMgr.close();
        }
    }

    public Properties getPropertiesForSchemaTool() {
        Properties props = new Properties();
        if (this.getDdlFile() != null) {
            props.setProperty("ddlFilename", this.getDdlFile());
        }
        if (this.getCompleteDdl()) {
            props.setProperty("completeDdl", "true");
        }
        if (this.getIncludeAutoStart()) {
            props.setProperty("autoStartTable", "true");
        }
        return props;
    }

    public void createSchema(SchemaAwareStoreManager storeMgr, String schemaName) {
        storeMgr.createSchema(schemaName, this.getPropertiesForSchemaTool());
    }

    public void deleteSchema(SchemaAwareStoreManager storeMgr, String schemaName) {
        storeMgr.deleteSchema(schemaName, this.getPropertiesForSchemaTool());
    }

    public void createSchemaForClasses(SchemaAwareStoreManager storeMgr, Set<String> classNames) {
        storeMgr.createSchemaForClasses(classNames, this.getPropertiesForSchemaTool());
    }

    public void deleteSchemaForClasses(SchemaAwareStoreManager storeMgr, Set<String> classNames) {
        storeMgr.deleteSchemaForClasses(classNames, this.getPropertiesForSchemaTool());
    }

    public void validateSchemaForClasses(SchemaAwareStoreManager storeMgr, Set<String> classNames) {
        storeMgr.validateSchemaForClasses(classNames, this.getPropertiesForSchemaTool());
    }

    public static StoreNucleusContext getNucleusContextForMode(Mode mode, String api, Map userProps, String persistenceUnitName, String ddlFile, boolean verbose) {
        HashMap startupProps = null;
        if (userProps != null) {
            for (String startupPropName : AbstractNucleusContext.STARTUP_PROPERTIES) {
                if (!userProps.containsKey(startupPropName)) continue;
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put(startupPropName, userProps.get(startupPropName));
            }
        }
        PersistenceNucleusContextImpl nucleusCtx = new PersistenceNucleusContextImpl(api, startupProps);
        Configuration propConfig = nucleusCtx.getConfiguration();
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        PersistenceUnitMetaData pumd = null;
        if (persistenceUnitName != null) {
            props.put("javax.jdo.option.persistenceunitname", persistenceUnitName);
            pumd = nucleusCtx.getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
            if (pumd != null) {
                if (pumd.getProperties() != null) {
                    props.putAll(pumd.getProperties());
                }
            } else {
                throw new NucleusUserException("SchemaTool has been specified to use persistence-unit with name " + persistenceUnitName + " but none was found with that name");
            }
            if (api.equalsIgnoreCase("JPA")) {
                pumd.clearJarFiles();
            }
        }
        if (userProps != null) {
            for (Object key : userProps.keySet()) {
                String propName = (String)key;
                props.put(propName.toLowerCase(Locale.ENGLISH), userProps.get(propName));
            }
        }
        String[] propNames = new String[]{"datanucleus.ConnectionURL", "datanucleus.ConnectionDriverName", "datanucleus.ConnectionUserName", "datanucleus.ConnectionPassword", "datanucleus.mapping", "javax.jdo.option.ConnectionURL", "javax.jdo.option.ConnectionDriverName", "javax.jdo.option.ConnectionUserName", "javax.jdo.option.ConnectionPassword", "javax.jdo.option.Mapping", "javax.persistence.jdbc.url", "javax.persistence.jdbc.driver", "javax.persistence.jdbc.user", "javax.persistence.jdbc.password"};
        for (int i = 0; i < propNames.length; ++i) {
            if (System.getProperty(propNames[i]) == null) continue;
            props.put(propNames[i].toLowerCase(Locale.ENGLISH), System.getProperty(propNames[i]));
        }
        props.put("datanucleus.autoStartMechanism".toLowerCase(), "None");
        if (mode == Mode.CREATE) {
            if (ddlFile != null) {
                props.put("datanucleus.schema.validateTables".toLowerCase(), "false");
                props.put("datanucleus.schema.validateColumns".toLowerCase(), "false");
                props.put("datanucleus.schema.validateConstraints".toLowerCase(), "false");
            }
            props.remove("datanucleus.schema.autoCreateAll".toLowerCase());
            if (!props.containsKey("datanucleus.schema.autoCreateTables".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateTables".toLowerCase(), "true");
            }
            if (!props.containsKey("datanucleus.schema.autoCreateColumns".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateColumns".toLowerCase(), "true");
            }
            if (!props.containsKey("datanucleus.schema.autoCreateConstraints".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateConstraints".toLowerCase(), "true");
            }
            props.put("datanucleus.readOnlyDatastore".toLowerCase(), "false");
            props.put("datanucleus.rdbms.checkexisttablesorviews", "true");
        } else if (mode == Mode.DELETE) {
            props.put("datanucleus.readOnlyDatastore".toLowerCase(), "false");
        } else if (mode == Mode.DELETE_CREATE) {
            if (ddlFile != null) {
                props.put("datanucleus.schema.validateTables".toLowerCase(), "false");
                props.put("datanucleus.schema.validateColumns".toLowerCase(), "false");
                props.put("datanucleus.schema.validateConstraints".toLowerCase(), "false");
            }
            props.remove("datanucleus.schema.autoCreateAll".toLowerCase());
            if (!props.containsKey("datanucleus.schema.autoCreateTables".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateTables".toLowerCase(), "true");
            }
            if (!props.containsKey("datanucleus.schema.autoCreateColumns".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateColumns".toLowerCase(), "true");
            }
            if (!props.containsKey("datanucleus.schema.autoCreateConstraints".toLowerCase())) {
                props.put("datanucleus.schema.autoCreateConstraints".toLowerCase(), "true");
            }
            props.put("datanucleus.readOnlyDatastore".toLowerCase(), "false");
            props.put("datanucleus.rdbms.checkexisttablesorviews", "true");
        } else if (mode == Mode.VALIDATE) {
            props.put("datanucleus.schema.autoCreateAll".toLowerCase(), "false");
            props.put("datanucleus.schema.autoCreateTables".toLowerCase(), "false");
            props.put("datanucleus.schema.autoCreateConstraints".toLowerCase(), "false");
            props.put("datanucleus.schema.autoCreateColumns".toLowerCase(), "false");
            props.put("datanucleus.schema.validateTables".toLowerCase(), "true");
            props.put("datanucleus.schema.validateColumns".toLowerCase(), "true");
            props.put("datanucleus.schema.validateConstraints".toLowerCase(), "true");
        }
        propConfig.setPersistenceProperties(props);
        if (pumd != null) {
            nucleusCtx.getMetaDataManager().loadPersistenceUnit(pumd, null);
        }
        nucleusCtx.initialise();
        if (verbose) {
            String msg = LOCALISER.msg(false, "014020");
            LOGGER.info(msg);
            System.out.println(msg);
            Map<String, Object> pmfProps = propConfig.getPersistenceProperties();
            Set<String> keys = pmfProps.keySet();
            ArrayList<String> keyNames = new ArrayList<String>(keys);
            Collections.sort(keyNames);
            for (String key : keyNames) {
                Object value = pmfProps.get(key);
                boolean display = true;
                if (!key.startsWith("datanucleus")) {
                    display = false;
                } else if (key.equals("datanucleus.ConnectionPassword".toLowerCase())) {
                    display = false;
                } else if (value == null) {
                    display = false;
                } else if (value instanceof String && StringUtils.isWhitespace((String)value)) {
                    display = false;
                }
                if (!display) continue;
                msg = LOCALISER.msg(false, "014022", (Object)key, value);
                LOGGER.info(msg);
                System.out.println(msg);
            }
            System.out.println();
        }
        return nucleusCtx;
    }

    public String getApi() {
        return this.apiName;
    }

    public SchemaTool setApi(String api) {
        this.apiName = api;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public SchemaTool setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public SchemaTool setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String getDdlFile() {
        return this.ddlFilename;
    }

    public SchemaTool setDdlFile(String file) {
        this.ddlFilename = file;
        return this;
    }

    public SchemaTool setCompleteDdl(boolean completeDdl) {
        this.completeDdl = completeDdl;
        return this;
    }

    public boolean getCompleteDdl() {
        return this.completeDdl;
    }

    public SchemaTool setIncludeAutoStart(boolean include) {
        this.includeAutoStart = include;
        return this;
    }

    public boolean getIncludeAutoStart() {
        return this.includeAutoStart;
    }

    public static enum Mode {
        CREATE_SCHEMA,
        DELETE_SCHEMA,
        CREATE,
        DELETE,
        DELETE_CREATE,
        VALIDATE,
        DATABASE_INFO,
        SCHEMA_INFO;

    }
}

