/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.naming;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.naming.SchemaComponent;
import org.datanucleus.util.StringUtils;

public abstract class AbstractNamingFactory
implements NamingFactory {
    protected String wordSeparator = "_";
    protected String quoteString = "\"";
    protected NamingCase namingCase = NamingCase.MIXED_CASE;
    protected NucleusContext nucCtx;
    protected ClassLoaderResolver clr;
    Map<SchemaComponent, Integer> maxLengthByComponent = new HashMap<SchemaComponent, Integer>();
    private static final int TRUNCATE_HASH_LENGTH = 4;
    private static final int TRUNCATE_HASH_RANGE = AbstractNamingFactory.calculateHashMax();

    public AbstractNamingFactory(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
        this.clr = nucCtx.getClassLoaderResolver(null);
    }

    @Override
    public NamingFactory setQuoteString(String quote) {
        if (quote != null) {
            this.quoteString = quote;
        }
        return this;
    }

    @Override
    public NamingFactory setWordSeparator(String sep) {
        if (sep != null) {
            this.wordSeparator = sep;
        }
        return this;
    }

    @Override
    public NamingFactory setNamingCase(NamingCase nameCase) {
        if (nameCase != null) {
            this.namingCase = nameCase;
        }
        return this;
    }

    @Override
    public NamingFactory setMaximumLength(SchemaComponent cmpt, int max) {
        this.maxLengthByComponent.put(cmpt, max);
        return this;
    }

    protected int getMaximumLengthForComponent(SchemaComponent cmpt) {
        if (this.maxLengthByComponent.containsKey((Object)cmpt)) {
            return this.maxLengthByComponent.get((Object)cmpt);
        }
        return -1;
    }

    @Override
    public String getTableName(AbstractClassMetaData cmd) {
        String name = null;
        if (cmd.getTable() != null) {
            name = cmd.getTable();
        }
        if (name == null) {
            name = cmd.getName();
        }
        return this.prepareIdentifierNameForUse(name, SchemaComponent.TABLE);
    }

    @Override
    public String getColumnName(AbstractMemberMetaData mmd, ColumnType type) {
        return this.getColumnName(mmd, type, 0);
    }

    @Override
    public String getColumnName(List<AbstractMemberMetaData> mmds, int position) {
        EmbeddedMetaData embmd = mmds.get(0).getEmbeddedMetaData();
        if (embmd != null && mmds.size() > 1) {
            boolean checked = false;
            int mmdNo = 1;
            block0: while (!checked) {
                AbstractMemberMetaData[] embMmds = embmd.getMemberMetaData();
                if (embMmds == null) continue;
                boolean checkedEmbmd = false;
                for (int i = 0; i < embMmds.length; ++i) {
                    if (embMmds[i].getFullFieldName().equals(mmds.get(mmdNo).getFullFieldName())) {
                        if (mmds.size() == mmdNo + 1) {
                            checked = true;
                            ColumnMetaData[] colmds = embMmds[i].getColumnMetaData();
                            if (colmds != null && colmds.length > position) {
                                String colName = colmds[position].getName();
                                return this.prepareIdentifierNameForUse(colName, SchemaComponent.COLUMN);
                            }
                        } else {
                            checkedEmbmd = true;
                            ++mmdNo;
                            embmd = embMmds[i].getEmbeddedMetaData();
                            if (embmd == null) {
                                checked = true;
                            }
                        }
                    }
                    if (checked || checkedEmbmd) continue block0;
                }
            }
        }
        StringBuilder str = new StringBuilder(mmds.get(0).getName());
        for (int i = 1; i < mmds.size(); ++i) {
            str.append(this.wordSeparator);
            str.append(mmds.get(i).getName());
        }
        return this.prepareIdentifierNameForUse(str.toString(), SchemaComponent.COLUMN);
    }

    @Override
    public String getIndexName(AbstractClassMetaData cmd, IndexMetaData idxmd, int position) {
        if (!StringUtils.isWhitespace(idxmd.getName())) {
            return this.prepareIdentifierNameForUse(idxmd.getName(), SchemaComponent.CONSTRAINT);
        }
        String idxName = cmd.getName() + this.wordSeparator + position + this.wordSeparator + "IDX";
        return this.prepareIdentifierNameForUse(idxName, SchemaComponent.CONSTRAINT);
    }

    @Override
    public String getIndexName(AbstractMemberMetaData mmd, IndexMetaData idxmd) {
        if (!StringUtils.isWhitespace(idxmd.getName())) {
            return this.prepareIdentifierNameForUse(idxmd.getName(), SchemaComponent.CONSTRAINT);
        }
        String idxName = mmd.getClassName(false) + this.wordSeparator + mmd.getName() + this.wordSeparator + "IDX";
        return this.prepareIdentifierNameForUse(idxName, SchemaComponent.CONSTRAINT);
    }

    @Override
    public String getSequenceName(SequenceMetaData seqmd) {
        if (!StringUtils.isWhitespace(seqmd.getDatastoreSequence())) {
            return this.prepareIdentifierNameForUse(seqmd.getDatastoreSequence(), SchemaComponent.SEQUENCE);
        }
        String name = seqmd.getName() + this.wordSeparator + "SEQ";
        return this.prepareIdentifierNameForUse(name, SchemaComponent.SEQUENCE);
    }

    private static final int calculateHashMax() {
        int hm = 1;
        for (int i = 0; i < 4; ++i) {
            hm *= 36;
        }
        return hm;
    }

    protected static String truncate(String name, int length) {
        if (length == 0) {
            return name;
        }
        if (name.length() > length) {
            String suffix;
            if (length < 4) {
                throw new IllegalArgumentException("The length argument (=" + length + ") is less than HASH_LENGTH(=" + 4 + ")!");
            }
            int tailIndex = length - 4;
            int tailHash = name.hashCode();
            if (tailHash < 0) {
                tailHash *= -1;
            }
            if ((suffix = Integer.toString(tailHash %= TRUNCATE_HASH_RANGE, 36)).length() > 4) {
                throw new IllegalStateException("Calculated hash \"" + suffix + "\" has more characters than defined by HASH_LENGTH (=" + 4 + ")! This should never happen!");
            }
            if (suffix.length() < 4) {
                StringBuilder sb = new StringBuilder(4);
                sb.append(suffix);
                while (sb.length() < 4) {
                    sb.insert(0, '0');
                }
                suffix = sb.toString();
            }
            return name.substring(0, tailIndex) + suffix;
        }
        return name;
    }

    protected String getNameInRequiredCase(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder id = new StringBuilder();
        if (!(this.namingCase != NamingCase.LOWER_CASE_QUOTED && this.namingCase != NamingCase.MIXED_CASE_QUOTED && this.namingCase != NamingCase.UPPER_CASE_QUOTED || name.startsWith(this.quoteString))) {
            id.append(this.quoteString);
        }
        if (this.namingCase == NamingCase.LOWER_CASE || this.namingCase == NamingCase.LOWER_CASE_QUOTED) {
            id.append(name.toLowerCase());
        } else if (this.namingCase == NamingCase.UPPER_CASE || this.namingCase == NamingCase.UPPER_CASE_QUOTED) {
            id.append(name.toUpperCase());
        } else {
            id.append(name);
        }
        if (!(this.namingCase != NamingCase.LOWER_CASE_QUOTED && this.namingCase != NamingCase.MIXED_CASE_QUOTED && this.namingCase != NamingCase.UPPER_CASE_QUOTED || name.endsWith(this.quoteString))) {
            id.append(this.quoteString);
        }
        return id.toString();
    }

    protected String prepareIdentifierNameForUse(String name, SchemaComponent cmpt) {
        if (name == null) {
            return name;
        }
        String preparedName = name;
        int maxLength = this.getMaximumLengthForComponent(cmpt);
        if (preparedName != null && maxLength > 0 && preparedName.length() > maxLength) {
            preparedName = AbstractNamingFactory.truncate(preparedName, maxLength);
        }
        return this.getNameInRequiredCase(preparedName);
    }
}

