/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.TypeManagerImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractNucleusContext
implements NucleusContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final Configuration config;
    protected final PluginManager pluginManager;
    protected MetaDataManager metaDataManager = null;
    protected final ApiAdapter apiAdapter;
    protected TypeManager typeManager;
    protected final String classLoaderResolverClassName;
    protected transient Map<String, ClassLoaderResolver> classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
    public static final Set<String> STARTUP_PROPERTIES = new HashSet<String>();

    public AbstractNucleusContext(String apiName, Map startupProps, PluginManager pluginMgr) {
        this.pluginManager = pluginMgr != null ? pluginMgr : PluginManager.createPluginManager(startupProps, this.getClass().getClassLoader());
        this.config = new Configuration(this);
        if (startupProps != null && !startupProps.isEmpty()) {
            this.config.setPersistenceProperties(startupProps);
        }
        String clrName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("001001", (Object)clrName)).setFatal();
        }
        if (apiName != null) {
            this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(apiName, this.pluginManager);
            this.config.setDefaultProperties(this.apiAdapter.getDefaultFactoryProperties());
        } else {
            this.apiAdapter = null;
        }
    }

    @Override
    public void applyDefaultProperties(Configuration conf) {
        conf.addDefaultProperty("datanucleus.plugin.pluginRegistryClassName", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.plugin.allowUserBundles", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.plugin.validatePlugins", null, false, false, false);
        conf.addDefaultProperty("datanucleus.plugin.pluginRegistryBundleCheck", null, "EXCEPTION", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.classLoaderResolverName", null, "datanucleus", null, false, false);
        conf.addDefaultProperty("datanucleus.primaryClassLoader", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.localisation.messageCodes", null, false, false, false);
        conf.addDefaultProperty("datanucleus.localisation.language", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.alwaysDetachable", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.xml.validate", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.xml.namespaceAware", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.autoregistration", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowXML", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowAnnotations", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.allowLoadAtRuntime", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.metadata.supportORM", null, null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.jdoFileExtension", null, "jdo", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.ormFileExtension", null, "orm", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.jdoqueryFileExtension", null, "jdoquery", null, false, false);
        conf.addDefaultProperty("datanucleus.metadata.defaultInheritanceStrategy", null, "JDO2", CorePropertyValidator.class.getName(), false, false);
    }

    @Override
    public synchronized void initialise() {
        this.logConfiguration();
    }

    @Override
    public abstract void close();

    @Override
    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    @Override
    public String getApiName() {
        return this.apiAdapter != null ? this.apiAdapter.getName() : null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            String apiName = this.getApiName();
            try {
                this.metaDataManager = (MetaDataManager)this.pluginManager.createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{apiName}, "class", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("008010", (Object)apiName, (Object)e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(LOCALISER.msg("008009", (Object)apiName));
            }
        }
        return this.metaDataManager;
    }

    @Override
    public boolean supportsORMMetaData() {
        return true;
    }

    @Override
    public TypeManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = new TypeManagerImpl(this);
        }
        return this.typeManager;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String resolverName;
        String key = resolverName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if (this.classLoaderResolverMap == null) {
            this.classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
        }
        if ((clr = this.classLoaderResolverMap.get(key)) != null) {
            return clr;
        }
        try {
            clr = (ClassLoaderResolver)this.pluginManager.createExecutableExtension("org.datanucleus.classloader_resolver", "name", resolverName, "class-name", new Class[]{ClassLoader.class}, new Object[]{primaryLoader});
            clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER.msg("001002", (Object)this.classLoaderResolverClassName), cnfe).setFatal();
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("001003", (Object)this.classLoaderResolverClassName), e).setFatal();
        }
        this.classLoaderResolverMap.put(key, clr);
        return clr;
    }

    protected void logConfiguration() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("================= NucleusContext ===============");
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008000", (Object)this.pluginManager.getVersionForBundle("org.datanucleus"), (Object)System.getProperty("java.version"), (Object)System.getProperty("os.name")));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.getApiName());
            if (this.config.hasPropertyNotNull("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.config.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.pluginManager.getRegistryClassName());
            Object primCL = this.config.getProperty("datanucleus.primaryClassLoader");
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + this.config.getStringProperty("datanucleus.classLoaderResolverName") + (primCL != null ? "primary=" + primCL : ""));
            this.logConfigurationDetails();
            NucleusLogger.PERSISTENCE.debug("================================================");
        }
    }

    protected abstract void logConfigurationDetails();

    static {
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryClassName");
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryBundleCheck");
        STARTUP_PROPERTIES.add("datanucleus.plugin.allowUserBundles");
        STARTUP_PROPERTIES.add("datanucleus.plugin.validatePlugins");
        STARTUP_PROPERTIES.add("datanucleus.classLoaderResolverName");
        STARTUP_PROPERTIES.add("datanucleus.persistenceXmlFilename");
        STARTUP_PROPERTIES.add("datanucleus.primaryClassLoader");
    }
}

