/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.jdo;

import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.asm.AnnotationVisitor;
import org.datanucleus.asm.Attribute;
import org.datanucleus.asm.ClassVisitor;
import org.datanucleus.asm.FieldVisitor;
import org.datanucleus.asm.MethodVisitor;
import org.datanucleus.asm.Type;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.util.Localiser;

public class JDOClassChecker
extends ClassVisitor {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassEnhancer.class.getClassLoader());
    protected ClassEnhancer enhancer;
    protected HashSet<ClassField> fieldsRequired = new HashSet();
    protected HashSet<ClassMethod> methodsRequired = new HashSet();
    protected boolean enhanced = false;
    protected boolean logErrors = true;

    public JDOClassChecker(ClassEnhancer enhancer, boolean logErrors) {
        super(327680);
        this.enhancer = enhancer;
        this.logErrors = logErrors;
        if (enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.fieldsRequired.addAll(enhancer.getFieldsList());
            this.methodsRequired.addAll(enhancer.getMethodsList());
        }
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    protected void reportError(String msg) {
        if (this.logErrors) {
            DataNucleusEnhancer.LOGGER.error(msg);
        } else if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            DataNucleusEnhancer.LOGGER.debug(msg);
        }
        this.enhanced = false;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.enhanced = true;
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            if (interfaces == null) {
                this.enhanced = false;
                return;
            }
            if (!this.hasInterface(interfaces, this.enhancer.getNamer().getPersistableAsmClassName())) {
                this.reportError(LOCALISER.msg("Enhancer.Check.InterfaceMissing", (Object)this.enhancer.getClassName(), (Object)this.enhancer.getNamer().getPersistableClass().getName()));
            }
            if (this.enhancer.getClassMetaData().isDetachable() && !this.hasInterface(interfaces, this.enhancer.getNamer().getDetachableAsmClassName())) {
                this.reportError(LOCALISER.msg("Enhancer.Check.InterfaceMissing", (Object)this.enhancer.getClassName(), (Object)this.enhancer.getNamer().getDetachableClass().getName()));
            }
        }
    }

    protected boolean hasInterface(String[] interfaces, String intf) {
        if (interfaces == null || interfaces.length <= 0) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(intf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitEnd() {
        if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            for (ClassField field : this.fieldsRequired) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldMissing", (Object)this.enhancer.getClassName(), (Object)field.getName()));
            }
            for (ClassMethod method : this.methodsRequired) {
                this.reportError(LOCALISER.msg("Enhancer.Check.MethodMissing", (Object)this.enhancer.getClassName(), (Object)method.getName()));
            }
        } else if (this.enhancer.getClassMetaData().getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
            this.enhanced = false;
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Iterator<ClassField> iter = this.fieldsRequired.iterator();
        while (iter.hasNext()) {
            ClassField field = iter.next();
            if (!field.getName().equals(name)) continue;
            if (field.getAccess() != access) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldIncorrectAccess", (Object)this.enhancer.getClassName(), (Object)name));
                continue;
            }
            if (!desc.equals(Type.getDescriptor((Class)field.getType()))) {
                this.reportError(LOCALISER.msg("Enhancer.Check.FieldIncorrectType", (Object)this.enhancer.getClassName(), (Object)name));
                continue;
            }
            iter.remove();
            break;
        }
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Iterator<ClassMethod> iter = this.methodsRequired.iterator();
        while (iter.hasNext()) {
            ClassMethod method = iter.next();
            if (!method.getName().equals(name) || !method.getDescriptor().equals(desc)) continue;
            if (method.getAccess() != access) {
                this.reportError(LOCALISER.msg("Enhancer.Check.MethodIncorrectAccess", (Object)this.enhancer.getClassName(), (Object)name));
                continue;
            }
            iter.remove();
            break;
        }
        return null;
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public void visitSource(String source, String debug) {
    }
}

