/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class FloatArrayByteBufferConverter
implements TypeConverter<float[], ByteBuffer> {
    @Override
    public ByteBuffer toDatastoreType(float[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromFloatArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public float[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getFloatArrayFromByteArray(datastoreValue.array());
    }
}

