/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory;

import java.lang.reflect.Array;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.query.inmemory.VariableNotSetException;

public class ArrayContainsMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!invokedValue.getClass().isArray()) {
            throw new NucleusException(eval.getLocaliser().msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Expression param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)param;
            try {
                paramValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, (Object[])invokedValue);
            }
        } else {
            throw new NucleusException("Dont currently support use of Array.contains(" + param.getClass().getName() + ")");
        }
        for (int i = 0; i < Array.getLength(invokedValue); ++i) {
            long elemLong;
            long paramLong;
            Object elem = Array.get(invokedValue, i);
            if (elem == null && paramValue == null) {
                return Boolean.TRUE;
            }
            if (elem == null || paramValue == null) continue;
            if (elem.equals(paramValue)) {
                return Boolean.TRUE;
            }
            if (paramValue.getClass().isAssignableFrom(elem.getClass()) || elem.getClass().isAssignableFrom(paramValue.getClass()) || paramValue.getClass() != Long.class && paramValue.getClass() != Integer.class && paramValue.getClass() != Short.class || elem.getClass() != Long.class && elem.getClass() != Integer.class && elem.getClass() != Short.class || (paramLong = ((Number)paramValue).longValue()) != (elemLong = ((Number)elem).longValue())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

