/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.PersistenceBatchType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected StoreManager storeMgr;

    public AbstractPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = storeMgr;
    }

    @Override
    public void batchStart(ExecutionContext ec, PersistenceBatchType batchType) {
    }

    @Override
    public void batchEnd(ExecutionContext ec, PersistenceBatchType type) {
    }

    @Override
    public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.insertObject(ops[i]);
        }
    }

    @Override
    public void deleteObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.deleteObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.deleteObject(ops[i]);
        }
    }

    @Override
    public void locateObjects(ObjectProvider[] ops) {
        if (ops.length == 1) {
            this.locateObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.locateObject(ops[i]);
        }
    }

    @Override
    public Object[] findObjects(ExecutionContext ec, Object[] ids) {
        Object[] objects = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            objects[i] = this.findObject(ec, ids[i]);
        }
        return objects;
    }

    public void assertReadOnlyForUpdateOfObject(ObjectProvider op) {
        boolean readonly;
        String value;
        if (op.getExecutionContext().getBooleanProperty("datanucleus.readOnlyDatastore").booleanValue()) {
            if (op.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032004", (Object)op.getObjectAsPrintable()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032005", (Object)op.getObjectAsPrintable()));
            }
            return;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.hasExtension("read-only") && !StringUtils.isWhitespace(value = cmd.getValueForExtension("read-only")) && (readonly = Boolean.valueOf(value).booleanValue())) {
            if (op.getExecutionContext().getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032006", (Object)op.getObjectAsPrintable()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032007", (Object)op.getObjectAsPrintable()));
            }
            return;
        }
    }
}

