/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class FetchGroup
implements Serializable {
    public static final String DEFAULT = "default";
    public static final String RELATIONSHIP = "relationship";
    public static final String MULTIVALUED = "multivalued";
    public static final String BASIC = "basic";
    public static final String ALL = "all";
    private NucleusContext nucleusCtx;
    private String name;
    private Class cls;
    private boolean postLoad = false;
    private Set<String> memberNames = new HashSet<String>();
    private Map<String, Integer> recursionDepthByMemberName = null;
    private Collection<FetchPlan> planListeners = null;
    private boolean unmodifiable = false;

    public FetchGroup(NucleusContext nucleusCtx, String name, Class cls) {
        this.nucleusCtx = nucleusCtx;
        this.name = name;
        this.cls = cls;
    }

    public FetchGroup(FetchGroup grp) {
        this.name = grp.name;
        this.cls = grp.cls;
        this.nucleusCtx = grp.nucleusCtx;
        this.postLoad = grp.postLoad;
        for (String memberName : grp.memberNames) {
            this.addMember(memberName);
        }
        if (grp.recursionDepthByMemberName != null) {
            this.recursionDepthByMemberName = new HashMap<String, Integer>(grp.recursionDepthByMemberName);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.cls;
    }

    public void setPostLoad(boolean postLoad) {
        this.assertUnmodifiable();
        this.postLoad = postLoad;
    }

    public boolean getPostLoad() {
        return this.postLoad;
    }

    public int getRecursionDepth(String memberName) {
        Integer recursionValue;
        if (this.recursionDepthByMemberName != null && (recursionValue = this.recursionDepthByMemberName.get(memberName)) != null) {
            return recursionValue;
        }
        return 1;
    }

    public FetchGroup setRecursionDepth(String memberName, int recursionDepth) {
        this.assertUnmodifiable();
        this.assertNotMember(memberName);
        if (this.memberNames.contains(memberName)) {
            if (this.recursionDepthByMemberName == null) {
                this.recursionDepthByMemberName = new HashMap<String, Integer>();
            }
            this.recursionDepthByMemberName.put(memberName, recursionDepth);
        }
        return this;
    }

    public FetchGroup setUnmodifiable() {
        if (!this.unmodifiable) {
            this.unmodifiable = true;
        }
        return this;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public FetchGroup addCategory(String categoryName) {
        this.assertUnmodifiable();
        String[] memberNames = this.getMemberNamesForCategory(categoryName);
        if (memberNames != null) {
            for (int i = 0; i < memberNames.length; ++i) {
                this.memberNames.add(memberNames[i]);
            }
            this.notifyListeners();
        }
        return this;
    }

    public FetchGroup removeCategory(String categoryName) {
        this.assertUnmodifiable();
        String[] memberNames = this.getMemberNamesForCategory(categoryName);
        if (memberNames != null) {
            for (int i = 0; i < memberNames.length; ++i) {
                this.memberNames.remove(memberNames[i]);
            }
            this.notifyListeners();
        }
        return this;
    }

    private String[] getMemberNamesForCategory(String categoryName) {
        AbstractClassMetaData acmd = this.getMetaDataForClass();
        int[] memberPositions = null;
        if (categoryName.equals(DEFAULT)) {
            memberPositions = acmd.getDFGMemberPositions();
        } else if (categoryName.equals(ALL)) {
            memberPositions = acmd.getAllMemberPositions();
        } else if (categoryName.equals(BASIC)) {
            memberPositions = acmd.getBasicMemberPositions(this.nucleusCtx.getClassLoaderResolver(null), this.nucleusCtx.getMetaDataManager());
        } else if (categoryName.equals(RELATIONSHIP)) {
            memberPositions = acmd.getRelationMemberPositions(this.nucleusCtx.getClassLoaderResolver(null), this.nucleusCtx.getMetaDataManager());
        } else if (categoryName.equals(MULTIVALUED)) {
            memberPositions = acmd.getMultivaluedMemberPositions();
        } else {
            throw this.nucleusCtx.getApiAdapter().getUserExceptionForException("Category " + categoryName + " is invalid", null);
        }
        String[] names = new String[memberPositions.length];
        for (int i = 0; i < memberPositions.length; ++i) {
            names[i] = acmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[i]).getName();
        }
        return names;
    }

    public Set<String> getMembers() {
        return this.memberNames;
    }

    public FetchGroup addMember(String memberName) {
        this.assertUnmodifiable();
        this.assertNotMember(memberName);
        this.memberNames.add(memberName);
        this.notifyListeners();
        return this;
    }

    public FetchGroup removeMember(String memberName) {
        this.assertUnmodifiable();
        this.assertNotMember(memberName);
        this.memberNames.remove(memberName);
        this.notifyListeners();
        return this;
    }

    public FetchGroup addMembers(String[] members) {
        if (members == null) {
            return this;
        }
        for (int i = 0; i < members.length; ++i) {
            this.addMember(members[i]);
        }
        this.notifyListeners();
        return this;
    }

    public FetchGroup removeMembers(String[] members) {
        if (members == null) {
            return this;
        }
        for (int i = 0; i < members.length; ++i) {
            this.removeMember(members[i]);
        }
        this.notifyListeners();
        return this;
    }

    private void notifyListeners() {
        if (this.planListeners != null) {
            Iterator<FetchPlan> iter = this.planListeners.iterator();
            while (iter.hasNext()) {
                iter.next().notifyFetchGroupChange(this);
            }
        }
    }

    public void registerListener(FetchPlan plan) {
        if (this.planListeners == null) {
            this.planListeners = new HashSet<FetchPlan>();
        }
        this.planListeners.add(plan);
    }

    public void deregisterListener(FetchPlan plan) {
        if (this.planListeners != null) {
            this.planListeners.remove(plan);
        }
    }

    public void disconnectFromListeners() {
        if (this.planListeners != null) {
            Iterator<FetchPlan> iter = this.planListeners.iterator();
            while (iter.hasNext()) {
                iter.next().notifyFetchGroupRemove(this);
            }
            this.planListeners.clear();
            this.planListeners = null;
        }
    }

    private void assertUnmodifiable() {
        if (this.unmodifiable) {
            throw this.nucleusCtx.getApiAdapter().getUserExceptionForException("FetchGroup is not modifiable!", null);
        }
    }

    private void assertNotMember(String memberName) {
        AbstractClassMetaData acmd = this.getMetaDataForClass();
        if (!acmd.hasMember(memberName)) {
            throw this.nucleusCtx.getApiAdapter().getUserExceptionForException(Localiser.msg("006004", memberName, this.cls.getName()), null);
        }
    }

    private AbstractClassMetaData getMetaDataForClass() {
        AbstractClassMetaData acmd = null;
        acmd = this.cls.isInterface() ? this.nucleusCtx.getMetaDataManager().getMetaDataForInterface(this.cls, this.nucleusCtx.getClassLoaderResolver(null)) : this.nucleusCtx.getMetaDataManager().getMetaDataForClass(this.cls, this.nucleusCtx.getClassLoaderResolver(null));
        return acmd;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FetchGroup)) {
            return false;
        }
        FetchGroup other = (FetchGroup)obj;
        return other.cls == this.cls && other.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.cls.hashCode();
    }

    public String toString() {
        return "FetchGroup : " + this.name + " for " + this.cls.getName() + " members=" + StringUtils.collectionToString(this.memberNames) + ", modifiable=" + !this.unmodifiable + ", postLoad=" + this.postLoad + ", listeners.size=" + (this.planListeners != null ? this.planListeners.size() : 0);
    }
}

