/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.StateManager;

public class EnhancementHelper {
    private static EnhancementHelper singletonHelper = new EnhancementHelper();
    private static Map<Class, Meta> registeredClasses = Collections.synchronizedMap(new HashMap());
    private static final Map<Class, Class> authorizedStateManagerClasses = new WeakHashMap<Class, Class>();
    private static final List<RegisterClassListener> listeners = new ArrayList<RegisterClassListener>();
    private static String dateFormatPattern;
    private static DateFormat dateFormat;
    static final Map<Class, StringConstructor> stringConstructorMap;

    private EnhancementHelper() {
    }

    public static EnhancementHelper getInstance() {
        return singletonHelper;
    }

    public String[] getFieldNames(Class pcClass) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        return meta.getFieldNames();
    }

    public Class[] getFieldTypes(Class pcClass) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        return meta.getFieldTypes();
    }

    public byte[] getFieldFlags(Class pcClass) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        return meta.getFieldFlags();
    }

    public Class getPersistableSuperclass(Class pcClass) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        return meta.getPersistableSuperclass();
    }

    public Persistable newInstance(Class pcClass, StateManager sm) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.dnNewInstance(sm);
    }

    public Persistable newInstance(Class pcClass, StateManager sm, Object oid) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.dnNewInstance(sm, oid);
    }

    public Object newObjectIdInstance(Class pcClass) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.dnNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class pcClass, Object obj) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.dnNewObjectIdInstance(obj);
    }

    public void copyKeyFieldsToObjectId(Class pcClass, Persistable.ObjectIdFieldSupplier fm, Object oid) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new NucleusException("Class " + pcClass.getName() + " has no identity!").setFatal();
        }
        pcInstance.dnCopyKeyFieldsToObjectId(fm, oid);
    }

    public void copyKeyFieldsFromObjectId(Class pcClass, Persistable.ObjectIdFieldConsumer fm, Object oid) {
        Meta meta = EnhancementHelper.getMeta(pcClass);
        Persistable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new NucleusException("Class " + pcClass.getName() + " has no identity!").setFatal();
        }
        pcInstance.dnCopyKeyFieldsFromObjectId(fm, oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(Class pcClass, String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistableSuperclass, Persistable pc) {
        if (pcClass == null) {
            throw new NullPointerException("Attempt to register class with null class type");
        }
        Meta meta = new Meta(fieldNames, fieldTypes, fieldFlags, persistableSuperclass, pc);
        registeredClasses.put(pcClass, meta);
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                RegisterClassEvent event = new RegisterClassEvent(singletonHelper, pcClass, fieldNames, fieldTypes, fieldFlags, persistableSuperclass);
                for (RegisterClassListener crl : listeners) {
                    if (crl == null) continue;
                    crl.registerClass(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClasses(ClassLoader cl) {
        Map<Class, Meta> map = registeredClasses;
        synchronized (map) {
            Iterator<Class> i = registeredClasses.keySet().iterator();
            while (i.hasNext()) {
                Class pcClass = i.next();
                if (pcClass == null || pcClass.getClassLoader() != cl) continue;
                i.remove();
            }
        }
    }

    public void unregisterClass(Class pcClass) {
        if (pcClass == null) {
            throw new NullPointerException("Cannot unregisterClass on null");
        }
        registeredClasses.remove(pcClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisterClassListener(RegisterClassListener crl) {
        HashSet<Class> alreadyRegisteredClasses = null;
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.add(crl);
            alreadyRegisteredClasses = new HashSet<Class>(registeredClasses.keySet());
        }
        for (Class pcClass : alreadyRegisteredClasses) {
            Meta meta = EnhancementHelper.getMeta(pcClass);
            RegisterClassEvent event = new RegisterClassEvent(this, pcClass, meta.getFieldNames(), meta.getFieldTypes(), meta.getFieldFlags(), meta.getPersistableSuperclass());
            crl.registerClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisterClassListener(RegisterClassListener crl) {
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.remove(crl);
        }
    }

    public Collection<Class> getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    private static Meta getMeta(Class pcClass) {
        Meta ret = registeredClasses.get(pcClass);
        if (ret == null) {
            throw new NucleusUserException("Cannot lookup meta info for " + pcClass + " - nothing found").setFatal();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClass(Class smClass) {
        if (smClass == null) {
            throw new NullPointerException("Cannot register StateManager class with null input!");
        }
        Map<Class, Class> map = authorizedStateManagerClasses;
        synchronized (map) {
            authorizedStateManagerClasses.put(smClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClasses(Collection smClasses) {
        Map<Class, Class> map = authorizedStateManagerClasses;
        synchronized (map) {
            Iterator it = smClasses.iterator();
            while (it.hasNext()) {
                Object smClass = it.next();
                if (!(smClass instanceof Class)) {
                    throw new ClassCastException("Cannot register StateManager class passing in object of type " + smClass.getClass().getName());
                }
                EnhancementHelper.registerAuthorizedStateManagerClass((Class)it.next());
            }
        }
    }

    public static void checkAuthorizedStateManager(StateManager sm) {
        EnhancementHelper.checkAuthorizedStateManagerClass(sm.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAuthorizedStateManagerClass(Class smClass) {
        Map<Class, Class> map = authorizedStateManagerClasses;
        synchronized (map) {
            if (authorizedStateManagerClasses.containsKey(smClass)) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerStringConstructor(Class cls, StringConstructor sc) {
        Map<Class, StringConstructor> map = stringConstructorMap;
        synchronized (map) {
            return stringConstructorMap.put(cls, sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object construct(String className, String keyString) {
        try {
            StringConstructor stringConstructor;
            Class<?> keyClass = Class.forName(className);
            Map<Class, StringConstructor> map = stringConstructorMap;
            synchronized (map) {
                stringConstructor = stringConstructorMap.get(keyClass);
            }
            if (stringConstructor != null) {
                return stringConstructor.construct(keyString);
            }
            Constructor<?> keyConstructor = keyClass.getConstructor(String.class);
            return keyConstructor.newInstance(keyString);
        }
        catch (Exception ex) {
            throw new NucleusUserException("Exception in Object identity String constructor", ex);
        }
    }

    static DateFormat getDateTimeInstance() {
        DateFormat result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedAction<DateFormat>(){

                @Override
                public DateFormat run() {
                    return DateFormat.getDateTimeInstance();
                }
            });
        }
        catch (Exception ex) {
            result = DateFormat.getInstance();
        }
        return result;
    }

    public synchronized void registerDateFormat(DateFormat df) {
        dateFormat = df;
        dateFormatPattern = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : "Unknown message";
    }

    static {
        singletonHelper.registerDateFormat(EnhancementHelper.getDateTimeInstance());
        stringConstructorMap = new HashMap<Class, StringConstructor>();
        singletonHelper.registerStringConstructor(Currency.class, new StringConstructor(){

            @Override
            public Object construct(String s) {
                try {
                    return Currency.getInstance(s);
                }
                catch (Exception ex) {
                    throw new NucleusUserException("Exception in Currency identity String constructor", ex);
                }
            }
        });
        singletonHelper.registerStringConstructor(Locale.class, new StringConstructor(){

            @Override
            public Object construct(String s) {
                try {
                    String lang = s;
                    int firstUnderbar = s.indexOf(95);
                    if (firstUnderbar == -1) {
                        return new Locale(lang);
                    }
                    lang = s.substring(0, firstUnderbar);
                    int secondUnderbar = s.indexOf(95, firstUnderbar + 1);
                    if (secondUnderbar == -1) {
                        String country = s.substring(firstUnderbar + 1);
                        return new Locale(lang, country);
                    }
                    String country = s.substring(firstUnderbar + 1, secondUnderbar);
                    String variant = s.substring(secondUnderbar + 1);
                    return new Locale(lang, country, variant);
                }
                catch (Exception ex) {
                    throw new NucleusUserException("Exception in Locale identity String constructor", ex);
                }
            }
        });
        singletonHelper.registerStringConstructor(Date.class, new StringConstructor(){

            @Override
            public synchronized Object construct(String s) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException ex) {
                    ParsePosition pp = new ParsePosition(0);
                    Date result = dateFormat.parse(s, pp);
                    if (result == null) {
                        throw new NucleusUserException("Exception in Date identity String constructor", new Object[]{s, pp.getErrorIndex(), dateFormatPattern});
                    }
                    return result;
                }
            }
        });
    }

    static class Meta {
        Persistable pc;
        String[] fieldNames;
        Class[] fieldTypes;
        byte[] fieldFlags;
        Class persistableSuperclass;

        Meta(String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistableSuperclass, Persistable pc) {
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.fieldFlags = fieldFlags;
            this.persistableSuperclass = persistableSuperclass;
            this.pc = pc;
        }

        String[] getFieldNames() {
            return this.fieldNames;
        }

        Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        Class getPersistableSuperclass() {
            return this.persistableSuperclass;
        }

        Persistable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }

    public static interface StringConstructor {
        public Object construct(String var1);
    }

    public static class RegisterClassEvent
    extends EventObject {
        protected Class pcClass;
        protected String[] fieldNames;
        protected Class[] fieldTypes;
        protected byte[] fieldFlags;
        protected Class persistableSuperclass;

        public RegisterClassEvent(EnhancementHelper helper, Class registeredClass, String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistableSuperclass) {
            super(helper);
            this.pcClass = registeredClass;
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.fieldFlags = fieldFlags;
            this.persistableSuperclass = persistableSuperclass;
        }

        public Class getRegisteredClass() {
            return this.pcClass;
        }

        public String[] getFieldNames() {
            return this.fieldNames;
        }

        public Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        public byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        public Class getPersistableSuperclass() {
            return this.persistableSuperclass;
        }
    }

    public static interface RegisterClassListener
    extends EventListener {
        public void registerClass(RegisterClassEvent var1);
    }
}

