/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class BooleanIntegerConverter
implements TypeConverter<Boolean, Integer> {
    @Override
    public Boolean toMemberType(Integer val) {
        if (val == null) {
            return null;
        }
        try {
            return val == 1;
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", val, Boolean.class.getName()), nfe);
        }
    }

    @Override
    public Integer toDatastoreType(Boolean bool) {
        return bool != null ? Integer.valueOf(bool != false ? 1 : 0) : null;
    }
}

