/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;

public class ColumnImpl
implements Column {
    Table table;
    ColumnType columnType = ColumnType.COLUMN;
    String identifier;
    boolean primaryKey = false;
    boolean nullable = false;
    boolean defaultable = false;
    Object defaultValue = null;
    boolean unique = false;
    JdbcType jdbcType;
    String typeName;
    int position = -1;
    MemberColumnMapping mapping = null;
    ColumnMetaData colmd = null;

    public ColumnImpl(Table tbl, String identifier, ColumnType colType) {
        this.table = tbl;
        this.identifier = identifier;
        this.columnType = colType;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public MemberColumnMapping getMemberColumnMapping() {
        return this.mapping;
    }

    public void setMemberColumnMapping(MemberColumnMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Column setPrimaryKey() {
        this.primaryKey = true;
        return this;
    }

    @Override
    public Column setNullable(boolean flag) {
        this.nullable = flag;
        return this;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public Column setDefaultable(Object defaultValue) {
        this.defaultable = true;
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean isDefaultable() {
        return this.defaultable;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Column setUnique(boolean flag) {
        this.unique = flag;
        return this;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public Column setJdbcType(JdbcType type) {
        this.jdbcType = type;
        return this;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public Column setTypeName(String type) {
        this.typeName = type;
        return this;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Column setPosition(int pos) {
        this.position = pos;
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Column setColumnMetaData(ColumnMetaData md) {
        this.colmd = md;
        return this;
    }

    @Override
    public ColumnMetaData getColumnMetaData() {
        return this.colmd;
    }

    public String toString() {
        if (this.mapping != null) {
            return "Column: " + this.identifier + " member=" + this.mapping.getMemberMetaData().getFullFieldName() + (this.primaryKey ? " (PK)" : "") + (this.position >= 0 ? " [" + this.position + "]" : "");
        }
        return "Column : " + this.identifier + " type=" + (Object)((Object)this.columnType) + (this.primaryKey ? " (PK)" : "") + (this.position >= 0 ? " [" + this.position + "]" : "");
    }
}

