/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.util.Calendar;
import java.util.TimeZone;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class CalendarComponentsConverter
implements TypeConverter<Calendar, Object[]>,
MultiColumnConverter {
    @Override
    public Calendar toMemberType(Object[] ts) {
        if (ts == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis((Long)ts[0]);
        cal.setTimeZone(TimeZone.getTimeZone((String)ts[1]));
        return cal;
    }

    @Override
    public Object[] toDatastoreType(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return new Object[]{cal.getTimeInMillis(), cal.getTimeZone().getID()};
    }

    @Override
    public Class[] getDatastoreColumnTypes() {
        return new Class[]{Long.class, String.class};
    }
}

