/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class DoubleArrayByteBufferConverter
implements TypeConverter<double[], ByteBuffer> {
    private static final long serialVersionUID = 2169191689430539326L;

    @Override
    public ByteBuffer toDatastoreType(double[] memberValue) {
        byte[] bytes = TypeConversionHelper.getByteArrayFromDoubleArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public double[] toMemberType(ByteBuffer datastoreValue) {
        return TypeConversionHelper.getDoubleArrayFromByteArray(datastoreValue.array());
    }
}

