/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class L2CacheRetrieveFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;
    List<Integer> fieldsNotLoaded = null;

    public L2CacheRetrieveFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public int[] getFieldsNotLoaded() {
        if (this.fieldsNotLoaded == null) {
            return null;
        }
        int[] flds = new int[this.fieldsNotLoaded.size()];
        int i = 0;
        for (Integer fldNum : this.fieldsNotLoaded) {
            flds[i++] = fldNum;
        }
        return flds;
    }

    @Override
    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public char fetchCharField(int fieldNumber) {
        return ((Character)this.cachedPC.getFieldValue(fieldNumber)).charValue();
    }

    @Override
    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.cachedPC.getFieldValue(fieldNumber)).floatValue();
    }

    @Override
    public int fetchIntField(int fieldNumber) {
        return (Integer)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public long fetchLongField(int fieldNumber) {
        return (Long)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public short fetchShortField(int fieldNumber) {
        return (Short)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public String fetchStringField(int fieldNumber) {
        return (String)this.cachedPC.getFieldValue(fieldNumber);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        Object value = this.cachedPC.getFieldValue(fieldNumber);
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType != RelationType.NONE) {
            if (value != null) {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    Collection coll = (Collection)value;
                    try {
                        Collection fieldColl = (Collection)coll.getClass().newInstance();
                        for (Object cachedId : coll) {
                            if (cachedId != null) {
                                fieldColl.add(this.getObjectFromCachedId(cachedId));
                                continue;
                            }
                            fieldColl.add(null);
                        }
                        return SCOUtils.wrapSCOField(this.op, fieldNumber, fieldColl, true);
                    }
                    catch (Exception e) {
                        if (this.fieldsNotLoaded == null) {
                            this.fieldsNotLoaded = new ArrayList<Integer>();
                        }
                        this.fieldsNotLoaded.add(fieldNumber);
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + value.getClass().getName(), e);
                        return null;
                    }
                }
                if (Map.class.isAssignableFrom(value.getClass())) {
                    Map map = (Map)value;
                    try {
                        Map fieldMap = (Map)map.getClass().newInstance();
                        for (Map.Entry entry : map.entrySet()) {
                            Object mapKey = null;
                            mapKey = mmd.getMap().keyIsPersistent() ? this.getObjectFromCachedId(entry.getKey()) : (Object)entry.getKey();
                            Object mapValue = null;
                            Object mapValueId = entry.getValue();
                            if (mapValueId != null) {
                                mapValue = mmd.getMap().valueIsPersistent() ? this.getObjectFromCachedId(entry.getValue()) : (Object)entry.getValue();
                            }
                            fieldMap.put(mapKey, mapValue);
                        }
                        return SCOUtils.wrapSCOField(this.op, fieldNumber, fieldMap, true);
                    }
                    catch (Exception e) {
                        if (this.fieldsNotLoaded == null) {
                            this.fieldsNotLoaded = new ArrayList<Integer>();
                        }
                        this.fieldsNotLoaded.add(fieldNumber);
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + value.getClass().getName(), e);
                        return null;
                    }
                }
                if (value.getClass().isArray()) {
                    try {
                        Object[] elementOIDs = (Object[])value;
                        Class<?> componentType = mmd.getType().getComponentType();
                        Object fieldArr = Array.newInstance(componentType, elementOIDs.length);
                        boolean persistableElement = this.ec.getApiAdapter().isPersistable(componentType);
                        for (int i = 0; i < elementOIDs.length; ++i) {
                            Object element = null;
                            if (elementOIDs[i] != null) {
                                element = componentType.isInterface() || persistableElement || componentType == Object.class ? this.getObjectFromCachedId(elementOIDs[i]) : elementOIDs[i];
                            }
                            Array.set(fieldArr, i, element);
                        }
                        return fieldArr;
                    }
                    catch (NucleusException ne) {
                        if (this.fieldsNotLoaded == null) {
                            this.fieldsNotLoaded = new ArrayList<Integer>();
                        }
                        this.fieldsNotLoaded.add(fieldNumber);
                        NucleusLogger.CACHE.error("Exception thrown trying to find element of array while getting object with id " + this.op.getInternalObjectId() + " from the L2 cache", ne);
                        return null;
                    }
                }
                if ((mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) && this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded") && value instanceof CachedPC) {
                    CachedPC valueCachedPC = (CachedPC)value;
                    AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(valueCachedPC.getObjectClass(), this.ec.getClassLoaderResolver());
                    int[] fieldsToLoad = ClassUtils.getFlagsSetTo(valueCachedPC.getLoadedFields(), cmd.getAllMemberPositions(), true);
                    ObjectProvider valueOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, cmd, this.op, mmd.getAbsoluteFieldNumber());
                    valueOP.replaceFields(fieldsToLoad, new L2CacheRetrieveFieldManager(valueOP, valueCachedPC));
                    return valueOP.getObject();
                }
                try {
                    return this.getObjectFromCachedId(value);
                }
                catch (NucleusObjectNotFoundException nonfe) {
                    if (this.fieldsNotLoaded == null) {
                        this.fieldsNotLoaded = new ArrayList<Integer>();
                    }
                    this.fieldsNotLoaded.add(fieldNumber);
                    return null;
                }
            }
            return null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof StringBuffer) {
            return new StringBuffer(((StringBuffer)value).toString());
        }
        if (value instanceof StringBuilder) {
            return new StringBuilder(((StringBuilder)value).toString());
        }
        if (value instanceof Date) {
            value = ((Date)value).clone();
        } else if (value instanceof Calendar) {
            value = ((Calendar)value).clone();
        }
        boolean[] mutables = mmd.getAbstractClassMetaData().getSCOMutableMemberFlags();
        if (mutables[fieldNumber]) {
            return SCOUtils.wrapSCOField(this.op, fieldNumber, value, true);
        }
        return value;
    }

    private Object getObjectFromCachedId(Object cachedId) {
        Object pcId = null;
        String pcClassName = null;
        if (cachedId instanceof CachedPC.CachedId) {
            CachedPC.CachedId cId = (CachedPC.CachedId)cachedId;
            pcId = cId.getId();
            pcClassName = cId.getClassName();
        } else {
            pcId = cachedId;
            pcClassName = IdentityUtils.getTargetClassNameForIdentitySimple(pcId);
        }
        Class pcCls = this.ec.getClassLoaderResolver().classForName(pcClassName);
        return this.ec.findObject(pcId, null, pcCls, false, false);
    }
}

