/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class PriorityQueue
extends java.util.PriorityQueue
implements SCOCollection<java.util.PriorityQueue>,
Cloneable {
    protected ObjectProvider ownerOP;
    protected AbstractMemberMetaData ownerMmd;
    protected java.util.PriorityQueue delegate;

    public PriorityQueue(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        super(1);
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.PriorityQueue newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.PriorityQueue c) {
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    protected void initialiseDelegate() {
        Comparator comparator = SCOUtils.getComparator(this.ownerMmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
    }

    @Override
    public java.util.PriorityQueue getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.PriorityQueue value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(Object element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.PriorityQueue detachCopy(FetchPlanState state) {
        java.util.PriorityQueue detached = new java.util.PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.PriorityQueue value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        SCOUtils.attachCopyElements(this.ownerOP, this, value, elementsWithoutIdentity);
    }

    @Override
    public Object clone() {
        return null;
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, null, true);
    }

    @Override
    public synchronized Object peek() {
        return this.delegate.peek();
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public synchronized boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
                }
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized void clear() {
        if (this.ownerOP != null && !this.delegate.isEmpty()) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                ArrayList copy = new ArrayList(this.delegate);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                ArrayList copy = new ArrayList(this.delegate);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized boolean offer(Object element) {
        return this.add(element);
    }

    @Override
    public synchronized Object poll() {
        Object obj = this.delegate.poll();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    @Override
    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean removeAll(Collection elements) {
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && elements != null && !elements.isEmpty()) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.PriorityQueue(this.delegate);
    }
}

