/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.StringTokenizer;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JPQLQueryHelper;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPQLSingleStringParser {
    private Query query;
    private String queryString;

    public JPQLSingleStringParser(Query query, String queryString) {
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(Localiser.msg("043000", queryString));
        }
        this.query = query;
        this.queryString = queryString;
    }

    public void parse() {
        new Compiler(new Parser(this.queryString)).compile();
    }

    private static class Parser {
        final String queryString;
        int queryStringPos = 0;
        final String[] tokens;
        final String[] keywords;
        int tokenIndex = -1;

        public Parser(String str) {
            this.queryString = str;
            StringTokenizer tokenizer = new StringTokenizer(str);
            this.tokens = new String[tokenizer.countTokens()];
            this.keywords = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.tokens[i++] = tokenizer.nextToken();
            }
            for (i = 0; i < this.tokens.length; ++i) {
                if (JPQLQueryHelper.isKeyword(this.tokens[i])) {
                    this.keywords[i] = this.tokens[i];
                    continue;
                }
                if (i >= this.tokens.length - 1 || !JPQLQueryHelper.isKeyword(this.tokens[i] + ' ' + this.tokens[i + 1])) continue;
                this.keywords[i] = this.tokens[i];
                this.keywords[++i] = this.tokens[i];
            }
        }

        public String parseContent(String keywordToIgnore, boolean allowSubentries) {
            String content = "";
            int level = 0;
            while (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (allowSubentries) {
                    for (int i = 0; i < this.tokens[this.tokenIndex].length(); ++i) {
                        char c = this.tokens[this.tokenIndex].charAt(i);
                        if (c == '(') {
                            ++level;
                            continue;
                        }
                        if (c != ')') continue;
                        --level;
                    }
                }
                if (level == 0 && JPQLQueryHelper.isKeyword(this.tokens[this.tokenIndex]) && !this.tokens[this.tokenIndex].equals(keywordToIgnore)) {
                    --this.tokenIndex;
                    break;
                }
                if (level == 0 && this.tokenIndex < this.tokens.length - 1 && JPQLQueryHelper.isKeyword(this.tokens[this.tokenIndex] + ' ' + this.tokens[this.tokenIndex + 1])) {
                    --this.tokenIndex;
                    break;
                }
                int endPos = this.queryString.indexOf(this.tokens[this.tokenIndex], this.queryStringPos) + this.tokens[this.tokenIndex].length();
                String contentValue = this.queryString.substring(this.queryStringPos, endPos);
                this.queryStringPos = endPos;
                if (content.length() == 0) {
                    content = contentValue;
                    continue;
                }
                content = content + contentValue;
            }
            return content;
        }

        public boolean parseKeywordIgnoreCase(String keyword) {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null) {
                    if (this.keywords[this.tokenIndex].equalsIgnoreCase(keyword)) {
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex], this.queryStringPos) + this.keywords[this.tokenIndex].length() + 1;
                        return true;
                    }
                    if (keyword.indexOf(32) > -1 && (this.keywords[this.tokenIndex] + ' ' + this.keywords[this.tokenIndex + 1]).equalsIgnoreCase(keyword)) {
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex], this.queryStringPos) + this.keywords[this.tokenIndex].length() + 1;
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex + 1], this.queryStringPos) + this.keywords[this.tokenIndex + 1].length() + 1;
                        ++this.tokenIndex;
                        return true;
                    }
                }
                --this.tokenIndex;
            }
            return false;
        }

        public String parseKeyword() {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null) {
                    return this.keywords[this.tokenIndex];
                }
                --this.tokenIndex;
            }
            return null;
        }
    }

    private class Compiler {
        Parser tokenizer;
        int subqueryNum = 1;

        Compiler(Parser tokenizer) {
            this.tokenizer = tokenizer;
        }

        private void compile() {
            this.compileQuery();
            String keyword = this.tokenizer.parseKeyword();
            if (keyword != null && JPQLQueryHelper.isKeyword(keyword)) {
                throw new NucleusUserException(Localiser.msg("043001", keyword));
            }
        }

        private void compileQuery() {
            boolean insert = false;
            boolean update = false;
            boolean delete = false;
            if (!this.tokenizer.parseKeywordIgnoreCase("SELECT")) {
                if (this.tokenizer.parseKeywordIgnoreCase("INSERT")) {
                    insert = true;
                    JPQLSingleStringParser.this.query.setType((short)4);
                } else if (this.tokenizer.parseKeywordIgnoreCase("UPDATE")) {
                    update = true;
                    JPQLSingleStringParser.this.query.setType((short)1);
                } else if (this.tokenizer.parseKeywordIgnoreCase("DELETE")) {
                    delete = true;
                    JPQLSingleStringParser.this.query.setType((short)2);
                } else {
                    throw new NucleusUserException(Localiser.msg("043002"));
                }
            }
            if (update) {
                this.compileUpdate();
                if (this.tokenizer.parseKeywordIgnoreCase("WHERE")) {
                    this.compileWhere();
                }
            } else if (insert) {
                int bracketEnd;
                int bracketStart;
                String content = this.tokenizer.parseContent(null, false);
                if (content.length() > 0) {
                    if (content.startsWith("INTO")) {
                        content = content.substring(4).trim();
                    }
                    bracketStart = content.indexOf(40);
                    bracketEnd = content.indexOf(41);
                    if (bracketStart < 0 || bracketEnd < 0) {
                        throw new NucleusUserException("INSERT [INTO] {entity} should be followed by '(field1, field2, ...)' but isn't");
                    }
                } else {
                    throw new NucleusUserException("INSERT [INTO] should be followed by '{entity} (field1, field2, ...)' but isn't");
                }
                String entityString = content.substring(0, bracketStart).trim();
                String fieldString = content.substring(bracketStart + 1, bracketEnd).trim();
                JPQLSingleStringParser.this.query.setFrom(entityString);
                JPQLSingleStringParser.this.query.setInsertFields(fieldString);
                String selectQuery = this.tokenizer.queryString.substring(this.tokenizer.queryStringPos).trim();
                while (this.tokenizer.parseKeyword() != null) {
                }
                JPQLSingleStringParser.this.query.setInsertSelectQuery(selectQuery);
            } else if (delete) {
                if (this.tokenizer.parseKeywordIgnoreCase("FROM")) {
                    this.compileFrom();
                }
                if (this.tokenizer.parseKeywordIgnoreCase("WHERE")) {
                    this.compileWhere();
                }
            } else {
                this.compileResult();
                if (this.tokenizer.parseKeywordIgnoreCase("FROM")) {
                    this.compileFrom();
                }
                if (this.tokenizer.parseKeywordIgnoreCase("WHERE")) {
                    this.compileWhere();
                }
                if (this.tokenizer.parseKeywordIgnoreCase("GROUP BY")) {
                    this.compileGroup();
                }
                if (this.tokenizer.parseKeywordIgnoreCase("HAVING")) {
                    this.compileHaving();
                }
                if (this.tokenizer.parseKeywordIgnoreCase("ORDER BY")) {
                    this.compileOrder();
                }
            }
        }

        private void compileResult() {
            String content = this.tokenizer.parseContent(null, true);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043004", "SELECT", "<result>"));
            }
            if (content.toUpperCase().indexOf("SELECT ") > 0) {
                String substitutedContent = this.processContentWithSubqueries(content);
                JPQLSingleStringParser.this.query.setResult(substitutedContent);
            } else {
                JPQLSingleStringParser.this.query.setResult(content);
            }
        }

        private void compileUpdate() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043010"));
            }
            String contentUpper = content.toUpperCase();
            int setIndex = contentUpper.indexOf("SET");
            if (setIndex < 0) {
                throw new NucleusUserException(Localiser.msg("043011"));
            }
            JPQLSingleStringParser.this.query.setFrom(content.substring(0, setIndex).trim());
            JPQLSingleStringParser.this.query.setUpdate(content.substring(setIndex + 3).trim());
        }

        private void compileFrom() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() > 0) {
                JPQLSingleStringParser.this.query.setFrom(content);
            }
        }

        private void compileWhere() {
            String content = this.tokenizer.parseContent("FROM", true);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043004", "WHERE", "<filter>"));
            }
            if (content.toUpperCase().indexOf("SELECT ") > 0) {
                String substitutedContent = this.processContentWithSubqueries(content);
                JPQLSingleStringParser.this.query.setFilter(substitutedContent);
            } else {
                JPQLSingleStringParser.this.query.setFilter(content);
            }
        }

        private void compileGroup() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043004", "GROUP BY", "<grouping>"));
            }
            JPQLSingleStringParser.this.query.setGrouping(content);
        }

        private void compileHaving() {
            String content = this.tokenizer.parseContent("FROM", true);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043004", "HAVING", "<having>"));
            }
            if (content.toUpperCase().indexOf("SELECT ") > 0) {
                String substitutedContent = this.processContentWithSubqueries(content);
                JPQLSingleStringParser.this.query.setHaving(substitutedContent);
            } else {
                JPQLSingleStringParser.this.query.setHaving(content);
            }
        }

        private void compileOrder() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(Localiser.msg("043004", "ORDER BY", "<ordering>"));
            }
            JPQLSingleStringParser.this.query.setOrdering(content);
        }

        private String processContentWithSubqueries(String content) {
            StringBuilder stringContent = new StringBuilder();
            boolean withinLiteralDouble = false;
            boolean withinLiteralSingle = false;
            for (int i = 0; i < content.length(); ++i) {
                String remains;
                boolean subqueryProcessed = false;
                char chr = content.charAt(i);
                if (chr == '\"') {
                    withinLiteralDouble = !withinLiteralDouble;
                } else if (chr == '\'') {
                    boolean bl = withinLiteralSingle = !withinLiteralSingle;
                }
                if (!withinLiteralDouble && !withinLiteralSingle && chr == '(' && (remains = content.substring(i + 1).trim()).toUpperCase().startsWith("SELECT")) {
                    remains = content.substring(i);
                    int endPosition = -1;
                    int braceLevel = 0;
                    for (int j = 1; j < remains.length(); ++j) {
                        if (remains.charAt(j) == '(') {
                            ++braceLevel;
                            continue;
                        }
                        if (remains.charAt(j) != ')' || --braceLevel >= 0) continue;
                        endPosition = i + j;
                        break;
                    }
                    if (endPosition < 0) {
                        throw new NucleusUserException(Localiser.msg("042017"));
                    }
                    String subqueryStr = content.substring(i + 1, endPosition).trim();
                    String subqueryVarName = "DN_SUBQUERY_" + this.subqueryNum;
                    Query subquery = (Query)ClassUtils.newInstance(JPQLSingleStringParser.this.query.getClass(), new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, String.class}, new Object[]{JPQLSingleStringParser.this.query.getStoreManager(), JPQLSingleStringParser.this.query.getExecutionContext(), subqueryStr});
                    JPQLSingleStringParser.this.query.addSubquery(subquery, "double " + subqueryVarName, null, null);
                    if (stringContent.length() > 0 && stringContent.charAt(stringContent.length() - 1) != ' ') {
                        stringContent.append(' ');
                    }
                    stringContent.append(subqueryVarName);
                    i = endPosition;
                    ++this.subqueryNum;
                    subqueryProcessed = true;
                }
                if (subqueryProcessed) continue;
                stringContent.append(chr);
            }
            if (withinLiteralDouble || withinLiteralSingle) {
                throw new NucleusUserException(Localiser.msg("042017"));
            }
            return stringContent.toString();
        }
    }
}

