/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Calendar;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateSqlDateConverter
implements TypeConverter<LocalDate, Date> {
    private static final long serialVersionUID = -4923966747560026044L;

    @Override
    public LocalDate toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        LocalDate localDate = LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
        return localDate;
    }

    @Override
    public Date toDatastoreType(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(localDate.getYear(), localDate.getMonth().ordinal(), localDate.getDayOfMonth());
        return new Date(cal.getTimeInMillis());
    }
}

