/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalTimeDateConverter
implements TypeConverter<LocalTime, Date> {
    private static final long serialVersionUID = -2093237215554953399L;

    @Override
    public LocalTime toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return LocalTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
    }

    @Override
    public Date toDatastoreType(LocalTime time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0, time.getHour(), time.getMinute(), time.getSecond());
        cal.set(14, time.getNano() / 1000000);
        return new Date(cal.getTimeInMillis());
    }
}

