/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory;

import java.util.List;
import java.util.Optional;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;

public class OptionalOrElseMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return null;
        }
        if (!(invokedValue instanceof Optional)) {
            throw new NucleusException(Localiser.msg("021011", method, invokedValue.getClass().getName()));
        }
        List<Expression> args = expr.getArguments();
        if (args == null || args.isEmpty() || args.size() != 1) {
            throw new NucleusException("orElse requires one argument");
        }
        Expression argExpr = args.get(0);
        Object argument = null;
        if (argExpr instanceof Literal) {
            argument = ((Literal)argExpr).getLiteral();
        } else if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            argument = eval.getValueForPrimaryExpression(primExpr);
        } else if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            argument = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (argExpr instanceof InvokeExpression) {
            argument = eval.getValueForInvokeExpression((InvokeExpression)argExpr);
        } else if (argExpr instanceof DyadicExpression) {
            argument = ((DyadicExpression)argExpr).evaluate(eval);
        } else {
            throw new NucleusException(method + "(param1) where param is instanceof " + argExpr.getClass().getName() + " not supported");
        }
        return ((Optional)invokedValue).orElse(argument);
    }
}

