/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.BeanValidatorHandler;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextPool;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.NucleusContextHelper;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.NullLevel2Cache;
import org.datanucleus.enhancer.ImplementationCreatorImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.DatastoreInitialisationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreUniqueLongId;
import org.datanucleus.identity.IdentityManager;
import org.datanucleus.identity.IdentityManagerImpl;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.FactoryStatistics;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.properties.StringPropertyValidator;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.ObjectProviderFactoryImpl;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.MultiTenancyProvider;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.SchemaScriptAwareStoreManager;
import org.datanucleus.store.schema.SchemaTool;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.jta.JTASyncRegistry;
import org.datanucleus.transaction.jta.JTASyncRegistryUnavailableException;
import org.datanucleus.transaction.jta.TransactionManagerFinder;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PersistenceNucleusContextImpl
extends AbstractNucleusContext
implements Serializable,
PersistenceNucleusContext {
    private static final long serialVersionUID = 7166558862250068749L;
    private transient StoreManager storeMgr = null;
    private boolean federated = false;
    private transient AutoStartMechanism starter = null;
    private boolean jca = false;
    private Level2Cache cache;
    private transient TransactionManager txManager = null;
    private transient javax.transaction.TransactionManager jtaTxManager = null;
    private transient JTASyncRegistry jtaSyncRegistry = null;
    private transient ManagementManager jmxManager = null;
    private transient FactoryStatistics statistics = null;
    private IdentityManager identityManager;
    private ImplementationCreator implCreator;
    private List<ExecutionContext.LifecycleListener> executionContextListeners = new ArrayList<ExecutionContext.LifecycleListener>();
    private transient FetchGroupManager fetchGrpMgr;
    private transient Object validatorFactory = null;
    private transient boolean validatorFactoryInit = false;
    private ExecutionContextPool ecPool = null;
    private ObjectProviderFactory opFactory = null;
    private MultiTenancyProvider multiTenancyProvider = null;

    public PersistenceNucleusContextImpl(String apiName, Map startupProps) {
        this(apiName, startupProps, null);
    }

    public PersistenceNucleusContextImpl(String apiName, Map startupProps, PluginManager pluginMgr) {
        super(apiName, startupProps, pluginMgr);
    }

    @Override
    public void applyDefaultProperties(Configuration conf) {
        super.applyDefaultProperties(conf);
        conf.addDefaultBooleanProperty("datanucleus.IgnoreCache", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.Optimistic", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.Multithreaded", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.RetainValues", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.RestoreValues", null, false, false, true);
        conf.addDefaultProperty("datanucleus.jmxType", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.enableStatistics", null, false, false, false);
        conf.addDefaultProperty("datanucleus.Name", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.PersistenceUnitName", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.persistenceXmlFilename", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.ServerTimeZoneID", null, null, CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.propertiesFile", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.persistenceUnitLoadClasses", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.executionContext.reaperThread", null, false, false, false);
        conf.addDefaultIntegerProperty("datanucleus.executionContext.maxIdle", null, 20, false, false);
        conf.addDefaultProperty("datanucleus.executionContext.closeActiveTxAction", null, "exception", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultBooleanProperty("datanucleus.objectProvider.reaperThread", null, false, false, false);
        conf.addDefaultIntegerProperty("datanucleus.objectProvider.maxIdle", null, 0, false, false);
        conf.addDefaultProperty("datanucleus.objectProvider.className", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.datastoreIdentityType", null, "datanucleus", null, false, false);
        conf.addDefaultProperty("datanucleus.identityStringTranslatorType", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.identityKeyTranslatorType", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.useImplementationCreator", null, true, false, false);
        conf.addDefaultProperty("datanucleus.TransactionType", null, null, CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.jtaLocator", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.jtaJndiLocation", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.transactionIsolation", null, "read-committed", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultBooleanProperty("datanucleus.NontransactionalRead", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.NontransactionalWrite", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.nontx.atomic", null, true, false, true);
        conf.addDefaultIntegerProperty("datanucleus.datastoreTransactionFlushLimit", null, 1, false, false);
        conf.addDefaultProperty("datanucleus.flush.mode", null, null, CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultProperty("datanucleus.valuegeneration.transactionIsolation", null, "read-committed", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.valuegeneration.transactionAttribute", null, "NEW", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultIntegerProperty("datanucleus.valuegeneration.sequence.allocationSize", null, 10, false, false);
        conf.addDefaultIntegerProperty("datanucleus.valuegeneration.increment.allocationSize", null, 10, false, false);
        conf.addDefaultProperty("datanucleus.validation.mode", null, "auto", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.validation.group.pre-persist", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.validation.group.pre-update", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.validation.group.pre-remove", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.validation.factory", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.storeManagerType", null, null, null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.readOnlyDatastore", null, false, false, true);
        conf.addDefaultProperty("datanucleus.readOnlyDatastoreAction", null, "EXCEPTION", CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultBooleanProperty("datanucleus.generateSchema.create-schemas", null, false, false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.database.mode", null, "none", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.mode", null, "none", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.create.target", null, "datanucleus-schema-create.ddl", null, false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.drop.target", null, "datanucleus-schema-drop.ddl", null, false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.create.source", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.drop.source", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.generateSchema.scripts.load", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.cache.level1.type", null, "soft", null, false, false);
        conf.addDefaultProperty("datanucleus.cache.level2.type", null, "soft", null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.collections", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.cache.collections.lazy", null, null, false, false);
        conf.addDefaultProperty("datanucleus.cache.level2.mode", null, "UNSPECIFIED", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.cache.level2.cacheName", null, "datanucleus", null, false, false);
        conf.addDefaultIntegerProperty("datanucleus.cache.level2.maxSize", null, -1, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.loadFields", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.clearAtClose", null, true, false, false);
        conf.addDefaultIntegerProperty("datanucleus.cache.level2.timeout", null, -1, false, false);
        conf.addDefaultIntegerProperty("datanucleus.cache.level2.batchSize", null, 100, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.cacheEmbedded", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.readThrough", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.writeThrough", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.statisticsEnabled", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.cache.level2.storeByValue", null, true, false, false);
        conf.addDefaultProperty("datanucleus.cache.level2.retrieveMode", null, "use", CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultProperty("datanucleus.cache.level2.storeMode", null, "use", CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultProperty("datanucleus.cache.level2.updateMode", null, "commit-and-datastore-read", CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultProperty("datanucleus.cache.queryCompilation.type", null, "soft", null, false, false);
        conf.addDefaultProperty("datanucleus.cache.queryCompilationDatastore.type", null, "soft", null, false, false);
        conf.addDefaultProperty("datanucleus.cache.queryResults.type", null, "soft", null, false, false);
        conf.addDefaultProperty("datanucleus.cache.queryResults.cacheName", null, "datanucleus-query", null, false, false);
        conf.addDefaultIntegerProperty("datanucleus.cache.queryResults.maxSize", null, -1, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.sql.allowAll", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.query.jdoql.allowAll", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.query.flushBeforeExecution", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.useFetchPlan", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.checkUnusedParameters", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.compileOptimised", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.loadResultsAtCommit", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.compilation.cached", null, true, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.results.cached", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.evaluateInMemory", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.resultCache.validateObjects", null, true, false, false);
        conf.addDefaultProperty("datanucleus.query.resultSizeMethod", null, "last", null, false, false);
        conf.addDefaultBooleanProperty("datanucleus.query.compileNamedQueriesAtStartup", null, false, false, false);
        conf.addDefaultBooleanProperty("datanucleus.persistenceByReachabilityAtCommit", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.manageRelationships", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.manageRelationshipsChecks", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.SerializeRead", null, false, false, true);
        conf.addDefaultProperty("datanucleus.deletionPolicy", null, "JDO2", CorePropertyValidator.class.getName(), false, true);
        conf.addDefaultBooleanProperty("datanucleus.findObject.validateWhenCached", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.findObject.typeConversion", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.allowCallbacks", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.DetachAllOnCommit", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.DetachAllOnRollback", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.DetachOnClose", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.CopyOnAttach", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.attachSameDatastore", null, true, false, true);
        conf.addDefaultBooleanProperty("datanucleus.allowAttachOfTransient", null, false, false, true);
        conf.addDefaultBooleanProperty("datanucleus.detachAsWrapped", null, false, false, true);
        conf.addDefaultProperty("datanucleus.detachmentFields", null, "load-fields", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultProperty("datanucleus.detachedState", null, "fetch-groups", CorePropertyValidator.class.getName(), false, false);
        conf.addDefaultIntegerProperty("datanucleus.maxFetchDepth", null, 1, false, true);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateAll", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateSchema", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateTables", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateColumns", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateConstraints", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.autoCreateWarnOnError", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.validateAll", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.validateTables", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.validateColumns", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.schema.validateConstraints", null, false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.autoCreateSchema", "datanucleus.schema.autoCreateAll", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.autoCreateTables", "datanucleus.schema.autoCreateTables", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.autoCreateColumns", "datanucleus.schema.autoCreateColumns", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.autoCreateConstraints", "datanucleus.schema.autoCreateConstraints", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.validateSchema", "datanucleus.schema.validateAll", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.validateTables", "datanucleus.schema.validateTables", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.validateColumns", "datanucleus.schema.validateColumns", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.validateConstraints", "datanucleus.schema.validateConstraints", false, true, false);
        conf.addDefaultBooleanProperty("datanucleus.autoCreateWarnOnError", "datanucleus.schema.autoCreateWarnOnError", false, true, false);
        conf.addDefaultProperty("datanucleus.identifier.namingFactory", null, "datanucleus2", null, true, false);
        conf.addDefaultProperty("datanucleus.identifier.case", null, null, CorePropertyValidator.class.getName(), true, false);
        conf.addDefaultProperty("datanucleus.identifier.tablePrefix", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.identifier.tableSuffix", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.identifier.wordSeparator", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.identifierFactory", null, "datanucleus2", null, true, false);
        conf.addDefaultIntegerProperty("datanucleus.datastoreReadTimeout", null, null, true, true);
        conf.addDefaultIntegerProperty("datanucleus.datastoreWriteTimeout", null, null, true, true);
        conf.addDefaultBooleanProperty("datanucleus.store.allowReferencesWithNoImplementations", null, false, false, true);
        conf.addDefaultProperty("datanucleus.mapping", null, null, StringPropertyValidator.class.getName(), true, false);
        conf.addDefaultProperty("datanucleus.mapping.Catalog", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.mapping.Schema", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.TenantID", null, null, null, false, true);
        conf.addDefaultProperty("datanucleus.TenantProvider", null, null, null, false, false);
        conf.addDefaultProperty("datanucleus.autoStartMechanism", null, "None", null, true, false);
        conf.addDefaultProperty("datanucleus.autoStartMechanismMode", null, "Quiet", CorePropertyValidator.class.getName(), true, false);
        conf.addDefaultProperty("datanucleus.autoStartMechanismXmlFile", null, "datanucleusAutoStart.xml", null, true, false);
        conf.addDefaultProperty("datanucleus.autoStartClassNames", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.autoStartMetaDataFiles", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionURL", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionDriverName", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionUserName", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionPassword", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionPasswordDecrypter", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionFactoryName", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionFactory2Name", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionFactory", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.ConnectionFactory2", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.connection.resourceType", null, null, CorePropertyValidator.class.getName(), true, false);
        conf.addDefaultProperty("datanucleus.connection2.resourceType", null, null, CorePropertyValidator.class.getName(), true, false);
        conf.addDefaultProperty("datanucleus.connectionPoolingType", null, null, null, true, false);
        conf.addDefaultProperty("datanucleus.connectionPoolingType.nontx", null, null, null, true, false);
        conf.addDefaultBooleanProperty("datanucleus.connection.nontx.releaseAfterUse", null, true, true, false);
        conf.addDefaultBooleanProperty("datanucleus.connection.singleConnectionPerExecutionContext", null, false, true, false);
    }

    @Override
    public synchronized void initialise() {
        String autoStartMechanism;
        final ClassLoaderResolver clr = this.getClassLoaderResolver(null);
        clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
        boolean generateSchema = false;
        boolean generateScripts = false;
        String generateModeStr = this.config.getStringProperty("datanucleus.generateSchema.database.mode");
        if (generateModeStr == null || generateModeStr.equalsIgnoreCase("none")) {
            generateModeStr = this.config.getStringProperty("datanucleus.generateSchema.scripts.mode");
            generateScripts = true;
        }
        if (generateModeStr != null && !generateModeStr.equalsIgnoreCase("none")) {
            generateSchema = true;
            if (!this.config.getBooleanProperty("datanucleus.schema.autoCreateAll")) {
                this.config.setProperty("datanucleus.schema.autoCreateAll", "true");
            }
            if (!this.config.getBooleanProperty("datanucleus.schema.autoCreateTables")) {
                this.config.setProperty("datanucleus.schema.autoCreateTables", "true");
            }
            if (!this.config.getBooleanProperty("datanucleus.schema.autoCreateColumns")) {
                this.config.setProperty("datanucleus.schema.autoCreateColumns", "true");
            }
            if (!this.config.getBooleanProperty("datanucleus.schema.autoCreateConstraints")) {
                this.config.setProperty("datanucleus.schema.autoCreateConstraints", "true");
            }
            if (!this.config.getBooleanProperty("datanucleus.readOnlyDatastore")) {
                this.config.setProperty("datanucleus.readOnlyDatastore", "false");
            }
        }
        try {
            Set<String> propNamesWithDatastore = this.config.getPropertyNamesWithPrefix("datanucleus.datastore.");
            if (propNamesWithDatastore == null) {
                String reqdIsolation;
                NucleusLogger.DATASTORE.debug("Creating StoreManager for datastore");
                Map<String, Object> datastoreProps = this.config.getDatastoreProperties();
                this.storeMgr = NucleusContextHelper.createStoreManagerForProperties(this.config.getPersistenceProperties(), datastoreProps, clr, this);
                String transactionIsolation = this.config.getStringProperty("datanucleus.transactionIsolation");
                if (transactionIsolation != null && !transactionIsolation.equalsIgnoreCase(reqdIsolation = NucleusContextHelper.getTransactionIsolationForStoreManager(this.storeMgr, transactionIsolation))) {
                    this.config.setProperty("datanucleus.transactionIsolation", reqdIsolation);
                }
            } else {
                NucleusLogger.DATASTORE.debug("Creating FederatedStoreManager to handle federation of primary StoreManager and " + propNamesWithDatastore.size() + " secondary datastores");
                this.storeMgr = new FederatedStoreManager(clr, this);
                this.federated = true;
            }
        }
        catch (NucleusException ne) {
            NucleusLogger.DATASTORE.error("Exception thrown creating StoreManager. See the nested exception", ne);
            throw ne;
        }
        NucleusLogger.DATASTORE.debug("StoreManager now created");
        MetaDataManager mmgr = this.getMetaDataManager();
        final Level2Cache cache = this.getLevel2Cache();
        if (cache != null) {
            mmgr.registerListener(new MetaDataListener(){

                @Override
                public void loaded(AbstractClassMetaData cmd) {
                    if (cmd.hasExtension("cache-pin") && cmd.getValueForExtension("cache-pin").equalsIgnoreCase("true")) {
                        Class cls = clr.classForName(cmd.getFullClassName());
                        cache.pinAll(cls, false);
                    }
                }
            });
        }
        if ((autoStartMechanism = this.config.getStringProperty("datanucleus.autoStartMechanism")) != null && !autoStartMechanism.equals("None")) {
            this.initialiseAutoStart(clr);
        }
        if (generateSchema) {
            this.initialiseSchema(generateModeStr, generateScripts);
        }
        if (this.config.getStringProperty("datanucleus.PersistenceUnitName") != null && this.config.getBooleanProperty("datanucleus.persistenceUnitLoadClasses")) {
            Collection<String> loadedClasses = this.getMetaDataManager().getClassesWithMetaData();
            this.storeMgr.manageClasses(clr, loadedClasses.toArray(new String[loadedClasses.size()]));
        }
        if (this.config.getBooleanProperty("datanucleus.query.compileNamedQueriesAtStartup")) {
            this.initialiseNamedQueries(clr);
        }
        if (this.ecPool == null) {
            this.ecPool = new ExecutionContextPool(this);
        }
        if (this.opFactory == null) {
            this.opFactory = new ObjectProviderFactoryImpl(this);
        }
        if (this.config.hasProperty("datanucleus.TenantProvider")) {
            try {
                this.multiTenancyProvider = (MultiTenancyProvider)this.config.getProperty("datanucleus.TenantProvider");
            }
            catch (Throwable thr) {
                NucleusLogger.PERSISTENCE.warn("Error accessing property datanucleus.TenantProvider; should be an instance of MultiTenancyProvider but isnt! Ignored");
            }
        }
        super.initialise();
    }

    @Override
    public synchronized void close() {
        if (this.opFactory != null) {
            this.opFactory.close();
            this.opFactory = null;
        }
        if (this.ecPool != null) {
            this.ecPool.cleanUp();
            this.ecPool = null;
        }
        if (this.fetchGrpMgr != null) {
            this.fetchGrpMgr.clearFetchGroups();
        }
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.statistics != null) {
            if (this.jmxManager != null) {
                this.jmxManager.deregisterMBean(this.statistics.getRegisteredName());
            }
            this.statistics = null;
        }
        if (this.jmxManager != null) {
            this.jmxManager.close();
            this.jmxManager = null;
        }
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
            NucleusLogger.CACHE.debug(Localiser.msg("004009"));
        }
        if (this.classLoaderResolverMap != null) {
            this.classLoaderResolverMap.clear();
            this.classLoaderResolverMap = null;
        }
        if (this.typeManager != null) {
            this.typeManager = null;
        }
        this.identityManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialiseAutoStart(ClassLoaderResolver clr) throws DatastoreInitialisationException {
        String autoStartMechanism = this.config.getStringProperty("datanucleus.autoStartMechanism");
        String autoStarterClassName = this.getPluginManager().getAttributeValueForExtension("org.datanucleus.autostart", "name", autoStartMechanism, "class-name");
        if (autoStarterClassName != null) {
            String mode = this.config.getStringProperty("datanucleus.autoStartMechanismMode");
            Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.CLASS_LOADER_RESOLVER};
            Object[] args = new Object[]{this.storeMgr, clr};
            try {
                this.starter = (AutoStartMechanism)this.getPluginManager().createExecutableExtension("org.datanucleus.autostart", "name", autoStartMechanism, "class-name", argsClass, args);
                if (mode.equalsIgnoreCase("None")) {
                    this.starter.setMode(AutoStartMechanism.Mode.NONE);
                } else if (mode.equalsIgnoreCase("Checked")) {
                    this.starter.setMode(AutoStartMechanism.Mode.CHECKED);
                } else if (mode.equalsIgnoreCase("Quiet")) {
                    this.starter.setMode(AutoStartMechanism.Mode.QUIET);
                } else if (mode.equalsIgnoreCase("Ignored")) {
                    this.starter.setMode(AutoStartMechanism.Mode.IGNORED);
                }
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
            }
        }
        if (this.starter == null) {
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("034005", autoStartMechanism));
        }
        boolean illegalState = false;
        try {
            Collection existingData;
            if (!this.starter.isOpen()) {
                this.starter.open();
            }
            if ((existingData = this.starter.getAllClassData()) != null && existingData.size() > 0) {
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                for (StoreData data : existingData) {
                    Class classFound;
                    block34: {
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block34;
                            try {
                                this.getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException classNotResolvedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(Localiser.msg("032003", data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = Localiser.msg("034004", data.getName());
                        if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(Localiser.msg("034001", data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = Localiser.msg("034000", data.getName());
                    if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("034001", data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.storeMgr.manageClasses(clr, classesToLoad);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(Localiser.msg("034002", e));
                    illegalState = true;
                }
            }
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("034003"));
                this.starter = null;
            }
            if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) return;
        }
        catch (Throwable throwable) {
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("034003"));
                this.starter = null;
            }
            if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) throw throwable;
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("034006", autoStartMechanism));
            throw throwable;
        }
        NucleusLogger.PERSISTENCE.debug(Localiser.msg("034006", autoStartMechanism));
    }

    @Override
    protected void logConfigurationDetails() {
        String autoStartMechanism;
        String timeZoneID = this.config.getStringProperty("datanucleus.ServerTimeZoneID");
        if (timeZoneID == null) {
            timeZoneID = TimeZone.getDefault().getID();
        }
        NucleusLogger.PERSISTENCE.debug("Persistence : " + (this.config.getBooleanProperty("datanucleus.Multithreaded") ? "pm-multithreaded" : "pm-singlethreaded") + (this.config.getBooleanProperty("datanucleus.RetainValues") ? ", retain-values" : "") + (this.config.getBooleanProperty("datanucleus.RestoreValues") ? ", restore-values" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalRead") ? ", nontransactional-read" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalWrite") ? ", nontransactional-write" : "") + (this.config.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") ? ", reachability-at-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnCommit") ? ", detach-all-on-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnRollback") ? ", detach-all-on-rollback" : "") + (this.config.getBooleanProperty("datanucleus.DetachOnClose") ? ", detach-on-close" : "") + (this.config.getBooleanProperty("datanucleus.CopyOnAttach") ? ", copy-on-attach" : "") + (this.config.getBooleanProperty("datanucleus.manageRelationships") ? (this.config.getBooleanProperty("datanucleus.manageRelationshipsChecks") ? ", managed-relations(checked)" : ", managed-relations(unchecked)") : "") + ", deletion-policy=" + this.config.getStringProperty("datanucleus.deletionPolicy") + (this.config.getBooleanProperty("datanucleus.IgnoreCache") ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
        String txnType = "RESOURCE_LOCAL";
        if (TransactionType.JTA.toString().equalsIgnoreCase(this.config.getStringProperty("datanucleus.TransactionType"))) {
            txnType = this.isJcaMode() ? "JTA (via JCA adapter)" : "JTA";
        }
        if ((autoStartMechanism = this.config.getStringProperty("datanucleus.autoStartMechanism")) != null && !autoStartMechanism.equals("None")) {
            String autoStartClassNames = this.config.getStringProperty("datanucleus.autoStartClassNames");
            NucleusLogger.PERSISTENCE.debug("AutoStart : mechanism=" + autoStartMechanism + ", mode=" + this.config.getStringProperty("datanucleus.autoStartMechanismMode") + (autoStartClassNames != null ? ", classes=" + autoStartClassNames : ""));
        }
        NucleusLogger.PERSISTENCE.debug("Transactions : type=" + txnType + ", mode=" + (this.config.getBooleanProperty("datanucleus.Optimistic") ? "optimistic" : "datastore") + ", isolation=" + this.config.getStringProperty("datanucleus.transactionIsolation"));
        NucleusLogger.PERSISTENCE.debug("ValueGeneration : txn-isolation=" + this.config.getStringProperty("datanucleus.valuegeneration.transactionIsolation") + " connection=" + (this.config.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("New") ? "New" : "Existing"));
        NucleusLogger.PERSISTENCE.debug("Cache : Level1 (" + this.config.getStringProperty("datanucleus.cache.level1.type") + ")" + ", Level2 (" + this.config.getStringProperty("datanucleus.cache.level2.type") + ", mode=" + this.config.getStringProperty("datanucleus.cache.level2.mode") + ")" + ", QueryResults (" + this.config.getStringProperty("datanucleus.cache.queryResults.type") + ")" + (this.config.getBooleanProperty("datanucleus.cache.collections") ? ", Collections/Maps " : ""));
    }

    @Override
    public boolean isFederated() {
        return this.federated;
    }

    @Override
    public AutoStartMechanism getAutoStartMechanism() {
        return this.starter;
    }

    protected void initialiseNamedQueries(ClassLoaderResolver clr) {
        MetaDataManager mmgr = this.getMetaDataManager();
        Set<String> queryNames = mmgr.getNamedQueryNames();
        if (queryNames != null) {
            ExecutionContext ec = this.getExecutionContext(null, null);
            for (String queryName : queryNames) {
                QueryMetaData qmd = mmgr.getMetaDataForQuery(null, clr, queryName);
                if (!qmd.getLanguage().equals(QueryLanguage.JPQL.toString()) && !qmd.getLanguage().equals(QueryLanguage.JDOQL.toString())) continue;
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug(Localiser.msg("008017", queryName, qmd.getQuery()));
                }
                Query q = this.storeMgr.getQueryManager().newQuery(qmd.getLanguage().toString(), ec, qmd.getQuery());
                q.compile();
                q.closeAll();
            }
            ec.close();
        }
    }

    protected void initialiseSchema(String generateModeStr, boolean generateScripts) {
        SchemaTool.Mode mode = null;
        if (generateModeStr.equalsIgnoreCase("create")) {
            mode = SchemaTool.Mode.CREATE;
        } else if (generateModeStr.equalsIgnoreCase("drop")) {
            mode = SchemaTool.Mode.DELETE;
        } else if (generateModeStr.equalsIgnoreCase("drop-and-create")) {
            mode = SchemaTool.Mode.DELETE_CREATE;
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            if (mode == SchemaTool.Mode.CREATE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(Localiser.msg("014000"));
            } else if (mode == SchemaTool.Mode.DELETE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(Localiser.msg("014001"));
            } else if (mode == SchemaTool.Mode.DELETE_CREATE) {
                NucleusLogger.DATASTORE_SCHEMA.debug(Localiser.msg("014045"));
            }
        }
        TreeSet<String> schemaClassNames = null;
        MetaDataManager metaDataMgr = this.getMetaDataManager();
        FileMetaData[] filemds = metaDataMgr.getFileMetaData();
        schemaClassNames = new TreeSet<String>();
        if (filemds == null) {
            throw new NucleusUserException("No classes to process in generateSchema");
        }
        for (int i = 0; i < filemds.length; ++i) {
            for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                    String className = filemds[i].getPackage(j).getClass(k).getFullClassName();
                    if (schemaClassNames.contains(className)) continue;
                    schemaClassNames.add(className);
                }
            }
        }
        StoreManager storeMgr = this.getStoreManager();
        if (storeMgr instanceof SchemaAwareStoreManager) {
            String dropScript;
            String scriptContent;
            SchemaAwareStoreManager schemaStoreMgr = (SchemaAwareStoreManager)((Object)storeMgr);
            SchemaTool schemaTool = new SchemaTool();
            if (mode == SchemaTool.Mode.CREATE) {
                String createScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.create.source");
                if (!StringUtils.isWhitespace(createScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(createScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> createScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.create.target"));
                }
                schemaTool.createSchemaForClasses(schemaStoreMgr, schemaClassNames);
            } else if (mode == SchemaTool.Mode.DELETE) {
                dropScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.source");
                if (!StringUtils.isWhitespace(dropScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(dropScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> dropScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.target"));
                }
                schemaTool.deleteSchemaForClasses(schemaStoreMgr, schemaClassNames);
            } else if (mode == SchemaTool.Mode.DELETE_CREATE) {
                dropScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.source");
                if (!StringUtils.isWhitespace(dropScript)) {
                    scriptContent = this.getDatastoreScriptForResourceName(dropScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> dropScript=" + scriptContent);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.drop.target"));
                }
                schemaTool.deleteSchemaForClasses(schemaStoreMgr, schemaClassNames);
                String createScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.create.source");
                if (!StringUtils.isWhitespace(createScript)) {
                    String scriptContent2 = this.getDatastoreScriptForResourceName(createScript);
                    NucleusLogger.DATASTORE_SCHEMA.debug(">> createScript=" + scriptContent2);
                    if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent2)) {
                        ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent2);
                    }
                }
                if (generateScripts) {
                    schemaTool.setDdlFile(this.config.getStringProperty("datanucleus.generateSchema.scripts.create.target"));
                }
                schemaTool.createSchemaForClasses(schemaStoreMgr, schemaClassNames);
            }
            String loadScript = this.config.getStringProperty("datanucleus.generateSchema.scripts.load");
            if (!StringUtils.isWhitespace(loadScript)) {
                scriptContent = this.getDatastoreScriptForResourceName(loadScript);
                NucleusLogger.DATASTORE_SCHEMA.debug(">> loadScript=" + scriptContent);
                if (storeMgr instanceof SchemaScriptAwareStoreManager && !StringUtils.isWhitespace(scriptContent)) {
                    ((SchemaScriptAwareStoreManager)((Object)storeMgr)).executeScript(scriptContent);
                }
            }
        } else if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug(Localiser.msg("008016", StringUtils.toJVMIDString(storeMgr)));
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug(Localiser.msg("014043"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatastoreScriptForResourceName(String scriptResourceName) {
        if (StringUtils.isWhitespace(scriptResourceName)) {
            return null;
        }
        File file = new File(scriptResourceName);
        if (!file.exists()) {
            try {
                file = new File(new URI(scriptResourceName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file != null && file.exists()) {
            FileInputStream fis = null;
            try {
                int content;
                StringBuilder str = new StringBuilder();
                fis = new FileInputStream(file);
                while ((content = fis.read()) != -1) {
                    str.append((char)content);
                }
                String string = str.toString();
                return string;
            }
            catch (Exception exception) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        NucleusLogger.DATASTORE_SCHEMA.warn(Localiser.msg("014046", scriptResourceName));
        return null;
    }

    @Override
    public ExecutionContextPool getExecutionContextPool() {
        if (this.ecPool == null) {
            this.initialise();
        }
        return this.ecPool;
    }

    @Override
    public ObjectProviderFactory getObjectProviderFactory() {
        if (this.opFactory == null) {
            this.initialise();
        }
        return this.opFactory;
    }

    @Override
    public ExecutionContext getExecutionContext(Object owner, Map<String, Object> options) {
        return this.getExecutionContextPool().checkOut(owner, options);
    }

    @Override
    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = new IdentityManagerImpl(this);
        }
        return this.identityManager;
    }

    @Override
    public boolean statisticsEnabled() {
        return this.config.getBooleanProperty("datanucleus.enableStatistics") || this.getJMXManager() != null;
    }

    @Override
    public synchronized ManagementManager getJMXManager() {
        if (this.jmxManager == null && this.config.getStringProperty("datanucleus.jmxType") != null) {
            this.jmxManager = new ManagementManager(this);
        }
        return this.jmxManager;
    }

    @Override
    public synchronized FactoryStatistics getStatistics() {
        if (this.statistics == null && this.statisticsEnabled()) {
            String name = null;
            if (this.getJMXManager() != null) {
                name = this.jmxManager.getDomainName() + ":InstanceName=" + this.jmxManager.getInstanceName() + ",Type=" + FactoryStatistics.class.getName() + ",Name=Factory" + NucleusContextHelper.random.nextInt();
            }
            this.statistics = new FactoryStatistics(name);
            if (this.jmxManager != null) {
                this.jmxManager.registerMBean(this.statistics, name);
            }
        }
        return this.statistics;
    }

    @Override
    public synchronized ImplementationCreator getImplementationCreator() {
        boolean useImplCreator;
        if (this.implCreator == null && (useImplCreator = this.config.getBooleanProperty("datanucleus.useImplementationCreator"))) {
            this.implCreator = new ImplementationCreatorImpl(this.getMetaDataManager());
        }
        return this.implCreator;
    }

    @Override
    public synchronized TransactionManager getTransactionManager() {
        if (this.txManager == null) {
            this.txManager = new TransactionManager();
        }
        return this.txManager;
    }

    @Override
    public synchronized javax.transaction.TransactionManager getJtaTransactionManager() {
        if (this.jtaTxManager == null) {
            this.jtaTxManager = new TransactionManagerFinder(this).getTransactionManager(this.getClassLoaderResolver((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader")));
            if (this.jtaTxManager == null) {
                throw new NucleusTransactionException(Localiser.msg("015030"));
            }
        }
        return this.jtaTxManager;
    }

    @Override
    public JTASyncRegistry getJtaSyncRegistry() {
        if (this.jtaSyncRegistry == null) {
            try {
                this.jtaSyncRegistry = new JTASyncRegistry();
            }
            catch (JTASyncRegistryUnavailableException jsrue) {
                NucleusLogger.TRANSACTION.debug("JTA TransactionSynchronizationRegistry not found at JNDI java:comp/TransactionSynchronizationRegistry so using Transaction to register synchronisation");
                this.jtaSyncRegistry = null;
            }
        }
        return this.jtaSyncRegistry;
    }

    @Override
    public StoreManager getStoreManager() {
        if (this.storeMgr == null) {
            this.initialise();
        }
        return this.storeMgr;
    }

    @Override
    public boolean supportsORMMetaData() {
        if (this.storeMgr != null) {
            return this.storeMgr.getSupportedOptions().contains("ORM");
        }
        return true;
    }

    @Override
    public CallbackHandler getValidationHandler(ExecutionContext ec) {
        if (this.validatorFactoryInit && this.validatorFactory == null) {
            return null;
        }
        if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("none")) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            ec.getClassLoaderResolver().classForName("javax.validation.Validation");
        }
        catch (ClassNotResolvedException cnre) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            if (this.validatorFactory == null) {
                this.validatorFactoryInit = true;
                this.validatorFactory = this.config.hasPropertyNotNull("datanucleus.validation.factory") ? this.config.getProperty("datanucleus.validation.factory") : Validation.buildDefaultValidatorFactory();
            }
            return new BeanValidatorHandler(ec, (ValidatorFactory)this.validatorFactory);
        }
        catch (Throwable ex) {
            if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("callback")) {
                throw ec.getApiAdapter().getUserExceptionForException(ex.getMessage(), (Exception)ex);
            }
            NucleusLogger.GENERAL.warn("Unable to create validator handler", ex);
            return null;
        }
    }

    @Override
    public boolean hasLevel2Cache() {
        this.getLevel2Cache();
        return !(this.cache instanceof NullLevel2Cache);
    }

    @Override
    public Level2Cache getLevel2Cache() {
        if (this.cache == null) {
            String level2Type = this.config.getStringProperty("datanucleus.cache.level2.type");
            String level2ClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new NucleusUserException(Localiser.msg("004000", level2Type)).setFatal();
            }
            try {
                this.cache = (Level2Cache)this.pluginManager.createExecutableExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("004002", level2Type));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(Localiser.msg("004001", level2Type, level2ClassName), e).setFatal();
            }
        }
        return this.cache;
    }

    @Override
    public ExecutionContext.LifecycleListener[] getExecutionContextListeners() {
        return this.executionContextListeners.toArray(new ExecutionContext.LifecycleListener[this.executionContextListeners.size()]);
    }

    @Override
    public void addExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.add(listener);
    }

    @Override
    public void removeExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.remove(listener);
    }

    @Override
    public synchronized void setJcaMode(boolean jca) {
        this.jca = jca;
    }

    @Override
    public boolean isJcaMode() {
        return this.jca;
    }

    @Override
    public synchronized FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this);
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    @Override
    public void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup createInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().createFetchGroup(cls, name);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name, boolean createIfNotPresent) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver(cls.getClassLoader()));
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name, createIfNotPresent);
    }

    @Override
    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public boolean isClassWithIdentityCacheable(Object id) {
        if (id == null) {
            return false;
        }
        if (id instanceof SCOID) {
            return false;
        }
        if (id instanceof DatastoreUniqueLongId) {
            return false;
        }
        AbstractClassMetaData cmd = null;
        if (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) {
            cmd = this.getMetaDataManager().getMetaDataForClass(IdentityUtils.getTargetClassNameForIdentitySimple(id), this.getClassLoaderResolver(id.getClass().getClassLoader()));
        } else {
            Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
            if (cmds != null && !cmds.isEmpty()) {
                cmd = cmds.iterator().next();
            }
        }
        return this.isClassCacheable(cmd);
    }

    @Override
    public boolean isClassCacheable(AbstractClassMetaData cmd) {
        if (cmd != null && cmd.getIdentityType() == IdentityType.NONDURABLE) {
            return false;
        }
        String cacheMode = this.config.getStringProperty("datanucleus.cache.level2.mode");
        if (cacheMode.equalsIgnoreCase("ALL")) {
            return true;
        }
        if (cacheMode.equalsIgnoreCase("NONE")) {
            return false;
        }
        if (cacheMode.equalsIgnoreCase("ENABLE_SELECTIVE")) {
            if (cmd == null) {
                return true;
            }
            return cmd.isCacheable() != null && cmd.isCacheable() != false;
        }
        if (cacheMode.equalsIgnoreCase("DISABLE_SELECTIVE")) {
            if (cmd == null) {
                return true;
            }
            return cmd.isCacheable() == null || cmd.isCacheable() != false;
        }
        if (cmd == null) {
            return true;
        }
        Boolean cacheableFlag = cmd.isCacheable();
        if (cacheableFlag == null) {
            return true;
        }
        return cacheableFlag;
    }

    @Override
    public boolean isClassMultiTenant(AbstractClassMetaData cmd) {
        if (this.multiTenancyProvider != null || this.config.getStringProperty("datanucleus.TenantID") != null) {
            return !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"));
        }
        return false;
    }

    @Override
    public String getMultiTenancyId(ExecutionContext ec, AbstractClassMetaData cmd) {
        if (this.multiTenancyProvider != null) {
            return this.multiTenancyProvider.getTenantId(ec);
        }
        return ec.getStringProperty("datanucleus.TenantID");
    }
}

