/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TransactionImpl
implements org.datanucleus.Transaction {
    ExecutionContext ec;
    TransactionManager txnMgr;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean rollbackOnly = false;
    protected Boolean serializeRead = null;
    private Set<TransactionEventListener> listenersPerTransaction = new HashSet<TransactionEventListener>();
    private TransactionEventListener ecListener;
    private List<TransactionEventListener> userListeners = new ArrayList<TransactionEventListener>();
    private Map<String, Object> options = null;
    long beginTime;
    boolean closed = false;
    private PropertyStore properties;

    public TransactionImpl(ExecutionContext ec, PropertyStore properties) {
        this.ec = ec;
        this.ecListener = (TransactionEventListener)((Object)ec);
        this.txnMgr = ec.getNucleusContext().getTransactionManager();
        this.properties = properties;
        Configuration config = ec.getNucleusContext().getConfiguration();
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        if (properties != null) {
            Boolean serialiseReadProp = properties.getFrequentProperties().getSerialiseRead();
            this.serializeRead = serialiseReadProp == null ? this.serializeRead : serialiseReadProp;
        } else {
            Boolean serialiseReadProp = config.getBooleanObjectProperty("datanucleus.SerializeRead");
            if (ec.getProperty("datanucleus.SerializeRead") != null) {
                serialiseReadProp = ec.getBooleanProperty("datanucleus.SerializeRead");
            }
            if (serialiseReadProp != null) {
                this.serializeRead = serialiseReadProp;
            }
        }
    }

    @Override
    public void close() {
        this.userListeners = null;
        this.listenersPerTransaction = null;
        this.options = null;
        this.txnMgr = null;
        this.ec = null;
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.begin(this.ec);
            }
        } else {
            this.txnMgr.begin(this.ec);
        }
        this.internalBegin();
    }

    protected void internalBegin() {
        TransactionEventListener[] ls;
        if (this.active) {
            throw new TransactionActiveOnBeginException(this.ec);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.ec.getStatistics() != null) {
            this.ec.getStatistics().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015000", this.ec, "" + this.ec.getBooleanProperty("datanucleus.Optimistic")));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionStarted();
        }
    }

    @Override
    public void preFlush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionPreFlush();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(Localiser.msg("015005"), ex);
        }
    }

    @Override
    public void flush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(Localiser.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            this.flush();
        }
        finally {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        if (this.rollbackOnly) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(Localiser.msg("015020"));
            }
            throw new NucleusDataStoreException(Localiser.msg("015020")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        boolean canComplete = true;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
        }
        catch (RollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicRollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicMixedException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (NucleusUserException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            canComplete = false;
            throw e;
        }
        catch (NucleusException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        finally {
            if (canComplete) {
                try {
                    if (!success) {
                        this.rollback();
                    } else {
                        this.internalPostCommit();
                    }
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new NucleusTransactionException(Localiser.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        TransactionEventListener[] ls;
        this.committing = true;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015001", this.ec));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.commit(this.ec);
            }
        } else {
            this.txnMgr.commit(this.ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        long startTime = System.currentTimeMillis();
        try {
            boolean canComplete = true;
            this.committing = true;
            try {
                this.flush();
            }
            finally {
                try {
                    this.internalPreRollback();
                }
                catch (NucleusUserException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    canComplete = false;
                    throw e;
                }
                finally {
                    if (canComplete) {
                        try {
                            this.internalRollback();
                        }
                        finally {
                            try {
                                this.active = false;
                                if (this.ec.getStatistics() != null) {
                                    this.ec.getStatistics().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                            }
                            finally {
                                this.listenersPerTransaction.clear();
                                this.rollbackOnly = false;
                                if (this.sync != null) {
                                    this.sync.afterCompletion(4);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (NucleusUserException e) {
            throw e;
        }
        catch (NucleusException e) {
            throw new NucleusDataStoreException(Localiser.msg("015009"), e);
        }
        finally {
            this.committing = false;
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015023", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreRollback() {
        TransactionEventListener[] ls;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(Localiser.msg("015002", this.ec));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreRollBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback() {
        TransactionEventListener[] ls;
        Transaction tx = this.txnMgr.getTransaction(this.ec);
        if (tx != null) {
            if (this.ec.getMultithreaded()) {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    this.txnMgr.rollback(this.ec);
                }
            } else {
                this.txnMgr.rollback(this.ec);
            }
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionRolledBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPostCommit() {
        try {
            this.active = false;
            if (this.ec.getStatistics() != null) {
                this.ec.getStatistics().transactionCommitted(System.currentTimeMillis() - this.beginTime);
            }
        }
        finally {
            try {
                TransactionEventListener[] ls;
                for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                    tel.transactionCommitted();
                }
            }
            finally {
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
            }
        }
    }

    private TransactionEventListener[] getListenersForEvent() {
        TransactionEventListener[] ls = new TransactionEventListener[this.userListeners.size() + this.listenersPerTransaction.size() + 1];
        System.arraycopy(this.listenersPerTransaction.toArray(), 0, ls, 0, this.listenersPerTransaction.size());
        System.arraycopy(this.userListeners.toArray(), 0, ls, this.listenersPerTransaction.size(), this.userListeners.size());
        ls[ls.length - 1] = this.ecListener;
        return ls;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean isCommitting() {
        return this.committing;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.ec.getBooleanProperty("datanucleus.NontransactionalRead");
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.ec.getBooleanProperty("datanucleus.NontransactionalWrite");
    }

    @Override
    public boolean getNontransactionalWriteAutoCommit() {
        return this.ec.getBooleanProperty("datanucleus.nontx.atomic");
    }

    @Override
    public boolean getOptimistic() {
        if (this.properties != null) {
            return this.properties.getFrequentProperties().getOptimisticTransaction();
        }
        return this.ec.getBooleanProperty("datanucleus.Optimistic");
    }

    @Override
    public boolean getRestoreValues() {
        return this.ec.getBooleanProperty("datanucleus.RestoreValues");
    }

    @Override
    public boolean getRetainValues() {
        return this.ec.getBooleanProperty("datanucleus.RetainValues");
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public Synchronization getSynchronization() {
        return this.sync;
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.ec.setProperty("datanucleus.NontransactionalRead", nontransactionalRead);
    }

    @Override
    public void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.ec.setProperty("datanucleus.NontransactionalWrite", nontransactionalWrite);
    }

    @Override
    public void setNontransactionalWriteAutoCommit(boolean autoCommit) {
        this.ec.setProperty("datanucleus.nontx.atomic", autoCommit);
    }

    @Override
    public void setOptimistic(boolean optimistic) {
        this.ec.setProperty("datanucleus.Optimistic", optimistic);
    }

    @Override
    public void setRestoreValues(boolean restoreValues) {
        this.ec.setProperty("datanucleus.RestoreValues", restoreValues);
    }

    @Override
    public void setRetainValues(boolean retainValues) {
        this.ec.setProperty("datanucleus.RetainValues", retainValues);
        if (retainValues) {
            this.setNontransactionalRead(true);
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    @Override
    public void setSavepoint(String name) {
        TransactionEventListener[] ls;
        if (!this.active) {
            return;
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionSetSavepoint(name);
        }
    }

    @Override
    public void releaseSavepoint(String name) {
        TransactionEventListener[] ls;
        if (!this.active) {
            return;
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionReleaseSavepoint(name);
        }
    }

    @Override
    public void rollbackToSavepoint(String name) {
        TransactionEventListener[] ls;
        if (!this.active) {
            return;
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionRollbackToSavepoint(name);
        }
    }

    @Override
    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    @Override
    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.add(listener);
    }

    @Override
    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.remove(listener);
        this.userListeners.remove(listener);
    }

    @Override
    public void bindTransactionEventListener(TransactionEventListener listener) {
        this.userListeners.add(listener);
    }

    @Override
    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    @Override
    public void setSerializeRead(Boolean serializeRead) {
        this.serializeRead = serializeRead;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOption(String option, int value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, boolean value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, String value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, Object value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    public void setProperties(PropertyStore properties) {
        this.properties = properties;
    }
}

