/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;

public class MetaData
implements Serializable {
    private static final long serialVersionUID = -5477406260914096062L;
    public static final int METADATA_CREATED_STATE = 0;
    public static final int METADATA_POPULATED_STATE = 1;
    public static final int METADATA_INITIALISED_STATE = 2;
    public static final int METADATA_USED_STATE = 3;
    protected int metaDataState = 0;
    protected MetaData parent;
    public static final String VENDOR_NAME = "datanucleus";
    public static final String EXTENSION_CLASS_READ_ONLY = "read-only";
    public static final String EXTENSION_CLASS_MULTITENANCY_DISABLE = "multitenancy-disable";
    public static final String EXTENSION_CLASS_MULTITENANCY_COLUMN_NAME = "multitenancy-column-name";
    public static final String EXTENSION_CLASS_MULTITENANCY_COLUMN_LENGTH = "multitenancy-column-length";
    public static final String EXTENSION_CLASS_MULTITENANCY_JDBC_TYPE = "multitenancy-jdbc-type";
    public static final String EXTENSION_CLASS_VERSION_FIELD_NAME = "field-name";
    public static final String EXTENSION_MEMBER_TYPE_CONVERTER_NAME = "type-converter-name";
    public static final String EXTENSION_MEMBER_TYPE_CONVERTER_DISABLED = "type-converter-disabled";
    public static final String EXTENSION_MEMBER_COMPARATOR_NAME = "comparator-name";
    public static final String EXTENSION_MEMBER_IMPLEMENTATION_CLASSES = "implementation-classes";
    public static final String EXTENSION_MEMBER_ENUM_VALUE_GETTER = "enum-value-getter";
    public static final String EXTENSION_MEMBER_ENUM_GETTER_BY_VALUE = "enum-getter-by-value";
    public static final String EXTENSION_MEMBER_CALENDAR_ONE_COLUMN = "calendar-one-column";
    public static final String EXTENSION_MEMBER_INSERTABLE = "insertable";
    public static final String EXTENSION_MEMBER_UPDATEABLE = "updateable";
    public static final String EXTENSION_MEMBER_CASCADE_PERSIST = "cascade-persist";
    public static final String EXTENSION_MEMBER_CASCADE_UPDATE = "cascade-update";
    public static final String EXTENSION_MEMBER_CASCADE_REFRESH = "cascade-refresh";
    public static final String EXTENSION_MEMBER_CACHEABLE = "cacheable";
    public static final String EXTENSION_MEMBER_FETCH_FK_ONLY = "fetch-fk-only";
    public static final String EXTENSION_MEMBER_CONTAINER_ALLOW_NULLS = "allow-nulls";
    public static final String EXTENSION_MEMBER_LIST_ORDERING = "list-ordering";
    public static final String EXTENSION_MEMBER_STRATEGY_WHEN_NOTNULL = "strategy-when-notnull";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_COLUMN = "relation-discriminator-column";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_VALUE = "relation-discriminator-value";
    public static final String EXTENSION_MEMBER_RELATION_DISCRIM_PK = "relation-discriminator-pk";
    public static final String EXTENSION_CLASS_VIEW_DEFINITION = "view-definition";
    public static final String EXTENSION_CLASS_VIEW_IMPORTS = "view-imports";
    protected Collection<ExtensionMetaData> extensions = null;

    public MetaData() {
    }

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public MetaData(MetaData parent, MetaData copy) {
        this.parent = parent;
        if (copy != null && copy.extensions != null) {
            for (ExtensionMetaData extmd : copy.extensions) {
                this.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
            }
        }
    }

    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        this.setInitialised();
    }

    void setInitialised() {
        this.metaDataState = 2;
    }

    void setPopulated() {
        this.metaDataState = 1;
    }

    void setUsed() {
        this.metaDataState = 3;
    }

    public void setParent(MetaData md) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusException("Cannot set parent of " + this + " since it is already populated/initialised");
        }
        this.parent = md;
    }

    public MetaData addExtension(String vendor, String key, String value) {
        if (vendor == null || vendor.equalsIgnoreCase(VENDOR_NAME) && (key == null || value == null)) {
            throw new InvalidMetaDataException("044160", vendor, key, value);
        }
        if (vendor.equalsIgnoreCase(VENDOR_NAME) && this.hasExtension(key)) {
            this.removeExtension(key);
        }
        if (this.extensions == null) {
            this.extensions = new HashSet<ExtensionMetaData>(2);
        }
        this.extensions.add(new ExtensionMetaData(vendor, key, value));
        return this;
    }

    public MetaData addExtension(String key, String value) {
        return this.addExtension(VENDOR_NAME, key, value);
    }

    public ExtensionMetaData newExtensionMetaData(String vendor, String key, String value) {
        if (vendor == null || vendor.equalsIgnoreCase(VENDOR_NAME) && (key == null || value == null)) {
            throw new InvalidMetaDataException("044160", vendor, key, value);
        }
        ExtensionMetaData extmd = new ExtensionMetaData(vendor, key, value);
        if (this.extensions == null) {
            this.extensions = new HashSet<ExtensionMetaData>(2);
        }
        this.extensions.add(extmd);
        return extmd;
    }

    public MetaData removeExtension(String key) {
        if (this.extensions == null) {
            return this;
        }
        Iterator<ExtensionMetaData> iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionMetaData ex = iter.next();
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(VENDOR_NAME)) continue;
            iter.remove();
            break;
        }
        return this;
    }

    public MetaData getParent() {
        return this.parent;
    }

    public boolean isPopulated() {
        return this.metaDataState >= 1;
    }

    public boolean isInitialised() {
        return this.metaDataState >= 2;
    }

    public boolean isUsed() {
        return this.metaDataState == 3;
    }

    public int getNoOfExtensions() {
        return this.extensions != null ? this.extensions.size() : 0;
    }

    public ExtensionMetaData[] getExtensions() {
        if (this.extensions == null || this.extensions.isEmpty()) {
            return null;
        }
        return this.extensions.toArray(new ExtensionMetaData[this.extensions.size()]);
    }

    public boolean hasExtension(String key) {
        if (this.extensions == null || key == null) {
            return false;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(VENDOR_NAME)) continue;
            return true;
        }
        return false;
    }

    public String getValueForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(VENDOR_NAME)) continue;
            return ex.getValue();
        }
        return null;
    }

    public String[] getValuesForExtension(String key) {
        if (this.extensions == null || key == null) {
            return null;
        }
        for (ExtensionMetaData ex : this.extensions) {
            if (!ex.getKey().equals(key) || !ex.getVendorName().equalsIgnoreCase(VENDOR_NAME)) continue;
            return MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(ex.getValue());
        }
        return null;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        if (this.extensions == null || this.extensions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ExtensionMetaData ex : this.extensions) {
            sb.append(prefix).append(ex.toString()).append("\n");
        }
        return sb.toString();
    }
}

