/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.datanucleus.store.types.converters.TypeConverter;

public class BufferedImageByteArrayConverter
implements TypeConverter<BufferedImage, byte[]> {
    private static final long serialVersionUID = 585211414298721468L;

    @Override
    public byte[] toDatastoreType(BufferedImage memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            ImageIO.write((RenderedImage)memberValue, "jpg", baos);
            bytes = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    @Override
    public BufferedImage toMemberType(byte[] datastoreValue) {
        if (datastoreValue == null || datastoreValue.length == 0) {
            return null;
        }
        try {
            return ImageIO.read(new ByteArrayInputStream(datastoreValue));
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

