/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class CollectionHandler<C>
extends ElementContainerHandler<C, ElementContainerAdapter<C>> {
    @Override
    public CollectionMetaData newMetaData() {
        CollectionMetaData collectionMetaData = new CollectionMetaData();
        collectionMetaData.setElementType(null);
        return collectionMetaData;
    }

    @Override
    public void populateMetaData(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        CollectionMetaData collectionMetadata = this.assertValidType(mmd.getContainer());
        if (StringUtils.isEmpty(collectionMetadata.getElementType())) {
            collectionMetadata.setElementType(this.getElementType(mmd));
        }
        if (mmd.isOrdered() && mmd.getOrderMetaData() == null) {
            OrderMetaData ordmd = new OrderMetaData();
            ordmd.setOrdering("#PK");
            mmd.setOrderMetaData(ordmd);
        }
        this.moveColumnsToElement(mmd);
        this.copyMappedByDefinitionFromElement(mmd);
        if (mmd.getElementMetaData() != null) {
            mmd.getElementMetaData().populate(clr, primary);
        }
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            if (mmd.isCascadeDelete()) {
                collectionMetadata.setDependentElement(true);
            }
            collectionMetadata.populate(clr, primary);
        }
    }

    @Override
    public int getObjectType(AbstractMemberMetaData mmd) {
        return mmd.getCollection().isEmbeddedElement() || mmd.getCollection().isSerializedElement() ? 2 : 0;
    }

    @Override
    public boolean isSerialised(AbstractMemberMetaData mmd) {
        return mmd.isSerialized() || mmd.getCollection().isSerializedElement();
    }

    @Override
    public boolean isEmbedded(AbstractMemberMetaData mmd) {
        return mmd.isEmbedded() || mmd.getCollection().isEmbeddedElement();
    }

    @Override
    public boolean isDefaultFetchGroup(ClassLoaderResolver clr, MetaDataManager mmgr, AbstractMemberMetaData mmd) {
        if (!mmd.getCollection().isPopulated()) {
            throw new NucleusException("MetaData must be populated in order to be able to determine default fetch group.");
        }
        String elementTypeName = mmd.getCollection().getElementType();
        Class elementType = clr.classForName(elementTypeName);
        TypeManager typeMgr = mmgr.getNucleusContext().getTypeManager();
        return typeMgr.isDefaultFetchGroupForCollection(mmd.getType(), elementType);
    }

    protected String getElementType(AbstractMemberMetaData mmd) {
        String elementType = null;
        if (mmd.getTargetClassName() == null) {
            Member member = mmd.getMemberRepresented();
            if (member instanceof Field) {
                elementType = ClassUtils.getCollectionElementType((Field)member);
            } else if (member instanceof Method) {
                elementType = ClassUtils.getCollectionElementType((Method)member);
            }
            if (elementType == null) {
                ParameterizedType paramGenType;
                Type elemGenericType;
                Type genericType;
                Type type = genericType = member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType();
                if (genericType != null && genericType instanceof ParameterizedType && (elemGenericType = (paramGenType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof TypeVariable) {
                    ParameterizedType paramElemGenType;
                    Type paramElemGenTypeRaw;
                    Type elemGenTypeBound = ((TypeVariable)elemGenericType).getBounds()[0];
                    if (elemGenTypeBound instanceof Class) {
                        elementType = ((Class)elemGenTypeBound).getName();
                    } else if (elemGenTypeBound instanceof ParameterizedType && (paramElemGenTypeRaw = (paramElemGenType = (ParameterizedType)elemGenTypeBound).getRawType()) != null && paramElemGenTypeRaw instanceof Class) {
                        elementType = ((Class)paramElemGenTypeRaw).getName();
                    }
                }
            }
        } else {
            elementType = mmd.getTargetClassName();
        }
        if (elementType == null) {
            elementType = Object.class.getName();
            NucleusLogger.METADATA.debug(Localiser.msg("044003", mmd.getClassName(), mmd.getName()));
        }
        return elementType;
    }

    private CollectionMetaData assertValidType(ContainerMetaData metaData) {
        if (metaData instanceof CollectionMetaData) {
            return (CollectionMetaData)metaData;
        }
        throw new NucleusException("Invalid type of metadata specified.");
    }
}

