/**********************************************************************
Copyright (c) 2014 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.types.converters;

import java.sql.Timestamp;
import java.util.Date;
import java.time.OffsetDateTime;
import java.time.ZoneId;

import org.datanucleus.store.types.converters.TypeConverter;

/**
 * Class to handle the conversion between java.time.OffsetDateTime and java.sql.Timestamp
 */
public class OffsetDateTimeTimestampConverter implements TypeConverter<OffsetDateTime, Timestamp>
{
    private static final long serialVersionUID = 1020419574496380608L;

    public OffsetDateTime toMemberType(Timestamp ts)
    {
        if (ts == null)
        {
            return null;
        }
        return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    public Timestamp toDatastoreType(OffsetDateTime datetime)
    {
        if (datetime == null)
        {
            return null;
        }
        return new Timestamp(Date.from(datetime.atZoneSameInstant(ZoneId.systemDefault()).toInstant()).getTime());
    }
}
