/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.ElementContainerAdapter;
import org.datanucleus.store.types.ElementContainerHandler;
import org.datanucleus.store.types.MapContainerAdapter;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.SequenceAdapter;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.MapHandler;
import org.datanucleus.util.NucleusLogger;

public class L2CachePopulateFieldManager
extends AbstractFieldManager {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CachePopulateFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Character.valueOf(value));
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Float.valueOf(value));
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        if (value == null) {
            this.cachedPC.setFieldValue(fieldNumber, null);
        } else if (mmd.hasContainer()) {
            this.processContainer(fieldNumber, value, mmd);
        } else {
            this.processField(fieldNumber, value, mmd);
        }
    }

    private Object getCacheableIdForId(ApiAdapter api, Object pc) {
        if (pc == null) {
            return null;
        }
        Object id = api.getIdForObject(pc);
        if (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) {
            return id;
        }
        return new CachedPC.CachedId(pc.getClass().getName(), id);
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        Object unwrappedContainer = container;
        if (container instanceof SCOContainer) {
            if (!((SCOContainer)container).isLoaded()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            unwrappedContainer = ((SCO)container).getValue();
        }
        TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
        if (mmd.hasMap()) {
            MapHandler mapHandler = (MapHandler)typeManager.getContainerHandler(mmd.getType());
            this.processMapContainer(fieldNumber, unwrappedContainer, mmd, mapHandler);
        } else {
            ElementContainerHandler elementContainerHandler = (ElementContainerHandler)typeManager.getContainerHandler(mmd.getType());
            this.processElementContainer(fieldNumber, unwrappedContainer, mmd, elementContainerHandler);
        }
    }

    private void processMapContainer(int fieldNumber, Object mapContainer, AbstractMemberMetaData mmd, MapHandler<Object> containerHandler) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType != RelationType.NONE && (containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd))) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        try {
            ApiAdapter api = this.ec.getApiAdapter();
            Object newContainer = L2CacheRetrieveFieldManager.newContainer(mapContainer, mmd, containerHandler);
            MapContainerAdapter mapToCacheAdapter = (MapContainerAdapter)containerHandler.getAdapter(newContainer);
            boolean keyIsPersistent = mmd.getMap().keyIsPersistent();
            boolean valueIsPersistent = mmd.getMap().valueIsPersistent();
            for (Map.Entry<Object, Object> entry : ((MapContainerAdapter)containerHandler.getAdapter(mapContainer)).entries()) {
                Object mapKey = keyIsPersistent ? this.getCacheableIdForId(api, entry.getKey()) : SCOUtils.copyValue(entry.getKey());
                Object mapValue = valueIsPersistent ? this.getCacheableIdForId(api, entry.getValue()) : SCOUtils.copyValue(entry.getValue());
                mapToCacheAdapter.put(mapKey, mapValue);
            }
            this.cachedPC.setFieldValue(fieldNumber, mapToCacheAdapter.getContainer());
        }
        catch (Exception e) {
            NucleusLogger.CACHE.warn("Unable to create object of type " + mapContainer.getClass().getName() + " for L2 caching : " + e.getMessage());
            this.cachedPC.setLoadedField(fieldNumber, false);
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ElementContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            boolean isContainerMutable = this.ec.getTypeManager().isSecondClassMutableType(mmd.getType().getName());
            String elementType = containerHandler.getElementTypeName(mmd.getContainer());
            boolean isElementMutable = this.ec.getTypeManager().isSecondClassMutableType(elementType);
            if (isContainerMutable || isElementMutable) {
                ElementContainerAdapter adapterToCache = (ElementContainerAdapter)containerHandler.getAdapter(L2CacheRetrieveFieldManager.newContainer(container, mmd, containerHandler));
                if (isElementMutable) {
                    for (Object elementSCO : (ElementContainerAdapter)containerHandler.getAdapter(container)) {
                        adapterToCache.add(SCOUtils.copyValue(elementSCO));
                    }
                } else {
                    for (Object element : (ElementContainerAdapter)containerHandler.getAdapter(container)) {
                        adapterToCache.add(element);
                    }
                }
                this.cachedPC.setFieldValue(fieldNumber, adapterToCache.getContainer());
            } else {
                this.cachedPC.setFieldValue(fieldNumber, container);
            }
        } else {
            if (containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd)) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            ElementContainerAdapter containerAdapter = (ElementContainerAdapter)containerHandler.getAdapter(container);
            if (containerAdapter instanceof SequenceAdapter && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            try {
                Object[] newContainer = mmd.hasArray() ? EMPTY_ARRAY : L2CacheRetrieveFieldManager.newContainer(container, mmd, containerHandler);
                ElementContainerAdapter containerToCacheAdapter = (ElementContainerAdapter)containerHandler.getAdapter(newContainer);
                ApiAdapter api = this.ec.getApiAdapter();
                for (Object element : containerAdapter) {
                    containerToCacheAdapter.add(this.getCacheableIdForId(api, element));
                }
                Object cachedValue = containerToCacheAdapter.getContainer();
                this.cachedPC.setFieldValue(fieldNumber, cachedValue);
            }
            catch (Exception e) {
                NucleusLogger.CACHE.warn("Unable to create object of type " + container.getClass().getName() + " for L2 caching : " + e.getMessage());
                this.cachedPC.setLoadedField(fieldNumber, false);
            }
        }
    }

    private void processField(int fieldNumber, Object value, AbstractMemberMetaData mmd) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            Object unwrappedValue = value instanceof SCO ? ((SCO)value).getValue() : value;
            this.cachedPC.setFieldValue(fieldNumber, SCOUtils.copyValue(unwrappedValue));
            return;
        }
        if (mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) {
            if (this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded")) {
                ObjectProvider valueOP = this.ec.findObjectProvider(value);
                int[] loadedFields = valueOP.getLoadedFieldNumbers();
                CachedPC valueCachedPC = new CachedPC(value.getClass(), valueOP.getLoadedFields(), null);
                if (loadedFields != null && loadedFields.length > 0) {
                    valueOP.provideFields(loadedFields, new L2CachePopulateFieldManager(valueOP, valueCachedPC));
                }
                this.cachedPC.setFieldValue(fieldNumber, valueCachedPC);
            } else {
                this.cachedPC.setLoadedField(fieldNumber, false);
            }
            return;
        }
        ApiAdapter api = this.ec.getApiAdapter();
        this.cachedPC.setFieldValue(fieldNumber, this.getCacheableIdForId(api, value));
    }
}

