/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractLevel2Cache
implements Level2Cache {
    private static final long serialVersionUID = 7737532122953947585L;
    protected NucleusContext nucleusCtx;
    protected int maxSize = -1;
    protected boolean clearAtClose = true;
    protected long expiryMillis = -1L;
    protected String cacheName;

    public AbstractLevel2Cache(NucleusContext nucleusCtx) {
        this.nucleusCtx = nucleusCtx;
        Configuration conf = nucleusCtx.getConfiguration();
        this.maxSize = conf.getIntProperty("datanucleus.cache.level2.maxSize");
        this.clearAtClose = conf.getBooleanProperty("datanucleus.cache.level2.clearAtClose", true);
        if (conf.hasProperty("datanucleus.cache.level2.expiryMillis")) {
            this.expiryMillis = conf.getIntProperty("datanucleus.cache.level2.expiryMillis");
        }
        this.cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn("No 'datanucleus.cache.level2.cacheName' specified so using name of 'dataNucleus'");
            this.cacheName = "dataNucleus";
        }
    }
}

