/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;

public interface StorePersistenceHandler {
    public void close();

    default public void batchStart(ExecutionContext ec, PersistenceBatchType batchType) {
    }

    default public void batchEnd(ExecutionContext ec, PersistenceBatchType type) {
    }

    public void insertObject(ObjectProvider var1);

    default public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.insertObject(ops[i]);
        }
    }

    public void updateObject(ObjectProvider var1, int[] var2);

    public void deleteObject(ObjectProvider var1);

    default public void deleteObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.deleteObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.deleteObject(ops[i]);
        }
    }

    public void fetchObject(ObjectProvider var1, int[] var2);

    default public void fetchObjects(int[] fieldNumbers, ObjectProvider ... ops) {
        for (ObjectProvider op : ops) {
            this.fetchObject(op, fieldNumbers);
        }
    }

    public void locateObject(ObjectProvider var1);

    default public void locateObjects(ObjectProvider[] ops) {
        if (ops.length == 1) {
            this.locateObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            this.locateObject(ops[i]);
        }
    }

    public Object findObject(ExecutionContext var1, Object var2);

    default public Object[] findObjects(ExecutionContext ec, Object[] ids) {
        Object[] objects = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            objects[i] = this.findObject(ec, ids[i]);
        }
        return objects;
    }

    public Object findObjectForUnique(ExecutionContext var1, AbstractClassMetaData var2, String[] var3, Object[] var4);

    public static enum PersistenceBatchType {
        PERSIST,
        DELETE,
        LOCATE;

    }
}

