/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchFieldManager
extends AbstractFieldManager {
    Result result;
    ExecutionContext ec;
    ObjectProvider sm;
    AbstractClassMetaData cmd;
    String tableName;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Result result, String tableName) {
        this.ec = ec;
        this.cmd = cmd;
        this.result = result;
        this.tableName = tableName;
    }

    public FetchFieldManager(ObjectProvider sm, Result result, String tableName) {
        this.ec = sm.getExecutionContext();
        this.sm = sm;
        this.cmd = sm.getClassMetaData();
        this.result = result;
        this.tableName = tableName;
    }

    protected String getFamilyName(int fieldNumber) {
        return HBaseUtils.getFamilyName(this.cmd, fieldNumber, this.tableName);
    }

    protected String getQualifierName(int fieldNumber) {
        return HBaseUtils.getQualifierName(this.cmd, fieldNumber);
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchBooleanInternal(mmd, bytes);
    }

    public byte fetchByteField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchByteInternal(mmd, bytes);
    }

    public char fetchCharField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchCharInternal(mmd, bytes);
    }

    public double fetchDoubleField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchDoubleInternal(mmd, bytes);
    }

    public float fetchFloatField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchFloatInternal(mmd, bytes);
    }

    public int fetchIntField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchIntInternal(mmd, bytes);
    }

    public long fetchLongField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchLongInternal(mmd, bytes);
    }

    public short fetchShortField(int fieldNumber) {
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        return this.fetchShortInternal(mmd, bytes);
    }

    public String fetchStringField(int fieldNumber) {
        String value;
        String familyName = this.getFamilyName(fieldNumber);
        String qualifName = this.getQualifierName(fieldNumber);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (bytes == null) {
            return HBaseUtils.getDefaultValueForMember(mmd);
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = (String)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = new String(bytes);
        }
        return value;
    }

    public Object fetchObjectField(int fieldNumber) {
        String qualifName;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (mmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
            Class embcls = mmd.getType();
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
            if (embcmd != null) {
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String familyName = HBaseUtils.getFamilyName(mmd, i, this.tableName);
                    String columnName = HBaseUtils.getQualifierName(mmd, i);
                    if (this.result.getValue(familyName.getBytes(), columnName.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, mmd, this.tableName);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
        }
        String familyName = HBaseUtils.getFamilyName(this.cmd, fieldNumber, this.tableName);
        Object value = this.readObjectField(familyName, qualifName = HBaseUtils.getQualifierName(this.cmd, fieldNumber), this.result, fieldNumber, mmd);
        if (value == null) {
            return null;
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            if (mmd.isSerialized()) {
                return value;
            }
            return this.ec.findObject(value, true, true, null);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                Collection coll;
                if (mmd.isSerialized()) {
                    return value;
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                }
                return coll;
            }
            if (mmd.hasMap()) {
                Map map;
                if (mmd.isSerialized()) {
                    return value;
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Map mapIds = (Map)value;
                for (Map.Entry entry : mapIds.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager()) != null) {
                        mapKey = this.ec.findObject(mapKey, true, true, null);
                    }
                    if (mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager()) != null) {
                        mapValue = this.ec.findObject(mapValue, true, true, null);
                    }
                    map.put(mapKey, mapValue);
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)map, false, false, true);
                }
                return map;
            }
            if (mmd.hasArray()) {
                if (mmd.isSerialized()) {
                    return value;
                }
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        Object returnValue = value;
        if (!mmd.isSerialized()) {
            if (mmd.getTypeConverterName() != null) {
                byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
                TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
                Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType());
                if (datastoreType == String.class) {
                    returnValue = conv.toMemberType((Object)((String)value));
                } else if (datastoreType == Long.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toLong((byte[])bytes));
                } else if (datastoreType == Integer.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toInt((byte[])bytes));
                } else if (datastoreType == Double.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toDouble((byte[])bytes));
                } else if (datastoreType == Boolean.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toBoolean((byte[])bytes));
                }
            } else {
                if (Enum.class.isAssignableFrom(mmd.getType())) {
                    return Enum.valueOf(mmd.getType(), (String)value);
                }
                TypeConverter strConv = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
                if (strConv != null) {
                    String strValue = (String)value;
                    returnValue = strConv.toMemberType((Object)strValue);
                }
            }
        }
        if (this.sm != null) {
            return this.sm.wrapSCOField(fieldNumber, returnValue, false, false, true);
        }
        return returnValue;
    }

    protected Object readObjectField(String familyName, String columnName, Result result, int fieldNumber, AbstractMemberMetaData mmd) {
        byte[] bytes = result.getValue(familyName.getBytes(), columnName.getBytes());
        if (bytes == null) {
            return null;
        }
        if (mmd.getType() == Boolean.class) {
            return this.fetchBooleanInternal(mmd, bytes);
        }
        if (mmd.getType() == Byte.class) {
            return this.fetchByteInternal(mmd, bytes);
        }
        if (mmd.getType() == Character.class) {
            return Character.valueOf(this.fetchCharInternal(mmd, bytes));
        }
        if (mmd.getType() == Double.class) {
            return this.fetchDoubleInternal(mmd, bytes);
        }
        if (mmd.getType() == Float.class) {
            return Float.valueOf(this.fetchFloatInternal(mmd, bytes));
        }
        if (mmd.getType() == Integer.class) {
            return this.fetchIntInternal(mmd, bytes);
        }
        if (mmd.getType() == Long.class) {
            return this.fetchLongInternal(mmd, bytes);
        }
        if (mmd.getType() == Short.class) {
            return this.fetchShortInternal(mmd, bytes);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            String string = new String(bytes);
            return string;
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ioe) {
                throw new NucleusException(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private boolean fetchBooleanInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        boolean value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readBoolean();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toBoolean((byte[])bytes);
        }
        return value;
    }

    private byte fetchByteInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return dflt.getBytes()[0];
            }
            return 0;
        }
        return bytes[0];
    }

    private char fetchCharInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        char value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readChar();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            String strValue = new String(bytes);
            value = strValue.charAt(0);
        }
        return value;
    }

    private double fetchDoubleInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        double value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readDouble();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toDouble((byte[])bytes);
        }
        return value;
    }

    private float fetchFloatInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        float value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readFloat();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toFloat((byte[])bytes);
        }
        return value;
    }

    private int fetchIntInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        int value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readInt();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toInt((byte[])bytes);
        }
        return value;
    }

    private long fetchLongInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        long value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readLong();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toLong((byte[])bytes);
        }
        return value;
    }

    private short fetchShortInternal(AbstractMemberMetaData mmd, byte[] bytes) {
        short value;
        if (bytes == null) {
            String dflt = HBaseUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        if (mmd.isSerialized()) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readShort();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toShort((byte[])bytes);
        }
        return value;
    }
}

