/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query.expression;

import java.util.Arrays;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.hbase.query.expression.HBaseExpression;

public class HBaseBooleanExpression
extends HBaseExpression {
    Filter filter;

    public HBaseBooleanExpression(String familyName, String columnName, Object value, Expression.Operator op) {
        boolean filterIfMissing = true;
        if (op == Expression.OP_NOTEQ) {
            filterIfMissing = false;
        }
        CompareFilter.CompareOp comp = HBaseBooleanExpression.getComparisonOperatorForExpressionOperator(op);
        if (value instanceof String) {
            this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((String)((String)value)));
            ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
        } else if (value instanceof Number) {
            if (value instanceof Double) {
                this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((double)((Double)value)));
                ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
            } else if (value instanceof Float) {
                this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((float)((Float)value).floatValue()));
                ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
            } else if (value instanceof Long) {
                this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((long)((Long)value)));
                ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
            } else if (value instanceof Integer) {
                this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((int)((Integer)value)));
                ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
            } else if (value instanceof Short) {
                this.filter = new SingleColumnValueFilter(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), comp, Bytes.toBytes((short)((Short)value)));
                ((SingleColumnValueFilter)this.filter).setFilterIfMissing(filterIfMissing);
            }
        } else {
            throw new NucleusException("Dont currently support use of Literal of type " + value.getClass().getName() + " in expressions");
        }
    }

    public HBaseBooleanExpression(HBaseBooleanExpression expr1, HBaseBooleanExpression expr2, Expression.Operator op) {
        if (op == Expression.OP_AND) {
            this.filter = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(expr1.getFilter(), expr2.getFilter()));
        } else if (op == Expression.OP_OR) {
            this.filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(expr1.getFilter(), expr2.getFilter()));
        } else {
            throw new NucleusException("Dont currently support operator " + op + " in boolean expression for HBase");
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected static CompareFilter.CompareOp getComparisonOperatorForExpressionOperator(Expression.Operator op) {
        if (op == Expression.OP_EQ) {
            return CompareFilter.CompareOp.EQUAL;
        }
        if (op == Expression.OP_NOTEQ) {
            return CompareFilter.CompareOp.NOT_EQUAL;
        }
        if (op == Expression.OP_GT) {
            return CompareFilter.CompareOp.GREATER;
        }
        if (op == Expression.OP_GTEQ) {
            return CompareFilter.CompareOp.GREATER_OR_EQUAL;
        }
        if (op == Expression.OP_LT) {
            return CompareFilter.CompareOp.LESS;
        }
        if (op == Expression.OP_LTEQ) {
            return CompareFilter.CompareOp.LESS_OR_EQUAL;
        }
        return null;
    }
}

