/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    Table table;
    Result result;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Result result, Table table) {
        super(ec, cmd);
        this.result = result;
        this.table = table;
    }

    public FetchFieldManager(ObjectProvider op, Result result, Table table) {
        super(op);
        this.result = result;
        this.table = table;
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchBooleanInternal(bytes, mmd.isSerialized(), null);
    }

    public byte fetchByteField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchByteInternal(bytes, mmd.isSerialized(), null);
    }

    public char fetchCharField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchCharInternal(bytes, mmd.isSerialized(), null);
    }

    public double fetchDoubleField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchDoubleInternal(bytes, mmd.isSerialized(), null);
    }

    public float fetchFloatField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchFloatInternal(bytes, mmd.isSerialized(), null);
    }

    public int fetchIntField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchIntInternal(bytes, mmd.isSerialized(), null);
    }

    public long fetchLongField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchLongInternal(bytes, mmd.isSerialized(), null);
    }

    public short fetchShortField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchShortInternal(bytes, mmd.isSerialized(), null);
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        String qualifName = HBaseUtils.getQualifierNameForColumn(col);
        byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
        return this.fetchStringInternal(bytes, mmd.isSerialized(), null);
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                Class embcls = mmd.getType();
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(embcls, clr);
                boolean isNull = true;
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                if (embmd != null) {
                    // empty if block
                }
                int[] embAllPosns = embCmd.getAllMemberPositions();
                for (int i = 0; i < embAllPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
                    ArrayList<AbstractMemberMetaData> subEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                    subEmbMmds.add(embMmd);
                    MemberColumnMapping embMapping = this.table.getMemberColumnMappingForEmbeddedMember(subEmbMmds);
                    if (embMapping == null) continue;
                    Column col = embMapping.getColumn(0);
                    String familyName = HBaseUtils.getFamilyNameForColumn(col);
                    String columnName = HBaseUtils.getQualifierNameForColumn(col);
                    if (this.result.getValue(familyName.getBytes(), columnName.getBytes()) == null) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.result, embMmds, this.table);
                embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded not supported for this type");
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        boolean optional = false;
        Class type = mmd.getType();
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            type = clr.classForName(mmd.getCollection().getElementType());
            optional = true;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            Optional<Object> pc;
            block132: {
                String qualifName;
                String familyName;
                Column col = mapping.getColumn(0);
                Object value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd, FieldRole.ROLE_FIELD);
                if (value == null) {
                    return optional ? Optional.empty() : null;
                }
                if (mmd.isSerialized()) {
                    ObjectProvider pcOP = this.ec.findObjectProvider(value);
                    if (pcOP == null || this.ec.getApiAdapter().getExecutionContext(value) == null) {
                        this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, value, false, this.op, fieldNumber);
                    }
                    return value;
                }
                pc = null;
                if (this.ec.getStoreManager().getBooleanProperty("datanucleus.hbase.relationUsesPersistableId")) {
                    String persistableId = (String)value;
                    try {
                        AbstractClassMetaData mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(type, clr);
                        if (mmdCmd != null) {
                            pc = IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
                            return optional ? Optional.of(pc) : pc;
                        }
                        String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_FIELD, clr, this.ec.getMetaDataManager());
                        if (implNames != null && implNames.length == 1) {
                            mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                            pc = IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
                            return optional ? Optional.of(pc) : pc;
                        }
                        if (implNames != null && implNames.length > 1) {
                            for (String implName : implNames) {
                                try {
                                    mmdCmd = this.ec.getMetaDataManager().getMetaDataForClass(implName, clr);
                                    pc = IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)mmdCmd, (ExecutionContext)this.ec);
                                    return optional ? Optional.of(pc) : pc;
                                }
                                catch (NucleusObjectNotFoundException nonfe) {
                                    throw nonfe;
                                }
                                catch (Exception nonfe) {
                                }
                            }
                            break block132;
                        }
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an interdeterminate type (e.g interface or Object element types)");
                    }
                    catch (NucleusObjectNotFoundException onfe) {
                        NucleusLogger.PERSISTENCE.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + persistableId + " but could not instantiate object with that identity"));
                    }
                } else {
                    pc = this.ec.findObject(value, true, true, null);
                }
            }
            return optional ? (pc != null ? Optional.of(pc) : Optional.empty()) : pc;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Optional<Object> value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd, FieldRole.ROLE_FIELD);
            if (value == null) {
                return optional ? Optional.empty() : null;
            }
            if (mmd.isSerialized()) {
                Optional<Object> returnValue = optional ? Optional.of(value) : value;
                return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, returnValue, (boolean)true) : returnValue;
            }
            if (mmd.hasCollection()) {
                List newColl;
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                if (mmd.getCollection().isSerializedElement()) {
                    throw new NucleusException("Don't currently support serialized collection elements (field=" + mmd.getFullFieldName() + ")");
                }
                AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                if (elemCmd == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length > 0) {
                        elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (elemCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                    }
                }
                Collection collIds = (Collection)((Object)value);
                Iterator idIter = collIds.iterator();
                boolean changeDetected = false;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    if (this.ec.getStoreManager().getBooleanProperty("datanucleus.hbase.relationUsesPersistableId")) {
                        String persistableId = (String)elementId;
                        if (persistableId.equals("NULL")) {
                            coll.add(null);
                            continue;
                        }
                        try {
                            coll.add(IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                        }
                        continue;
                    }
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                if (coll instanceof List && mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK") && (newColl = QueryUtils.orderCandidates((List)((List)coll), (Class)clr.classForName(mmd.getCollection().getElementType()), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)this.ec, (ClassLoaderResolver)clr)).getClass() != coll.getClass()) {
                    coll.clear();
                    coll.addAll(newColl);
                }
                if (this.op != null) {
                    coll = (Collection)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)coll, (boolean)true);
                    if (changeDetected) {
                        this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                    }
                }
                return coll;
            }
            if (mmd.hasMap()) {
                Map map;
                if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                    throw new NucleusException("Don't currently support serialized map keys/values (field=" + mmd.getFullFieldName() + ")");
                }
                Map mapIds = (Map)((Object)value);
                AbstractClassMetaData keyCmd = null;
                if (mmd.getMap().keyIsPersistent() && (keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_KEY, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length == 1) {
                        keyCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (keyCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate key type (e.g interface or Object element types)");
                    }
                }
                AbstractClassMetaData valCmd = null;
                if (mmd.getMap().valueIsPersistent() && (valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager())) == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_VALUE, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length == 1) {
                        valCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (valCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a map of interdeterminate value type (e.g interface or Object element types)");
                    }
                }
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Iterator mapIdIter = mapIds.entrySet().iterator();
                boolean changeDetected = false;
                while (mapIdIter.hasNext()) {
                    Map.Entry entry = mapIdIter.next();
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    boolean keySet = true;
                    boolean valSet = true;
                    if (mmd.getMap().keyIsPersistent()) {
                        if (this.ec.getStoreManager().getBooleanProperty("datanucleus.hbase.relationUsesPersistableId")) {
                            String keyPersistableId = (String)mapKey;
                            try {
                                mapKey = IdentityUtils.getObjectFromPersistableIdentity((String)keyPersistableId, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec);
                            }
                            catch (NucleusObjectNotFoundException onfe) {
                                changeDetected = true;
                                keySet = false;
                            }
                        } else {
                            mapKey = this.ec.findObject(mapKey, true, true, null);
                        }
                    }
                    if (mmd.getMap().valueIsPersistent()) {
                        if (this.ec.getStoreManager().getBooleanProperty("datanucleus.hbase.relationUsesPersistableId")) {
                            String valPersistableId = (String)mapValue;
                            if (valPersistableId.equals("NULL")) {
                                mapValue = null;
                            } else {
                                try {
                                    mapValue = IdentityUtils.getObjectFromPersistableIdentity((String)valPersistableId, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec);
                                }
                                catch (NucleusObjectNotFoundException onfe) {
                                    changeDetected = true;
                                    valSet = false;
                                }
                            }
                        } else {
                            mapValue = this.ec.findObject(mapValue, true, true, null);
                        }
                    }
                    if (!keySet || !valSet) continue;
                    map.put(mapKey, mapValue);
                }
                if (this.op != null) {
                    map = (Map)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)map, (boolean)true);
                    if (changeDetected) {
                        this.op.makeDirty(fieldNumber);
                    }
                }
                return map;
            }
            if (mmd.hasArray()) {
                if (mmd.getArray().isSerializedElement()) {
                    throw new NucleusException("Don't currently support serialized array elements (field=" + mmd.getFullFieldName() + ")");
                }
                AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                if (elemCmd == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length == 1) {
                        elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (elemCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                    }
                }
                Collection arrIds = (Collection)((Object)value);
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                boolean changeDetected = false;
                int pos = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    if (this.ec.getStoreManager().getBooleanProperty("datanucleus.hbase.relationUsesPersistableId")) {
                        String persistableId = (String)elementId;
                        if (persistableId.equals("NULL")) {
                            Array.set(array, pos++, null);
                            continue;
                        }
                        try {
                            Array.set(array, pos++, IdentityUtils.getObjectFromPersistableIdentity((String)persistableId, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec));
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            changeDetected = true;
                        }
                        continue;
                    }
                    Array.set(array, pos, this.ec.findObject(elementId, true, true, null));
                }
                if (changeDetected) {
                    if (pos < arrIds.size()) {
                        Object arrayOld = array;
                        array = Array.newInstance(mmd.getType().getComponentType(), pos);
                        for (int j = 0; j < pos; ++j) {
                            Array.set(array, j, Array.get(arrayOld, j));
                        }
                    }
                    if (this.op != null) {
                        this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                    }
                }
                return array;
            }
            throw new NucleusUserException("No container that isnt collection/map/array");
        }
        Object returnValue = null;
        if (mmd.isSerialized()) {
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Optional<Object> value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd, FieldRole.ROLE_FIELD);
            if (value == null) {
                return optional ? Optional.empty() : null;
            }
            returnValue = value;
        } else if (mapping.getTypeConverter() != null) {
            TypeConverter conv = mapping.getTypeConverter();
            if (mapping.getNumberOfColumns() > 1) {
                boolean isNull = true;
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    byte[] bytes;
                    Column col = mapping.getColumn(i);
                    String familyName = HBaseUtils.getFamilyNameForColumn(col);
                    String qualifName = HBaseUtils.getQualifierNameForColumn(col);
                    Object colValue = null;
                    if (this.result.containsColumn(familyName.getBytes(), qualifName.getBytes()) && (bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes())) != null) {
                        isNull = false;
                        if (colTypes[i] == String.class) {
                            colValue = new String(bytes);
                        } else if (colTypes[i] == Integer.class || colTypes[i] == Integer.TYPE) {
                            colValue = Bytes.toInt((byte[])bytes);
                        } else if (colTypes[i] == Long.class || colTypes[i] == Long.TYPE) {
                            colValue = Bytes.toLong((byte[])bytes);
                        } else if (colTypes[i] == Double.class || colTypes[i] == Double.TYPE) {
                            colValue = Bytes.toDouble((byte[])bytes);
                        } else if (colTypes[i] == Float.class || colTypes[i] == Float.TYPE) {
                            colValue = Float.valueOf(Bytes.toFloat((byte[])bytes));
                        } else if (colTypes[i] == Short.class || colTypes[i] == Short.TYPE) {
                            colValue = Bytes.toShort((byte[])bytes);
                        } else if (colTypes[i] == Boolean.class || colTypes[i] == Boolean.TYPE) {
                            colValue = Bytes.toBoolean((byte[])bytes);
                        } else if (colTypes[i] == BigDecimal.class) {
                            colValue = Bytes.toBigDecimal((byte[])bytes);
                        } else if (Date.class.isAssignableFrom(colTypes[i])) {
                            String datastoreValue = new String(bytes);
                            TypeConverter dateStrConv = this.ec.getTypeManager().getTypeConverterForType(colTypes[i], String.class);
                            Date datastoreDate = (Date)dateStrConv.toMemberType((Object)datastoreValue);
                            colValue = conv.toMemberType((Object)datastoreDate);
                        } else {
                            NucleusLogger.PERSISTENCE.warn((Object)("Retrieve of column " + col + " is for type " + colTypes[i] + " but this is not yet supported. Report this"));
                        }
                    }
                    Array.set(valuesArr, i, colValue);
                }
                if (isNull) {
                    return null;
                }
                Object memberValue = conv.toMemberType((Object)valuesArr);
                if (this.op != null && memberValue != null) {
                    memberValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)memberValue, (boolean)true);
                }
                return memberValue;
            }
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType());
            byte[] bytes = this.result.getValue(familyName.getBytes(), qualifName.getBytes());
            if (datastoreType == byte[].class) {
                returnValue = conv.toMemberType((Object)bytes);
            } else {
                if (bytes == null) {
                    return null;
                }
                if (datastoreType == String.class) {
                    returnValue = conv.toMemberType((Object)new String(bytes));
                } else if (datastoreType == Long.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toLong((byte[])bytes));
                } else if (datastoreType == Integer.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toInt((byte[])bytes));
                } else if (datastoreType == Double.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toDouble((byte[])bytes));
                } else if (datastoreType == Boolean.class) {
                    returnValue = conv.toMemberType((Object)Bytes.toBoolean((byte[])bytes));
                } else if (Date.class.isAssignableFrom(datastoreType)) {
                    String datastoreValue = new String(bytes);
                    TypeConverter dateStrConv = this.ec.getTypeManager().getTypeConverterForType(datastoreType, String.class);
                    Date datastoreDate = (Date)dateStrConv.toMemberType((Object)datastoreValue);
                    returnValue = conv.toMemberType((Object)datastoreDate);
                }
            }
        } else {
            TypeConverter strConv;
            String qualifName;
            String familyName;
            Column col = mapping.getColumn(0);
            Optional<Object> value = this.readObjectField(col, familyName = HBaseUtils.getFamilyNameForColumn(col), qualifName = HBaseUtils.getQualifierNameForColumn(col), this.result, mmd, FieldRole.ROLE_FIELD);
            if (value == null) {
                return optional ? Optional.empty() : null;
            }
            returnValue = value;
            if (Boolean.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
                return optional ? Optional.of(value) : value;
            }
            if (String.class.isAssignableFrom(type)) {
                return optional ? Optional.of(value) : value;
            }
            if (Enum.class.isAssignableFrom(type)) {
                returnValue = TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, value, (ClassLoaderResolver)clr);
                return optional ? Optional.of(returnValue) : returnValue;
            }
            if (mmd.hasCollection()) {
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                TypeConverter elemConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_COLLECTION_ELEMENT);
                Collection dbColl = (Collection)((Object)value);
                Iterator dbCollIter = dbColl.iterator();
                while (dbCollIter.hasNext()) {
                    Object dbElem;
                    Object elem = dbElem = dbCollIter.next();
                    if (elemConv != null) {
                        elem = elemConv.toMemberType(dbElem);
                    }
                    coll.add(elem);
                }
                return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)true) : coll;
            }
            if (mmd.hasMap()) {
                Map map;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                TypeConverter keyConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_KEY);
                TypeConverter valConv = mapping.getTypeConverterForComponent(FieldRole.ROLE_MAP_VALUE);
                Map dbMap = (Map)((Object)value);
                for (Map.Entry dbMapEntry : dbMap.entrySet()) {
                    Object key = dbMapEntry.getKey();
                    if (keyConv != null) {
                        key = keyConv.toMemberType(dbMapEntry.getKey());
                    }
                    Object val = dbMapEntry.getValue();
                    if (valConv != null) {
                        val = valConv.toMemberType(dbMapEntry.getValue());
                    }
                    map.put(key, val);
                }
                return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true) : map;
            }
            if (!mmd.hasArray() && (strConv = this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class)) != null) {
                String strValue = (String)((Object)value);
                returnValue = strConv.toMemberType((Object)strValue);
            }
        }
        returnValue = optional ? Optional.of(returnValue) : returnValue;
        return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, returnValue, (boolean)true) : returnValue;
    }

    protected Object readObjectField(Column col, String familyName, String qualifName, Result result, AbstractMemberMetaData mmd, FieldRole role) {
        Class type;
        byte[] bytes = result.getValue(familyName.getBytes(), qualifName.getBytes());
        if (bytes == null) {
            return null;
        }
        Class clazz = type = Optional.class.isAssignableFrom(mmd.getType()) ? this.ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : mmd.getType();
        if (type == Boolean.class) {
            return this.fetchBooleanInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == Byte.class) {
            return this.fetchByteInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == Character.class) {
            return Character.valueOf(this.fetchCharInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd)));
        }
        if (type == Double.class) {
            return this.fetchDoubleInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == Float.class) {
            return Float.valueOf(this.fetchFloatInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd)));
        }
        if (type == Integer.class) {
            return this.fetchIntInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == Long.class) {
            return this.fetchLongInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == Short.class) {
            return this.fetchShortInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (type == String.class) {
            return this.fetchStringInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (Enum.class.isAssignableFrom(type)) {
            JdbcType jdbcType = TypeConversionHelper.getJdbcTypeForEnum((AbstractMemberMetaData)mmd, (FieldRole)role, (ClassLoaderResolver)this.ec.getClassLoaderResolver());
            if (MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType)) {
                return this.fetchIntInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
            }
            return this.fetchStringInternal(bytes, mmd.isSerialized(), HBaseUtils.getDefaultValueForMember(mmd));
        }
        if (Date.class.isAssignableFrom(type)) {
            // empty if block
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            String string = new String(bytes);
            return string;
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                bis.close();
            }
            catch (IOException ioe) {
                throw new NucleusException(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    private boolean fetchBooleanInternal(byte[] bytes, boolean serialised, String defaultValue) {
        boolean value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Boolean.valueOf(defaultValue);
            }
            return false;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readBoolean();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toBoolean((byte[])bytes);
        }
        return value;
    }

    private byte fetchByteInternal(byte[] bytes, boolean serialised, String defaultValue) {
        if (bytes == null) {
            if (defaultValue != null) {
                return defaultValue.getBytes()[0];
            }
            return 0;
        }
        return bytes[0];
    }

    private char fetchCharInternal(byte[] bytes, boolean serialised, String defaultValue) {
        char value;
        if (bytes == null) {
            if (defaultValue != null && defaultValue.length() > 0) {
                return defaultValue.charAt(0);
            }
            return '\u0000';
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readChar();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            String strValue = new String(bytes);
            value = strValue.charAt(0);
        }
        return value;
    }

    private double fetchDoubleInternal(byte[] bytes, boolean serialised, String defaultValue) {
        double value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Double.valueOf(defaultValue);
            }
            return 0.0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readDouble();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toDouble((byte[])bytes);
        }
        return value;
    }

    private float fetchFloatInternal(byte[] bytes, boolean serialised, String defaultValue) {
        float value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Float.valueOf(defaultValue).floatValue();
            }
            return 0.0f;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readFloat();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toFloat((byte[])bytes);
        }
        return value;
    }

    private int fetchIntInternal(byte[] bytes, boolean serialised, String defaultValue) {
        int value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Integer.valueOf(defaultValue);
            }
            return 0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readInt();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toInt((byte[])bytes);
        }
        return value;
    }

    private long fetchLongInternal(byte[] bytes, boolean serialised, String defaultValue) {
        long value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Long.valueOf(defaultValue);
            }
            return 0L;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readLong();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toLong((byte[])bytes);
        }
        return value;
    }

    private short fetchShortInternal(byte[] bytes, boolean serialised, String defaultValue) {
        short value;
        if (bytes == null) {
            if (defaultValue != null) {
                return Short.valueOf(defaultValue);
            }
            return 0;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                value = ois.readShort();
                ois.close();
                bis.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            value = Bytes.toShort((byte[])bytes);
        }
        return value;
    }

    private String fetchStringInternal(byte[] bytes, boolean serialised, String defaultValue) {
        if (bytes == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return null;
        }
        if (serialised) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                String value = (String)ois.readObject();
                ois.close();
                bis.close();
                return value;
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        return new String(bytes);
    }
}

