/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.metadata;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.datanucleus.jpa.annotations.DatastoreIdentity;
import org.datanucleus.jpa.annotations.Extension;
import org.datanucleus.jpa.annotations.Extensions;
import org.datanucleus.jpa.annotations.PersistenceAware;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.util.StringUtils;

public class JPAAnnotationUtils {
    public static final String ENTITY = Entity.class.getName();
    public static final String MAPPED_SUPERCLASS = MappedSuperclass.class.getName();
    public static final String EMBEDDABLE = Embeddable.class.getName();
    public static final String EMBEDDED = Embedded.class.getName();
    public static final String TABLE = Table.class.getName();
    public static final String COLUMN = Column.class.getName();
    public static final String ID_CLASS = IdClass.class.getName();
    public static final String ID = Id.class.getName();
    public static final String BASIC = Basic.class.getName();
    public static final String TRANSIENT = Transient.class.getName();
    public static final String ENUMERATED = Enumerated.class.getName();
    public static final String TEMPORAL_TYPE = TemporalType.class.getName();
    public static final String LOB = Lob.class.getName();
    public static final String VERSION = Version.class.getName();
    public static final String EMBEDDED_ID = EmbeddedId.class.getName();
    public static final String GENERATED_VALUE = GeneratedValue.class.getName();
    public static final String INHERITANCE = Inheritance.class.getName();
    public static final String DISCRIMINATOR_COLUMN = DiscriminatorColumn.class.getName();
    public static final String DISCRIMINATOR_VALUE = DiscriminatorValue.class.getName();
    public static final String ENTITY_LISTENERS = EntityListeners.class.getName();
    public static final String EXCLUDE_SUPERCLASS_LISTENERS = ExcludeSuperclassListeners.class.getName();
    public static final String EXCLUDE_DEFAULT_LISTENERS = ExcludeDefaultListeners.class.getName();
    public static final String SEQUENCE_GENERATOR = SequenceGenerator.class.getName();
    public static final String TABLE_GENERATOR = TableGenerator.class.getName();
    public static final String PRIMARY_KEY_JOIN_COLUMNS = PrimaryKeyJoinColumns.class.getName();
    public static final String PRIMARY_KEY_JOIN_COLUMN = PrimaryKeyJoinColumn.class.getName();
    public static final String ATTRIBUTE_OVERRIDES = AttributeOverrides.class.getName();
    public static final String ATTRIBUTE_OVERRIDE = AttributeOverride.class.getName();
    public static final String ASSOCIATION_OVERRIDES = AssociationOverrides.class.getName();
    public static final String ASSOCIATION_OVERRIDE = AssociationOverride.class.getName();
    public static final String NAMED_QUERIES = NamedQueries.class.getName();
    public static final String NAMED_QUERY = NamedQuery.class.getName();
    public static final String NAMED_NATIVE_QUERIES = NamedNativeQueries.class.getName();
    public static final String NAMED_NATIVE_QUERY = NamedNativeQuery.class.getName();
    public static final String SQL_RESULTSET_MAPPINGS = SqlResultSetMappings.class.getName();
    public static final String SQL_RESULTSET_MAPPING = SqlResultSetMapping.class.getName();
    public static final String SECONDARY_TABLES = SecondaryTables.class.getName();
    public static final String SECONDARY_TABLE = SecondaryTable.class.getName();
    public static final String JOIN_TABLE = JoinTable.class.getName();
    public static final String MAP_KEY = MapKey.class.getName();
    public static final String ORDER_BY = OrderBy.class.getName();
    public static final String ONE_TO_ONE = OneToOne.class.getName();
    public static final String ONE_TO_MANY = OneToMany.class.getName();
    public static final String MANY_TO_ONE = ManyToOne.class.getName();
    public static final String MANY_TO_MANY = ManyToMany.class.getName();
    public static final String JOIN_COLUMNS = JoinColumns.class.getName();
    public static final String JOIN_COLUMN = JoinColumn.class.getName();
    public static final String PERSISTENCE_AWARE = PersistenceAware.class.getName();
    public static final String DATASTORE_IDENTITY = DatastoreIdentity.class.getName();
    public static final String EXTENSIONS = Extensions.class.getName();
    public static final String EXTENSION = Extension.class.getName();
    public static final String ELEMENT_COLLECTION = ElementCollection.class.getName();
    public static final String COLLECTION_TABLE = CollectionTable.class.getName();
    public static final String ORDER_COLUMN = OrderColumn.class.getName();

    public static String getIdentityStrategyString(GenerationType type) {
        if (type == GenerationType.AUTO) {
            return IdentityStrategy.NATIVE.toString();
        }
        if (type == GenerationType.IDENTITY) {
            return IdentityStrategy.IDENTITY.toString();
        }
        if (type == GenerationType.SEQUENCE) {
            return IdentityStrategy.SEQUENCE.toString();
        }
        if (type == GenerationType.TABLE) {
            return IdentityStrategy.INCREMENT.toString();
        }
        return null;
    }

    public static boolean isBasicByDefault(Class type) {
        return byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type) || char[].class.isAssignableFrom(type) || Character[].class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type) || java.util.Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Time.class.isAssignableFrom(type) || Timestamp.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type);
    }

    public static boolean isTemporalType(Class type) {
        return type == java.util.Date.class || type == Date.class || type == Time.class || type == Timestamp.class || type == Calendar.class;
    }

    static ColumnMetaData getColumnMetaDataForColumnAnnotation(MetaData parent, Member field, Column column) {
        String columnTable;
        String columnName = column.name();
        String target = null;
        String targetField = null;
        String jdbcType = null;
        String sqlType = null;
        String length = null;
        String scale = null;
        String allowsNull = null;
        String defaultValue = null;
        String insertValue = null;
        String insertable = null;
        String updateable = null;
        String unique = null;
        String table = null;
        if (field.getType().isPrimitive()) {
            length = "" + column.precision();
            if (length.equals("")) {
                length = null;
            }
            if ((scale = "" + column.scale()).equals("")) {
                scale = null;
            }
            if ((length == null || length.equals("0")) && Character.TYPE.isAssignableFrom(field.getType())) {
                length = "1";
            }
            if (field.getType() == Boolean.TYPE) {
                jdbcType = "SMALLINT";
            }
        } else if (String.class.isAssignableFrom(field.getType())) {
            length = "" + column.length();
            if (length.equals("")) {
                length = null;
            }
        } else if (Number.class.isAssignableFrom(field.getType())) {
            length = "" + column.precision();
            if (length.equals("")) {
                length = null;
            }
            if ((scale = "" + column.scale()).equals("")) {
                scale = null;
            }
        }
        allowsNull = new Boolean(column.nullable()).toString();
        insertable = new Boolean(column.insertable()).toString();
        updateable = new Boolean(column.updatable()).toString();
        unique = new Boolean(column.unique()).toString();
        table = column.table();
        if (table != null && !StringUtils.isWhitespace((String)(columnTable = table))) {
            table = columnTable;
        }
        ColumnMetaData colmd = new ColumnMetaData();
        colmd.setName(columnName);
        colmd.setTarget(target);
        colmd.setTargetMember(targetField);
        colmd.setJdbcType(jdbcType);
        colmd.setSqlType(sqlType);
        colmd.setLength(length);
        colmd.setScale(scale);
        colmd.setAllowsNull(allowsNull);
        colmd.setDefaultValue(defaultValue);
        colmd.setInsertValue(insertValue);
        colmd.setInsertable(insertable);
        colmd.setUpdateable(updateable);
        colmd.setUnique(unique);
        return colmd;
    }
}

