/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.jdo.JDODataStoreCache;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.jpa.EntityManagerImpl;
import org.datanucleus.jpa.JPAClassTransformer;
import org.datanucleus.jpa.JPADataStoreCache;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.jpa.PersistenceProviderImpl;
import org.datanucleus.jpa.exceptions.NotProviderException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    protected PersistenceManagerFactory pmf;
    private static Map<String, PersistenceUnitMetaData> unitMetaDataCache = null;
    private PersistenceUnitMetaData unitMetaData = null;
    private boolean closed = false;
    private boolean containerManaged = false;
    private Cache datastoreCache = null;

    public EntityManagerFactoryImpl() {
    }

    public EntityManagerFactoryImpl(PersistenceUnitInfo unitInfo, Map overridingProps) {
        boolean allowMetadataLoad;
        this.containerManaged = true;
        boolean validProvider = false;
        if (unitInfo.getPersistenceProviderClassName() == null || unitInfo.getPersistenceProviderClassName().equals(PersistenceProviderImpl.class.getName()) || overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)unitInfo.getPersistenceUnitName()));
        }
        URI rootURI = null;
        try {
            rootURI = unitInfo.getPersistenceUnitRootUrl().toURI();
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.JTA.toString(), rootURI);
        } else if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.RESOURCE_LOCAL.toString(), rootURI);
        }
        List classNames = unitInfo.getManagedClassNames();
        Iterator classIter = classNames.iterator();
        while (classIter.hasNext()) {
            this.unitMetaData.addClassName((String)classIter.next());
        }
        List mappingFileNames = unitInfo.getMappingFileNames();
        Iterator mappingFileIter = mappingFileNames.iterator();
        while (mappingFileIter.hasNext()) {
            this.unitMetaData.addMappingFile((String)mappingFileIter.next());
        }
        List jarUrls = unitInfo.getJarFileUrls();
        Iterator jarUrlIter = jarUrls.iterator();
        while (jarUrlIter.hasNext()) {
            this.unitMetaData.addJarFile((URL)jarUrlIter.next());
        }
        Properties props = unitInfo.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            this.unitMetaData.addProperty(prop, props.getProperty(prop));
        }
        if (unitInfo.excludeUnlistedClasses()) {
            this.unitMetaData.setExcludeUnlistedClasses();
        }
        this.unitMetaData.setProvider(unitInfo.getPersistenceProviderClassName());
        if (overridingProps == null) {
            overridingProps = new HashMap<String, Object>();
        }
        if (unitInfo.getJtaDataSource() != null) {
            overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getJtaDataSource());
        }
        if (unitInfo.getNonJtaDataSource() != null) {
            overridingProps.put("datanucleus.ConnectionFactory2", unitInfo.getNonJtaDataSource());
        }
        if (unitInfo.getClassLoader() != null) {
            overridingProps.put("datanucleus.primaryClassLoader", unitInfo.getClassLoader());
        }
        unitInfo.addTransformer((ClassTransformer)new JPAClassTransformer());
        this.pmf = this.initialisePMF(this.unitMetaData, overridingProps);
        JDODataStoreCache cache = (JDODataStoreCache)this.pmf.getDataStoreCache();
        OMFContext omfCtx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        if (cache != null) {
            this.datastoreCache = new JPADataStoreCache(omfCtx, cache.getLevel2Cache());
        }
        if (!(allowMetadataLoad = omfCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime"))) {
            omfCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public EntityManagerFactoryImpl(String unitName, Map overridingProps) {
        boolean allowMetadataLoad;
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new HashMap<String, PersistenceUnitMetaData>();
        }
        this.unitMetaData = unitMetaDataCache.get(unitName);
        if (this.unitMetaData == null) {
            OMFContext pmfCtxt = new OMFContext(new PersistenceConfiguration(){});
            pmfCtxt.setApi("JPA");
            MetaDataManager metadataMgr = pmfCtxt.getMetaDataManager();
            PersistenceFileMetaData[] files = metadataMgr.parsePersistenceFiles();
            if (files == null) {
                NucleusLogger.JPA.warn((Object)LOCALISER.msg("EMF.NoPersistenceXML"));
            } else {
                for (int i = 0; i < files.length; ++i) {
                    PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
                    for (int j = 0; j < unitmds.length; ++j) {
                        unitMetaDataCache.put(unitmds[j].getName(), unitmds[j]);
                        if (!unitmds[j].getName().equals(unitName)) continue;
                        this.unitMetaData = unitmds[j];
                        this.unitMetaData.clearJarFiles();
                    }
                }
            }
            if (this.unitMetaData == null) {
                NucleusLogger.JPA.warn((Object)LOCALISER.msg("EMF.PersistenceUnitNotFound", (Object)unitName));
            } else {
                unitMetaDataCache.put(this.unitMetaData.getName(), this.unitMetaData);
            }
        }
        boolean validProvider = false;
        if (this.unitMetaData != null && (this.unitMetaData.getProvider() == null || this.unitMetaData.getProvider().equals(PersistenceProviderImpl.class.getName()))) {
            validProvider = true;
        }
        if (overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)unitName));
        }
        this.pmf = this.initialisePMF(this.unitMetaData, overridingProps);
        JDODataStoreCache cache = (JDODataStoreCache)this.pmf.getDataStoreCache();
        OMFContext omfCtx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        if (cache != null) {
            this.datastoreCache = new JPADataStoreCache(omfCtx, cache.getLevel2Cache());
        }
        if (!(allowMetadataLoad = omfCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime"))) {
            omfCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public EntityManager createEntityManager() {
        return this.newEntityManager(PersistenceContextType.EXTENDED, this.pmf);
    }

    public EntityManager createEntityManager(Map overridingProps) {
        PersistenceManagerFactory thePMF = this.initialisePMF(this.unitMetaData, overridingProps);
        return this.newEntityManager(PersistenceContextType.EXTENDED, thePMF);
    }

    protected EntityManager newEntityManager(PersistenceContextType contextType, PersistenceManagerFactory pmf) {
        return new EntityManagerImpl(this, pmf, contextType);
    }

    protected PersistenceManagerFactory initialisePMF(PersistenceUnitMetaData unitMetaData, Map overridingProps) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.jdo.JDOPersistenceManagerFactory");
        props.put("datanucleus.persistenceApiName", "JPA");
        if (unitMetaData.getJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactoryName", unitMetaData.getJtaDataSource());
        }
        if (unitMetaData.getNonJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactory2Name", unitMetaData.getNonJtaDataSource());
        }
        if (unitMetaData != null) {
            Properties unitProps;
            if (unitMetaData.getTransactionType() != null) {
                props.put("datanucleus.TransactionType", unitMetaData.getTransactionType().toString());
            }
            if ((unitProps = unitMetaData.getProperties()) != null) {
                props.putAll(unitProps);
            }
        }
        if (overridingProps != null) {
            props.putAll(overridingProps);
        }
        props.put("datanucleus.autoStartMechanism", "None");
        props.remove("datanucleus.PersistenceUnitName");
        PersistenceManagerFactory thePMF = JDOHelper.getPersistenceManagerFactory(props);
        if (unitMetaData != null) {
            ObjectManagerFactoryImpl omf = (ObjectManagerFactoryImpl)thePMF;
            omf.getOMFContext().getMetaDataManager().loadPersistenceUnit(unitMetaData, null);
        }
        return thePMF;
    }

    public Map<String, Object> getProperties() {
        PersistenceConfiguration conf = ((ObjectManagerFactoryImpl)this.pmf).getOMFContext().getPersistenceConfiguration();
        return conf.getOptions();
    }

    public Set<String> getSupportedProperties() {
        PersistenceConfiguration conf = ((ObjectManagerFactoryImpl)this.pmf).getOMFContext().getPersistenceConfiguration();
        return conf.getSupportedOptions();
    }

    public Cache getCache() {
        return this.datastoreCache;
    }
}

