/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.json;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import javax.transaction.xa.XAResource;

import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;

/**
 * Implementation of a ConnectionFactory for JSON. The connections are
 * only created and they are not managed. All operations besides getConnection are no-op.
 */
public class ConnectionFactoryImpl extends AbstractConnectionFactory
{
    // TODO Where is this defined ? Persistence property ? If so then should not have "org."
    public static final String STORE_JSON_URL = "org.datanucleus.store.json.url";

    /**
     * Constructor.
     * @param omfContext The OMF context
     * @param resourceType Type of resource (tx, nontx)
     */
    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType)
    {
        super(omfContext, resourceType);
    }

    /**
     * Obtain a connection from the Factory. The connection will be enlisted within the {@link org.datanucleus.Transaction} 
     * associated to the <code>poolKey</code> if "enlist" is set to true.
     * @param poolKey the pool that is bound the connection during its lifecycle (or null)
     * @param options Any options for then creating the connection
     * @return the {@link org.datanucleus.store.connection.ManagedConnection}
     */
    public ManagedConnection createManagedConnection(Object poolKey, Map options)
    {
        return new ManagedConnectionImpl(omfContext, options);
    }

    /**
     * Implementation of a ManagedConnection for LDAP.
     */
    public static class ManagedConnectionImpl extends AbstractManagedConnection
    {
        OMFContext omf;
        Map options;

        public ManagedConnectionImpl(OMFContext omf, Map options)
        {
            this.omf = omf;
            this.options = options;
        }

        public void close()
        {
            // TODO Auto-generated method stub
        }

        public Object getConnection()
        {
            String urlStr = omf.getStoreManager().getConnectionURL();
            urlStr = urlStr.substring(urlStr.indexOf(omf.getStoreManager().getStoreManagerKey()+":")+omf.getStoreManager().getStoreManagerKey().length()+1);
            if (options.containsKey(STORE_JSON_URL))
            {
                if(urlStr.endsWith("/") && options.get(STORE_JSON_URL).toString().startsWith("/"))
                {
                    urlStr += options.get(STORE_JSON_URL).toString().substring(1);
                }
                else if(!urlStr.endsWith("/") && !options.get(STORE_JSON_URL).toString().startsWith("/"))
                {
                    urlStr += "/"+options.get(STORE_JSON_URL).toString();
                }
                else
                {
                    urlStr += options.get(STORE_JSON_URL).toString();
                }
            }
            URL url;
            try
            {
                url = new URL(urlStr);
                return url.openConnection();
            }
            catch (MalformedURLException e)
            {
                throw new NucleusDataStoreException(e.getMessage(),e);
            }
            catch (IOException e)
            {
                throw new NucleusDataStoreException(e.getMessage(),e);
            }
        }

        public XAResource getXAResource()
        {
            return null;
        }
    }
}