/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.BaseElementContainerStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.util.Localiser;

abstract class RDBMSElementContainerStoreSpecialization
extends BaseElementContainerStoreSpecialization {
    protected final RDBMSManager storeMgr;
    protected String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected boolean usingDiscriminatorInSizeStmt = false;

    RDBMSElementContainerStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super(localiser, clr);
        this.storeMgr = storeMgr;
    }

    protected void invalidateAddStmt() {
        this.addStmt = null;
    }

    protected String getAddStmt(ElementContainerStore ecs) {
        if (this.addStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("INSERT INTO ");
            stmt.append(ecs.getContainerTable().toString());
            stmt.append(" (");
            for (i = 0; i < ecs.getOwnerMapping().getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ecs.getOwnerMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            for (i = 0; i < ecs.getElementMapping().getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(ecs.getElementMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            if (ecs.getOrderMapping() != null) {
                for (i = 0; i < ecs.getOrderMapping().getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(ecs.getOrderMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            if (ecs.getRelationDiscriminatorMapping() != null) {
                for (i = 0; i < ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(ecs.getRelationDiscriminatorMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                }
            }
            stmt.append(") VALUES (");
            for (i = 0; i < ecs.getOwnerMapping().getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)ecs.getOwnerMapping().getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < ecs.getElementMapping().getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)ecs.getElementMapping().getDataStoreMapping(0)).getInsertionInputParameter());
            }
            if (ecs.getOrderMapping() != null) {
                for (i = 0; i < ecs.getOrderMapping().getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)ecs.getOrderMapping().getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            if (ecs.getRelationDiscriminatorMapping() != null) {
                for (i = 0; i < ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)ecs.getRelationDiscriminatorMapping().getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            stmt.append(") ");
            this.addStmt = stmt.toString();
        }
        return this.addStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClear(StateManager ownerSM, ElementContainerStore ecs) {
        String clearStmt = this.getClearStmt(ecs);
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearStmt), (Throwable)e);
        }
    }

    protected String getClearStmt(ElementContainerStore ecs) {
        if (this.clearStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(ecs.getContainerTable().toString());
            stmt.append(" WHERE ");
            for (i = 0; i < ecs.getOwnerMapping().getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ecs.getOwnerMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ecs.getOwnerMapping().getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (ecs.getRelationDiscriminatorMapping() != null) {
                for (i = 0; i < ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(ecs.getRelationDiscriminatorMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)ecs.getRelationDiscriminatorMapping().getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearStmt = stmt.toString();
        }
        return this.clearStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(StateManager ownerSM, ElementContainerStore ecs) {
        int numRows;
        String sizeStmt = this.getSizeStmt(ecs);
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getElementInfo() != null && ecs.getElementInfo().length == 1) {
                        for (int i = 0; i < ecs.getElementInfo().length; ++i) {
                            if (ecs.getElementInfo()[i].getDiscriminatorMapping() == null) continue;
                            jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, ecs.getElementInfo()[i], this.clr);
                        }
                    }
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, ecs);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException(this.localiser.msg("056007", (Object)sizeStmt));
                        }
                        numRows = rs.getInt(1);
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056007", (Object)sizeStmt), (Throwable)e);
        }
        return numRows;
    }

    protected String getSizeStmt(ElementContainerStore ecs) {
        int i;
        int i2;
        if (this.sizeStmt != null && !this.usingDiscriminatorInSizeStmt) {
            return this.sizeStmt;
        }
        boolean allowNulls = false;
        if (ecs.getOwnerMemberMetaData() != null && ecs.getOwnerMemberMetaData().hasExtension("allow-nulls") && ecs.getOwnerMemberMetaData().getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            allowNulls = true;
        }
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("SELECT COUNT(*) FROM ");
        stmt.append(ecs.getContainerTable().toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (ecs.getElementInfo() != null && ecs.getElementInfo().length == 1 && ecs.getElementInfo()[0].getDatastoreClass() != ecs.getContainerTable() && ecs.getElementInfo()[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = ecs.getElementInfo()[0].getDatastoreClass().getIDMapping();
            if (allowNulls) {
                stmt.append(" LEFT OUTER JOIN ");
            } else {
                stmt.append(" INNER JOIN ");
            }
            stmt.append(ecs.getElementInfo()[0].getDatastoreClass().toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i2 = 0; i2 < ecs.getElementMapping().getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(ecs.getElementMapping().getDataStoreMapping(i2).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < ecs.getOwnerMapping().getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".").append(ecs.getOwnerMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append("=");
            stmt.append(((RDBMSMapping)ecs.getOwnerMapping().getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (ecs.getOrderMapping() != null) {
            for (i = 0; i < ecs.getOrderMapping().getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(ecs.getOrderMapping().getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(">=0");
            }
        }
        if (ecs.getElementInfo() != null && ecs.getElementInfo().length == 1) {
            StringBuffer discrStmt = new StringBuffer();
            for (i2 = 0; i2 < ecs.getElementInfo().length; ++i2) {
                if (ecs.getElementInfo()[i2].getDiscriminatorMapping() == null) continue;
                this.usingDiscriminatorInSizeStmt = true;
                if (discrStmt.length() > 0) {
                    discrStmt.append(" OR ");
                }
                JavaTypeMapping discrimMapping = ecs.getElementInfo()[i2].getDiscriminatorMapping();
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                    if (joinedDiscrim) {
                        discrStmt.append(joinedElementAlias);
                    } else {
                        discrStmt.append(containerAlias);
                    }
                    discrStmt.append(".");
                    discrStmt.append(discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().toString());
                    discrStmt.append("=");
                    discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                }
                HashSet subclasses = this.storeMgr.getSubClassesForClass(ecs.getElementInfo()[i2].getClassName(), true, this.clr);
                if (subclasses == null || subclasses.size() <= 0) continue;
                for (int j = 0; j < subclasses.size(); ++j) {
                    for (int k = 0; k < discrimMapping.getNumberOfDatastoreFields(); ++k) {
                        discrStmt.append(" OR ");
                        if (joinedDiscrim) {
                            discrStmt.append(joinedElementAlias);
                        } else {
                            discrStmt.append(containerAlias);
                        }
                        discrStmt.append(".");
                        discrStmt.append(discrimMapping.getDataStoreMapping(k).getDatastoreField().getIdentifier().toString());
                        discrStmt.append("=");
                        discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(k)).getUpdateInputParameter());
                    }
                }
            }
            if (discrStmt.length() > 0) {
                stmt.append(" AND (");
                stmt.append(discrStmt);
                if (allowNulls) {
                    stmt.append(" OR ");
                    stmt.append(ecs.getElementInfo()[0].getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier().toString());
                    stmt.append(" IS NULL");
                }
                stmt.append(")");
            }
        }
        if (ecs.getRelationDiscriminatorMapping() != null) {
            for (int i3 = 0; i3 < ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreFields(); ++i3) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(ecs.getRelationDiscriminatorMapping().getDataStoreMapping(i3).getDatastoreField().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)ecs.getRelationDiscriminatorMapping().getDataStoreMapping(i3)).getUpdateInputParameter());
            }
        }
        this.sizeStmt = stmt.toString();
        return this.sizeStmt;
    }
}

