/**********************************************************************
 Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Contributors:
 ...
 **********************************************************************/
package org.datanucleus.store.rdbms.scostore;

import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Specialization interface for {@link AbstractCollectionStore}.
 * {@link AbstractCollectionStore} delegates to instances of this interface for behavior
 * that is tied to a specific datastore implementation.
 */
public interface AbstractCollectionStoreSpecialization extends ElementContainerStoreSpecialization
{
    /**
     * @see AbstractCollectionStore#updateEmbeddedElement
     */
    boolean updateEmbeddedElement(ObjectProvider sm, Object element, int fieldNumber, Object value,
            JavaTypeMapping fieldMapping, ElementContainerStore ecs);

    /**
     * @see AbstractCollectionStore#contains
     */
    boolean contains(ObjectProvider sm, Object element, AbstractCollectionStore acs);

    /**
     * Method to process a "remove" statement
     * @param ownerSM StateManager for the owner
     * @param conn The connection
     * @param batched Whether we are batching it
     * @param element The element
     * @param executeNow Whether to execute the statement rather than allow batching til later
     * @param acs The abstract collection store
     * @return Number of records changed (0 if batch since nothing yet changed)
     * @throws MappedDatastoreException Wraps any exceptions thrown by the underlying datastore.
     */
    int[] internalRemove(ObjectProvider ownerSM, ManagedConnection conn, boolean batched, Object element,
            boolean executeNow, AbstractCollectionStore acs) throws MappedDatastoreException;
}
