/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;

public abstract class SetStoreIterator
implements Iterator {
    private final AbstractSetStore abstractSetStore;
    private final ObjectProvider sm;
    private final ExecutionContext ec;
    private final Iterator delegate;
    private Object lastElement = null;

    public SetStoreIterator(ObjectProvider sm, Object rs, ResultObjectFactory rof, AbstractSetStore abstractSetStore) throws MappedDatastoreException {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.abstractSetStore = abstractSetStore;
        ArrayList<Object> results = new ArrayList<Object>();
        if (rs != null) {
            while (this.next(rs)) {
                Object nextElement;
                int i;
                int[] param;
                if (abstractSetStore.elementsAreEmbedded || abstractSetStore.elementsAreSerialised) {
                    param = new int[abstractSetStore.elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (abstractSetStore.elementMapping instanceof SerialisedPCMapping || abstractSetStore.elementMapping instanceof SerialisedReferenceMapping || abstractSetStore.elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (abstractSetStore.containerTable != null) {
                            ownerFieldNumber = this.getOwnerMemberMetaData(abstractSetStore.containerTable).getAbsoluteFieldNumber();
                        }
                        nextElement = abstractSetStore.elementMapping.getObject(this.ec, rs, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = abstractSetStore.elementMapping.getObject(this.ec, rs, param);
                    }
                } else if (abstractSetStore.elementMapping instanceof ReferenceMapping) {
                    param = new int[abstractSetStore.elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = abstractSetStore.elementMapping.getObject(this.ec, rs, param);
                } else {
                    nextElement = rof.getObject(this.ec, rs);
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.iterator();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    public synchronized void remove() {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to remove");
        }
        this.abstractSetStore.remove(this.sm, this.lastElement, -1, true);
        this.delegate.remove();
        this.lastElement = null;
    }

    protected abstract boolean next(Object var1) throws MappedDatastoreException;

    protected abstract AbstractMemberMetaData getOwnerMemberMetaData(DatastoreContainerObject var1);
}

