/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.util.Collection;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.backed.BackedSCO;
import org.datanucleus.util.NucleusLogger;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        return Collection.class;
    }

    @Override
    public void insertPostProcessing(ObjectProvider ownerOP) {
    }

    @Override
    public void postInsert(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ExecutionContext)ec, (Object)value);
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerOP, null, false, false);
            return;
        }
        Object[] collElements = value.toArray();
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            for (int i = 0; i < collElements.length; ++i) {
                if (ec.getApiAdapter().isDetached(collElements[i]) || ec.getApiAdapter().isPersistent(collElements[i])) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), collElements[i]);
            }
            this.replaceFieldWithWrapper(ownerOP, value, false, false);
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            boolean needsAttaching = false;
            for (int i = 0; i < collElements.length; ++i) {
                if (!ownerOP.getExecutionContext().getApiAdapter().isDetached(collElements[i])) continue;
                needsAttaching = true;
                break;
            }
            if (needsAttaching) {
                SCO collWrapper = this.replaceFieldWithWrapper(ownerOP, null, false, false);
                collWrapper.attachCopy((Object)value);
            } else if (value.size() > 0) {
                ((CollectionStore)this.storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, value.getClass())).addAll(ownerOP, value, 0);
                this.replaceFieldWithWrapper(ownerOP, value, false, false);
            } else if (this.mmd.getRelationType(ownerOP.getExecutionContext().getClassLoaderResolver()) == RelationType.MANY_TO_MANY_BI) {
                this.replaceFieldWithWrapper(ownerOP, null, false, false);
            } else {
                this.replaceFieldWithWrapper(ownerOP, value, false, false);
            }
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ExecutionContext)ec, (Object)value);
            return;
        }
        if (value == null) {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerOP);
            this.replaceFieldWithWrapper(ownerOP, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)value;
            if (ownerOP.getObject() == sco.getOwner() && this.mmd.getName().equals(sco.getFieldName())) {
                ownerOP.getExecutionContext().flushSCOOperationsForBackingStore(((BackedSCO)sco).getBackingStore(), ownerOP);
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException(LOCALISER.msg("CollectionMapping.WrongOwnerError")).setFatal();
            }
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        CollectionStore backingStore = (CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        backingStore.update(ownerOP, value);
        this.replaceFieldWithWrapper(ownerOP, value, false, false);
    }

    @Override
    public void preDelete(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerOP.isLoaded(this.getAbsoluteFieldNumber());
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        boolean dependent = this.mmd.getCollection().isDependentElement();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        boolean hasJoin = this.mmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(ownerOP.getExecutionContext().getClassLoaderResolver());
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (ownerOP.getExecutionContext().getNucleusContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
            hasFK = false;
        }
        if (ownerOP.getExecutionContext().getManageRelations()) {
            ownerOP.getExecutionContext().getRelationshipManager(ownerOP).relationChange(this.getAbsoluteFieldNumber(), (Object)value, null);
        }
        if (dependent || hasJoin || !hasFK) {
            if (!(value instanceof SCO)) {
                value = (Collection)ownerOP.wrapSCOField(this.getAbsoluteFieldNumber(), (Object)value, false, false, true);
            }
            value.clear();
            ownerOP.getExecutionContext().flushSCOOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerOP);
        }
    }
}

