/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMappingFactory;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ObjectMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedLocalFileMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMultiMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSMappingManager
implements MappingManager {
    protected final RDBMSStoreManager storeMgr;
    protected final ClassLoaderResolver clr;
    protected MultiMap datastoreMappingsByJavaType;
    protected MultiMap datastoreMappingsByJDBCType;
    protected MultiMap datastoreMappingsBySQLType;

    public RDBMSMappingManager(RDBMSStoreManager storeMgr) {
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
    }

    @Override
    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
        if (this.datastoreMappingsByJavaType != null) {
            return;
        }
        this.datastoreMappingsByJDBCType = new MultiMap();
        this.datastoreMappingsBySQLType = new MultiMap();
        this.datastoreMappingsByJavaType = new MultiMap();
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.datastore_mapping", null, null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("java-type").trim();
                String rdbmsMappingClassName = elems[i].getAttribute("rdbms-mapping-class");
                String jdbcType = elems[i].getAttribute("jdbc-type");
                String sqlType = elems[i].getAttribute("sql-type");
                String defaultJava = elems[i].getAttribute("default");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                Class mappingType = null;
                if (StringUtils.isWhitespace((String)rdbmsMappingClassName)) continue;
                try {
                    mappingType = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), rdbmsMappingClassName);
                }
                catch (NucleusException ne) {
                    NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"041013", (Object[])new Object[]{rdbmsMappingClassName}));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                ConfigurationElement[] childElm = elems[i].getChildren();
                for (int j = 0; j < childElm.length; ++j) {
                    if (childElm[j].getName().equals("includes")) {
                        includes.add(childElm[j].getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElm[j].getName().equals("excludes")) continue;
                    excludes.add(childElm[j].getAttribute("vendor-id"));
                }
                if (excludes.contains(vendorId) || !includes.isEmpty() && !includes.contains(vendorId)) continue;
                this.registerDatastoreMapping(javaName, mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    @Override
    public JavaTypeMapping getMappingWithDatastoreMapping(Class javaType, boolean serialised, boolean embedded, ClassLoaderResolver clr) {
        try {
            DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(javaType.getName(), clr);
            return datastoreClass.getIdMapping();
        }
        catch (NoTableManagedException ex) {
            MappingConverterDetails mcd = this.getMappingClass(javaType, serialised, embedded, null, null);
            Class mc = mcd.mappingClass;
            try {
                JavaTypeMapping m = (JavaTypeMapping)mc.newInstance();
                m.initialize(this.storeMgr, javaType.getName());
                if (m.hasSimpleDatastoreRepresentation()) {
                    this.createDatastoreMapping(m, null, m.getJavaTypeForDatastoreMapping(0));
                }
                return m;
            }
            catch (NucleusUserException nue) {
                throw nue;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
    }

    @Override
    public JavaTypeMapping getMapping(Class javaType) {
        return this.getMapping(javaType, false, false, (String)null);
    }

    @Override
    public JavaTypeMapping getMapping(Class javaType, boolean serialised, boolean embedded, String fieldName) {
        MappingConverterDetails mcd = this.getMappingClass(javaType, serialised, embedded, null, fieldName);
        Class mc = mcd.mappingClass;
        try {
            JavaTypeMapping m = (JavaTypeMapping)mc.newInstance();
            m.initialize(this.storeMgr, javaType.getName());
            return m;
        }
        catch (Exception e) {
            throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
        }
    }

    @Override
    public JavaTypeMapping getMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr, FieldRole fieldRole) {
        JavaTypeMapping m;
        if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT || fieldRole == FieldRole.ROLE_ARRAY_ELEMENT) {
            return this.getElementMapping(table, mmd, fieldRole, clr);
        }
        if (fieldRole == FieldRole.ROLE_MAP_KEY) {
            return this.getKeyMapping(table, mmd, clr);
        }
        if (fieldRole == FieldRole.ROLE_MAP_VALUE) {
            return this.getValueMapping(table, mmd, clr);
        }
        TypeManager typeMgr = table.getStoreManager().getNucleusContext().getTypeManager();
        TypeConverter conv = null;
        if (!mmd.isTypeConversionDisabled()) {
            if (mmd.getTypeConverterName() != null) {
                conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
            } else {
                TypeConverter autoApplyConv = typeMgr.getAutoApplyTypeConverterForType(mmd.getType());
                if (autoApplyConv != null) {
                    conv = autoApplyConv;
                }
            }
            if (conv != null) {
                Class<TypeConverterMapping> mc = TypeConverterMapping.class;
                JavaTypeMapping m2 = null;
                try {
                    m2 = (JavaTypeMapping)mc.newInstance();
                    m2.setRoleForMember(FieldRole.ROLE_FIELD);
                    ((TypeConverterMapping)m2).initialize(mmd, table, clr, conv);
                    return m2;
                }
                catch (Exception e) {
                    throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
                }
            }
        }
        AbstractMemberMetaData overrideMmd = null;
        MappingConverterDetails mcd = null;
        Class<SerialisedLocalFileMapping> mc = null;
        String userMappingClassName = mmd.getValueForExtension("mapping-class");
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException ne) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{mmd.getFullFieldName(), userMappingClassName})).setFatal();
            }
        } else {
            Object typeCmd = null;
            typeCmd = mmd.getType().isInterface() ? this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(mmd.getType(), clr) : this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (mmd.hasExtension("serializeToFileLocation") && Serializable.class.isAssignableFrom(mmd.getType())) {
                mc = SerialisedLocalFileMapping.class;
            } else if (mmd.isSerialized()) {
                mcd = this.getMappingClass(mmd.getType(), true, false, null, mmd.getFullFieldName());
            } else if (mmd.getEmbeddedMetaData() != null) {
                mcd = this.getMappingClass(mmd.getType(), false, true, null, mmd.getFullFieldName());
            } else if (typeCmd != null && typeCmd.isEmbeddedOnly()) {
                mcd = this.getMappingClass(mmd.getType(), false, true, null, mmd.getFullFieldName());
            } else if (mmd.isEmbedded()) {
                mcd = this.getMappingClass(mmd.getType(), true, false, mmd.getColumnMetaData(), mmd.getFullFieldName());
            } else {
                mcd = this.getMappingClass(mmd.getType(), false, false, mmd.getColumnMetaData(), mmd.getFullFieldName());
                if (mmd.getParent() instanceof EmbeddedMetaData && mmd.getRelationType(clr) != RelationType.NONE) {
                    AbstractClassMetaData cmdForFmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(mmd.getClassName(), clr);
                    overrideMmd = cmdForFmd.getMetaDataForMember(mmd.getName());
                }
            }
        }
        if (mcd != null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            try {
                m = (JavaTypeMapping)mc.newInstance();
                m.setRoleForMember(FieldRole.ROLE_FIELD);
                m.initialize(mmd, table, clr);
                if (overrideMmd != null) {
                    m.setMemberMetaData(overrideMmd);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                m = (JavaTypeMapping)mcd.mappingClass.newInstance();
                m.setRoleForMember(FieldRole.ROLE_FIELD);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                if (overrideMmd != null) {
                    m.setMemberMetaData(overrideMmd);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for member at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected MappingConverterDetails getMappingClass(Class javaType, boolean serialised, boolean embedded, ColumnMetaData[] colmds, String fieldName) {
        Class superClass;
        MappingConverterDetails mcd;
        ApiAdapter api = this.storeMgr.getApiAdapter();
        if (api.isPersistable(javaType)) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedPCMapping.class);
            }
            if (embedded) {
                return new MappingConverterDetails(EmbeddedPCMapping.class);
            }
            return new MappingConverterDetails(PersistableMapping.class);
        }
        if (javaType.isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(javaType.getName())) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedReferenceMapping.class);
            }
            if (embedded) {
                return new MappingConverterDetails(EmbeddedPCMapping.class);
            }
            return new MappingConverterDetails(InterfaceMapping.class);
        }
        if (javaType == Object.class) {
            if (serialised) {
                return new MappingConverterDetails(SerialisedReferenceMapping.class);
            }
            if (embedded) {
                throw new NucleusUserException(Localiser.msg((String)"041042", (Object[])new Object[]{fieldName})).setFatal();
            }
            return new MappingConverterDetails(ObjectMapping.class);
        }
        if (javaType.isArray()) {
            if (api.isPersistable(javaType.getComponentType())) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
            if (javaType.getComponentType().isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(javaType.getComponentType().getName())) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
            if (javaType.getComponentType() == Object.class) {
                return new MappingConverterDetails(ArrayMapping.class);
            }
        }
        if ((mcd = this.getDefaultJavaTypeMapping(javaType, colmds)) == null || mcd.mappingClass == null) {
            for (superClass = javaType.getSuperclass(); !(superClass == null || superClass.getName().equals(ClassNameConstants.Object) || mcd != null && mcd.mappingClass != null); superClass = superClass.getSuperclass()) {
                mcd = this.getDefaultJavaTypeMapping(superClass, colmds);
            }
        }
        if (mcd == null) {
            if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(javaType.getName())) {
                throw new NucleusUserException(Localiser.msg((String)"041001", (Object[])new Object[]{fieldName, javaType.getName()}));
            }
            for (superClass = javaType; !(superClass == null || superClass.getName().equals(ClassNameConstants.Object) || mcd != null && mcd.mappingClass != null); superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && (mcd == null || mcd.mappingClass == null); ++i) {
                    mcd = this.getDefaultJavaTypeMapping(interfaces[i], colmds);
                }
            }
            if (mcd == null) {
                return new MappingConverterDetails(SerialisedMapping.class);
            }
        }
        return mcd;
    }

    protected JavaTypeMapping getElementMapping(Table table, AbstractMemberMetaData mmd, FieldRole fieldRole, ClassLoaderResolver clr) {
        if (!mmd.hasCollection() && !mmd.hasArray()) {
            throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no collection/array!").setFatal();
        }
        if (mmd.getJoinMetaData() == null) {
            AbstractMemberMetaData[] refMmds = mmd.getRelatedMemberMetaData(clr);
            if (refMmds == null || refMmds.length == 0) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
            if (refMmds[0].getJoinMetaData() == null) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userMappingClassName = null;
        if (mmd.getElementMetaData() != null) {
            userMappingClassName = mmd.getElementMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasCollection() && mmd.getCollection().isSerializedElement() || mmd.hasArray() && mmd.getArray().isSerializedElement();
            boolean embeddedPC = mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null;
            boolean elementPC = mmd.hasCollection() && mmd.getCollection().elementIsPersistent() || mmd.hasArray() && mmd.getArray().elementIsPersistent();
            boolean embedded = true;
            if (mmd.hasCollection()) {
                embedded = mmd.getCollection().isEmbeddedElement();
            } else if (mmd.hasArray()) {
                embedded = mmd.getArray().isEmbeddedElement();
            }
            Class<?> elementCls = null;
            if (mmd.hasCollection()) {
                elementCls = clr.classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasArray()) {
                elementCls = mmd.getType().getComponentType();
            }
            boolean elementReference = ClassUtils.isReferenceType(elementCls);
            if (serialised) {
                mc = elementPC ? SerialisedElementPCMapping.class : (elementReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedElementPCMapping.class;
                } else if (elementPC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(elementCls, serialised, embedded, mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(elementCls, serialised, embedded, mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            JavaTypeMapping m = null;
            try {
                m = (JavaTypeMapping)mc.newInstance();
                m.setRoleForMember(fieldRole);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                JavaTypeMapping m = (JavaTypeMapping)mcd.mappingClass.newInstance();
                m.setRoleForMember(fieldRole);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for element of collection/array at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected JavaTypeMapping getKeyMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get key mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userMappingClassName = null;
        if (mmd.getKeyMetaData() != null) {
            userMappingClassName = mmd.getKeyMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedKey();
            boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedKey();
            boolean embeddedPC = mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null;
            boolean keyPC = mmd.hasMap() && mmd.getMap().keyIsPersistent();
            Class keyCls = clr.classForName(mmd.getMap().getKeyType());
            boolean keyReference = ClassUtils.isReferenceType((Class)keyCls);
            if (serialised) {
                mc = keyPC ? SerialisedKeyPCMapping.class : (keyReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedKeyPCMapping.class;
                } else if (keyPC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(keyCls, serialised, embedded, mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(keyCls, serialised, embedded, mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            JavaTypeMapping m = null;
            try {
                m = (JavaTypeMapping)mc.newInstance();
                m.setRoleForMember(FieldRole.ROLE_MAP_KEY);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                JavaTypeMapping m = (JavaTypeMapping)mcd.mappingClass.newInstance();
                m.setRoleForMember(FieldRole.ROLE_MAP_KEY);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for key of map at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected JavaTypeMapping getValueMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get value mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        MappingConverterDetails mcd = null;
        Class mc = null;
        String userMappingClassName = null;
        if (mmd.getValueMetaData() != null) {
            userMappingClassName = mmd.getValueMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                mc = clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(Localiser.msg((String)"041014", (Object[])new Object[]{userMappingClassName})).setFatal();
            }
        } else {
            boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedValue();
            boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedValue();
            boolean embeddedPC = mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null;
            boolean valuePC = mmd.hasMap() && mmd.getMap().valueIsPersistent();
            Class valueCls = clr.classForName(mmd.getMap().getValueType());
            boolean valueReference = ClassUtils.isReferenceType((Class)valueCls);
            if (serialised) {
                mc = valuePC ? SerialisedValuePCMapping.class : (valueReference ? SerialisedReferenceMapping.class : SerialisedMapping.class);
            } else if (embedded) {
                if (embeddedPC) {
                    mc = EmbeddedValuePCMapping.class;
                } else if (valuePC) {
                    mc = PersistableMapping.class;
                } else {
                    mcd = this.getMappingClass(valueCls, serialised, embedded, mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
                }
            } else {
                mcd = this.getMappingClass(valueCls, serialised, embedded, mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null, mmd.getFullFieldName());
            }
        }
        if (mcd != null && mcd.typeConverter == null) {
            mc = mcd.mappingClass;
        }
        if (mc != null && (mcd == null || mcd.typeConverter == null)) {
            JavaTypeMapping m = null;
            try {
                m = (JavaTypeMapping)mc.newInstance();
                m.setRoleForMember(FieldRole.ROLE_MAP_VALUE);
                m.initialize(mmd, table, clr);
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        if (mcd != null && mcd.typeConverter != null) {
            try {
                JavaTypeMapping m = (JavaTypeMapping)mcd.mappingClass.newInstance();
                m.setRoleForMember(FieldRole.ROLE_MAP_VALUE);
                if (m instanceof TypeConverterMapping) {
                    ((TypeConverterMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                } else if (m instanceof TypeConverterMultiMapping) {
                    ((TypeConverterMultiMapping)m).initialize(mmd, table, clr, mcd.typeConverter);
                }
                return m;
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mc.getName(), e}), (Throwable)e).setFatal();
            }
        }
        throw new NucleusException("Unable to create mapping for value of map at " + mmd.getFullFieldName() + " - no available mapping");
    }

    protected MappingConverterDetails getDefaultJavaTypeMapping(Class javaType, ColumnMetaData[] colmds) {
        Class cls = this.storeMgr.getMappedTypeManager().getMappingType(javaType.getName());
        if (cls == null) {
            TypeConverter conv;
            TypeManager typeMgr = this.storeMgr.getNucleusContext().getTypeManager();
            if (colmds != null && colmds.length > 0) {
                if (colmds.length > 1) {
                    Collection converters = typeMgr.getTypeConvertersForType(javaType);
                    if (converters != null && !converters.isEmpty()) {
                        for (TypeConverter conv2 : converters) {
                            if (!(conv2 instanceof MultiColumnConverter) || ((MultiColumnConverter)conv2).getDatastoreColumnTypes().length != colmds.length) continue;
                            return new MappingConverterDetails(TypeConverterMultiMapping.class, conv2);
                        }
                    }
                } else {
                    JdbcType jdbcType = colmds[0].getJdbcType();
                    if (jdbcType != null) {
                        TypeConverter conv3 = null;
                        if (MetaDataUtils.isJdbcTypeString((JdbcType)jdbcType)) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, String.class);
                        } else if (MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType)) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Long.class);
                        } else if (jdbcType == JdbcType.TIMESTAMP) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Timestamp.class);
                        } else if (jdbcType == JdbcType.TIME) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Time.class);
                        } else if (jdbcType == JdbcType.DATE) {
                            conv3 = typeMgr.getTypeConverterForType(javaType, Date.class);
                        }
                        if (conv3 != null) {
                            return new MappingConverterDetails(TypeConverterMapping.class, conv3);
                        }
                    }
                }
            }
            if ((conv = typeMgr.getDefaultTypeConverterForType(javaType)) != null) {
                if (conv instanceof MultiColumnConverter) {
                    return new MappingConverterDetails(TypeConverterMultiMapping.class, conv);
                }
                return new MappingConverterDetails(TypeConverterMapping.class, conv);
            }
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"041000", (Object[])new Object[]{javaType.getName()}), (Throwable)new Exception());
            return null;
        }
        return new MappingConverterDetails(cls);
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
        boolean mappingRequired = true;
        Collection coll = (Collection)this.datastoreMappingsByJavaType.get((Object)javaTypeName);
        if (coll != null && coll.size() > 0) {
            for (RDBMSTypeMapping typeMapping : coll) {
                if (typeMapping.jdbcType.equals(jdbcType) && typeMapping.sqlType.equals(sqlType)) {
                    mappingRequired = false;
                    if (typeMapping.isDefault() == dflt) continue;
                    typeMapping.setDefault(dflt);
                    continue;
                }
                if (!dflt) continue;
                typeMapping.setDefault(false);
            }
        }
        if (mappingRequired) {
            RDBMSTypeMapping mapping = new RDBMSTypeMapping(datastoreMappingType, dflt, javaTypeName, jdbcType, sqlType);
            this.datastoreMappingsByJDBCType.put((Object)jdbcType, (Object)mapping);
            this.datastoreMappingsBySQLType.put((Object)sqlType, (Object)mapping);
            this.datastoreMappingsByJavaType.put((Object)javaTypeName, (Object)mapping);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"054009", (Object[])new Object[]{javaTypeName, jdbcType, sqlType, datastoreMappingType.getName(), "" + dflt}));
            }
        }
    }

    public void deregisterDatastoreMappingsForJDBCType(String jdbcTypeName) {
        Collection coll = (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcTypeName);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet mappings = new HashSet(coll);
        for (RDBMSTypeMapping mapping : mappings) {
            this.datastoreMappingsByJavaType.removeKeyValue((Object)mapping.javaType, (Object)mapping);
            this.datastoreMappingsBySQLType.removeKeyValue((Object)mapping.sqlType, (Object)mapping);
            this.datastoreMappingsByJDBCType.removeKeyValue((Object)mapping.jdbcType, (Object)mapping);
            if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"054010", (Object[])new Object[]{mapping.javaType, mapping.jdbcType, mapping.sqlType}));
        }
    }

    protected Class getDatastoreMappingClass(String fieldName, String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr) {
        if (javaType == null) {
            return null;
        }
        javaType = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
        RDBMSTypeMapping datastoreMapping = null;
        if (sqlType != null) {
            if (this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase()) == null) {
                if (jdbcType == null) {
                    if (fieldName != null) {
                        throw new NucleusException(Localiser.msg((String)"054001", (Object[])new Object[]{javaType, sqlType, fieldName})).setFatal();
                    }
                    throw new NucleusException(Localiser.msg((String)"054000", (Object[])new Object[]{javaType, sqlType})).setFatal();
                }
                if (fieldName != null) {
                    NucleusLogger.DATASTORE_SCHEMA.info((Object)Localiser.msg((String)"054012", (Object[])new Object[]{javaType, sqlType, fieldName, jdbcType}));
                } else {
                    NucleusLogger.DATASTORE_SCHEMA.info((Object)Localiser.msg((String)"054011", (Object[])new Object[]{javaType, sqlType, jdbcType}));
                }
            } else {
                for (RDBMSTypeMapping sqlTypeMapping : (Collection)this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase())) {
                    if (!sqlTypeMapping.javaType.equals(javaType)) continue;
                    datastoreMapping = sqlTypeMapping;
                    break;
                }
            }
        }
        if (datastoreMapping == null && jdbcType != null) {
            if (this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new NucleusException(Localiser.msg((String)"054003", (Object[])new Object[]{javaType, jdbcType, fieldName})).setFatal();
                }
                throw new NucleusException(Localiser.msg((String)"054002", (Object[])new Object[]{javaType, jdbcType})).setFatal();
            }
            for (RDBMSTypeMapping jdbcTypeMapping : (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase())) {
                if (!jdbcTypeMapping.javaType.equals(javaType)) continue;
                datastoreMapping = jdbcTypeMapping;
                break;
            }
            if (datastoreMapping == null) {
                if (fieldName != null) {
                    throw new NucleusException(Localiser.msg((String)"054003", (Object[])new Object[]{javaType, jdbcType, fieldName})).setFatal();
                }
                throw new NucleusException(Localiser.msg((String)"054002", (Object[])new Object[]{javaType, jdbcType})).setFatal();
            }
        }
        if (datastoreMapping == null) {
            String type = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
            Collection mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)type);
            if (mappings == null) {
                Class javaTypeClass = clr.classForName(type);
                for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappings == null; superClass = superClass.getSuperclass()) {
                    mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)superClass.getName());
                }
            }
            if (mappings != null) {
                if (mappings.size() == 1) {
                    datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                } else {
                    for (RDBMSTypeMapping rdbmsMapping : mappings) {
                        if (!rdbmsMapping.isDefault()) continue;
                        datastoreMapping = rdbmsMapping;
                        break;
                    }
                    if (datastoreMapping == null && mappings.size() > 0) {
                        datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                    }
                }
            }
        }
        if (datastoreMapping == null) {
            if (fieldName != null) {
                throw new NucleusException(Localiser.msg((String)"054005", (Object[])new Object[]{javaType, jdbcType, sqlType, fieldName})).setFatal();
            }
            throw new NucleusException(Localiser.msg((String)"054004", (Object[])new Object[]{javaType, jdbcType, sqlType})).setFatal();
        }
        return datastoreMapping.getMappingType();
    }

    @Override
    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, AbstractMemberMetaData mmd, int index, Column column) {
        Class datastoreMappingClass = null;
        if (mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[index].hasExtension("datastore-mapping-class")) {
            datastoreMappingClass = this.clr.classForName(mmd.getColumnMetaData()[index].getValueForExtension("datastore-mapping-class"));
        }
        if (datastoreMappingClass == null) {
            String javaType = mapping.getJavaTypeForDatastoreMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (mapping.getRoleForMember() == FieldRole.ROLE_ARRAY_ELEMENT || mapping.getRoleForMember() == FieldRole.ROLE_COLLECTION_ELEMENT) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getCollection() != null && mmd.getCollection().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
                if (mmd.getArray() != null && mmd.getArray().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == FieldRole.ROLE_MAP_KEY) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedKey()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == FieldRole.ROLE_MAP_VALUE) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcTypeName();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedValue()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else {
                if (mmd.getColumnMetaData().length > 0) {
                    jdbcType = mmd.getColumnMetaData()[index].getJdbcTypeName();
                    sqlType = mmd.getColumnMetaData()[index].getSqlType();
                }
                if (mmd.isSerialized()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            }
            datastoreMappingClass = this.getDatastoreMappingClass(mmd.getFullFieldName(), javaType, jdbcType, sqlType, this.clr);
        }
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    @Override
    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, Column column, String javaType) {
        Column col = column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcTypeName();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class datastoreMappingClass = this.getDatastoreMappingClass(null, javaType, jdbcType, sqlType, this.clr);
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData[] colmds;
        AbstractMemberMetaData mmd = mapping.getMemberMetaData();
        FieldRole roleForField = mapping.getRoleForMember();
        Table tbl = mapping.getTable();
        ColumnMetaData colmd = null;
        AbstractMemberMetaData columnContainer = mmd;
        if (roleForField == FieldRole.ROLE_COLLECTION_ELEMENT || roleForField == FieldRole.ROLE_ARRAY_ELEMENT) {
            columnContainer = mmd.getElementMetaData();
        } else if (roleForField == FieldRole.ROLE_MAP_KEY) {
            columnContainer = mmd.getKeyMetaData();
        } else if (roleForField == FieldRole.ROLE_MAP_VALUE) {
            columnContainer = mmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = columnContainer.getColumnMetaData()[datastoreFieldIndex];
            colmds = columnContainer.getColumnMetaData();
        } else {
            colmd = new ColumnMetaData();
            if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > datastoreFieldIndex) {
                colmd.setName(mmd.getColumnMetaData()[datastoreFieldIndex].getName());
            }
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
                colmds = columnContainer.getColumnMetaData();
            } else {
                colmds = new ColumnMetaData[]{colmd};
            }
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            if (roleForField == FieldRole.ROLE_COLLECTION_ELEMENT) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_COLLECTION_ELEMENT);
            } else if (roleForField == FieldRole.ROLE_ARRAY_ELEMENT) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_ARRAY_ELEMENT);
            } else if (roleForField == FieldRole.ROLE_MAP_KEY) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_MAP_KEY);
            } else if (roleForField == FieldRole.ROLE_MAP_VALUE) {
                identifier = idFactory.newJoinTableFieldIdentifier(mmd, null, null, true, FieldRole.ROLE_MAP_VALUE);
            } else {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName());
                int i = 0;
                while (tbl.hasColumn(identifier)) {
                    identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName() + "_" + i);
                    ++i;
                }
            }
            colmd.setName(identifier.getName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmds[datastoreFieldIndex].getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), null, true);
        }
        Column col = tbl.addColumn(javaType, identifier, mapping, colmd);
        if (mmd.isPrimaryKey()) {
            col.setPrimaryKey();
        }
        if (mmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isStrategyDatastoreAttributed(mmd.getAbstractClassMetaData(), mmd.getAbsoluteFieldNumber()) && tbl instanceof DatastoreClass && (mmd.isPrimaryKey() && ((DatastoreClass)tbl).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        Column col;
        AbstractMemberMetaData mmd = mapping.getMemberMetaData();
        Table tbl = mapping.getTable();
        if (colmd == null) {
            colmd = new ColumnMetaData();
            if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length == 1) {
                colmd.setName(mmd.getColumnMetaData()[0].getName());
            }
            mmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName());
            int i = 0;
            while (tbl.hasColumn(identifier)) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, mmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getName());
            col = tbl.addColumn(javaType, identifier, mapping, colmd);
        } else {
            col = tbl.addColumn(javaType, idFactory.newColumnIdentifier(colmd.getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), null, true), mapping, colmd);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    @Override
    public Column createColumn(AbstractMemberMetaData mmd, Table table, JavaTypeMapping mapping, ColumnMetaData colmd, Column reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
            identifier = idFactory.newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, mmd, reference.getIdentifier(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), FieldRole.ROLE_OWNER);
            colmd.setName(identifier.getName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmd.getName(), false, null, true);
        }
        Column col = table.addColumn(mmd.getType().getName(), identifier, mapping, colmd);
        reference.copyConfigurationTo(col);
        if (mmd.isPrimaryKey()) {
            col.setPrimaryKey();
        }
        if (mmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isStrategyDatastoreAttributed(mmd.getAbstractClassMetaData(), mmd.getAbsoluteFieldNumber()) && (mmd.isPrimaryKey() && ((DatastoreClass)table).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable(colmd.getDefaultValue());
        }
        return col;
    }

    private void setColumnNullability(AbstractMemberMetaData mmd, ColumnMetaData colmd, Column col) {
        if (colmd != null && colmd.getAllowsNull() == null) {
            if (mmd.isPrimaryKey()) {
                colmd.setAllowsNull(Boolean.valueOf(false));
            } else if (!mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(Boolean.valueOf(true));
            } else {
                colmd.setAllowsNull(Boolean.valueOf(false));
            }
            if (colmd.isAllowsNull()) {
                col.setNullable(true);
            }
        } else if (colmd != null && colmd.getAllowsNull() != null) {
            if (colmd.isAllowsNull()) {
                col.setNullable(true);
            }
        } else if (!mmd.isPrimaryKey() && !mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
            col.setNullable(true);
        }
    }

    protected class RDBMSTypeMapping {
        private String javaType;
        private String jdbcType;
        private String sqlType;
        private Class javaMappingType;
        private boolean isDefault;

        public RDBMSTypeMapping(Class mappingType, boolean isDefault, String javaType, String jdbcType, String sqlType) {
            this.javaMappingType = mappingType;
            this.isDefault = isDefault;
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Class getMappingType() {
            return this.javaMappingType;
        }

        public void setMappingType(Class type) {
            this.javaMappingType = type;
        }
    }

    public class MappingConverterDetails {
        Class mappingClass;
        TypeConverter typeConverter;

        public MappingConverterDetails(Class mappingCls) {
            this.mappingClass = mappingCls;
        }

        public MappingConverterDetails(Class mappingCls, TypeConverter typeConv) {
            this.mappingClass = mappingCls;
            this.typeConverter = typeConv;
        }
    }
}

