/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.DiscriminatorMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementParameter;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.DatastoreElementContainer;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.PersistableJoinTable;
import org.datanucleus.store.rdbms.table.SecondaryDatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class SQLStatementHelper {
    private SQLStatementHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreparedStatement getPreparedStatementForSQLStatement(SQLStatement sqlStmt, ExecutionContext ec, ManagedConnection mconn, String resultSetType, String resultSetConcurrency) throws SQLException {
        SQLText sqlText = sqlStmt.getSQLText();
        SQLController sqlControl = sqlStmt.getRDBMSManager().getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sqlText.toString(), resultSetType, resultSetConcurrency);
        boolean done = false;
        try {
            sqlText.applyParametersToStatement(ec, ps);
            done = true;
        }
        finally {
            if (!done) {
                sqlControl.closeStatement(mconn, ps);
            }
        }
        return ps;
    }

    public static void applyParametersToStatement(PreparedStatement ps, ExecutionContext ec, List<SQLStatementParameter> parameters, Map<Integer, String> paramNameByPosition, Map paramValuesByName) {
        if (parameters != null) {
            int num = 1;
            HashMap<String, Integer> paramNumberByName = null;
            int nextParamNumber = 0;
            for (SQLStatementParameter param : parameters) {
                JavaTypeMapping mapping = param.getMapping();
                RDBMSStoreManager storeMgr = mapping.getStoreManager();
                Object value = null;
                if (paramNumberByName != null) {
                    Integer position = (Integer)paramNumberByName.get("" + param.getName());
                    if (position == null) {
                        value = paramValuesByName.get(nextParamNumber);
                        paramNumberByName.put(param.getName(), nextParamNumber);
                        ++nextParamNumber;
                    } else {
                        value = paramValuesByName.get(position);
                    }
                } else if (paramValuesByName.containsKey(param.getName())) {
                    value = paramValuesByName.get(param.getName());
                } else if (paramNameByPosition != null) {
                    int paramPosition = -1;
                    HashSet<String> paramNamesEncountered = new HashSet<String>();
                    for (Map.Entry<Integer, String> entry : paramNameByPosition.entrySet()) {
                        String paramName = entry.getValue();
                        if (!paramNamesEncountered.contains(paramName)) {
                            ++paramPosition;
                            paramNamesEncountered.add(paramName);
                        }
                        if (!paramName.equals(param.getName())) continue;
                        value = paramValuesByName.get(paramPosition);
                        break;
                    }
                    paramNamesEncountered.clear();
                    paramNamesEncountered = null;
                } else {
                    try {
                        value = paramValuesByName.get(Integer.valueOf(param.getName()));
                    }
                    catch (NumberFormatException nfe) {
                        value = paramValuesByName.get(nextParamNumber);
                        paramNumberByName = new HashMap<String, Integer>();
                        paramNumberByName.put(param.getName(), nextParamNumber);
                        ++nextParamNumber;
                    }
                }
                AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(mapping.getType(), ec.getClassLoaderResolver());
                if (param.getColumnNumber() >= 0 && cmd != null) {
                    Object colValue = null;
                    if (value != null) {
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            colValue = mapping.getValueForDatastoreMapping((NucleusContext)ec.getNucleusContext(), param.getColumnNumber(), value);
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            colValue = SQLStatementHelper.getValueForPrimaryKeyIndexOfObjectUsingReflection(value, param.getColumnNumber(), cmd, storeMgr, ec.getClassLoaderResolver());
                        }
                    }
                    mapping.getDatastoreMapping(param.getColumnNumber()).setObject(ps, num, colValue);
                } else if (ec.getApiAdapter().isPersistable(value)) {
                    if (!ec.getApiAdapter().isPersistent(value) && !ec.getApiAdapter().isDetached(value)) {
                        boolean supported = false;
                        if (!supported) {
                            NucleusLogger.QUERY.warn((Object)"Attempt to use transient object as parameter in query. Not supported, so using NULL for parameter value");
                            mapping.setObject(ec, ps, MappingHelper.getMappingIndices(num, mapping), null);
                        }
                    } else if (ec.getApiAdapter().isDetached(value)) {
                        Object id = ec.getApiAdapter().getIdForObject(value);
                        PersistableIdMapping idMapping = new PersistableIdMapping((PersistableMapping)mapping);
                        idMapping.setObject(ec, ps, MappingHelper.getMappingIndices(num, idMapping), id);
                    } else {
                        mapping.setObject(ec, ps, MappingHelper.getMappingIndices(num, mapping), value);
                    }
                } else if (mapping.getNumberOfDatastoreMappings() == 1) {
                    mapping.setObject(ec, ps, MappingHelper.getMappingIndices(num, mapping), value);
                } else if (mapping.getNumberOfDatastoreMappings() > 1 && param.getColumnNumber() == mapping.getNumberOfDatastoreMappings() - 1) {
                    mapping.setObject(ec, ps, MappingHelper.getMappingIndices(num - mapping.getNumberOfDatastoreMappings() + 1, mapping), value);
                }
                ++num;
            }
        }
    }

    public static Object getValueForPrimaryKeyIndexOfObjectUsingReflection(Object value, int index, AbstractClassMetaData cmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException("This method does not support datastore-identity");
        }
        int position = 0;
        int[] pkPositions = cmd.getPKMemberPositions();
        for (int i = 0; i < pkPositions.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
            Object memberValue = null;
            memberValue = mmd instanceof FieldMetaData ? ClassUtils.getValueOfFieldByReflection((Object)value, (String)mmd.getName()) : ClassUtils.getValueOfMethodByReflection((Object)value, (String)ClassUtils.getJavaBeanGetterName((String)mmd.getName(), (boolean)false), (Object[])new Object[0]);
            if (storeMgr.getApiAdapter().isPersistable(mmd.getType())) {
                AbstractClassMetaData subCmd = storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                DatastoreClass subTable = storeMgr.getDatastoreClass(mmd.getTypeName(), clr);
                JavaTypeMapping subMapping = subTable.getIdMapping();
                Object subValue = SQLStatementHelper.getValueForPrimaryKeyIndexOfObjectUsingReflection(memberValue, index - position, subCmd, storeMgr, clr);
                if (index < position + subMapping.getNumberOfDatastoreMappings()) {
                    return subValue;
                }
                position += subMapping.getNumberOfDatastoreMappings();
                continue;
            }
            if (position == index) {
                if (mmd instanceof FieldMetaData) {
                    return ClassUtils.getValueOfFieldByReflection((Object)value, (String)mmd.getName());
                }
                return ClassUtils.getValueOfMethodByReflection((Object)value, (String)ClassUtils.getJavaBeanGetterName((String)mmd.getName(), (boolean)false), (Object[])new Object[0]);
            }
            ++position;
        }
        return null;
    }

    public static SQLTable getSQLTableForMappingOfTable(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        Table table = sqlTbl.getTable();
        if (table instanceof SecondaryDatastoreClass || table instanceof JoinTable) {
            SQLTable mappingSqlTbl;
            if (mapping.getTable() != null && (mappingSqlTbl = stmt.getTable(mapping.getTable(), sqlTbl.getGroupName())) != null) {
                return mappingSqlTbl;
            }
            return sqlTbl;
        }
        DatastoreClass sourceTbl = (DatastoreClass)sqlTbl.getTable();
        DatastoreClass mappingTbl = null;
        mappingTbl = mapping.getTable() != null ? (DatastoreClass)mapping.getTable() : sourceTbl.getBaseDatastoreClassWithMember(mapping.getMemberMetaData());
        if (mappingTbl == sourceTbl) {
            return sqlTbl;
        }
        SQLTable mappingSqlTbl = stmt.getTable(mappingTbl, sqlTbl.getGroupName());
        if (mappingSqlTbl == null) {
            boolean forceLeftOuter = false;
            SQLTableGroup tableGrp = stmt.getTableGroup(sqlTbl.getGroupName());
            if (tableGrp.getJoinType() == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                forceLeftOuter = true;
            }
            if (mappingTbl instanceof SecondaryDatastoreClass) {
                boolean innerJoin = true;
                JoinMetaData joinmd = ((SecondaryDatastoreClass)mappingTbl).getJoinMetaData();
                if (joinmd != null && joinmd.isOuter() && !forceLeftOuter) {
                    innerJoin = false;
                }
                mappingSqlTbl = innerJoin && !forceLeftOuter ? stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), mappingTbl, null, mappingTbl.getIdMapping(), null, sqlTbl.getGroupName()) : stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), mappingTbl, null, mappingTbl.getIdMapping(), null, sqlTbl.getGroupName());
            } else {
                mappingSqlTbl = forceLeftOuter ? stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), mappingTbl, null, mappingTbl.getIdMapping(), null, sqlTbl.getGroupName()) : stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), mappingTbl, null, mappingTbl.getIdMapping(), null, sqlTbl.getGroupName());
            }
        }
        return mappingSqlTbl;
    }

    public static void selectIdentityOfCandidateInStatement(SelectStatement stmt, StatementClassMapping mappingDefinition, AbstractClassMetaData candidateCmd) {
        List<SelectStatement> unionStmts;
        JavaTypeMapping discrimMapping;
        DatastoreClass candidateTbl = (DatastoreClass)stmt.getPrimaryTable().getTable();
        if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping idMapping = candidateTbl.getDatastoreIdMapping();
            int[] colNumbers = stmt.select(stmt.getPrimaryTable(), idMapping, "DN_DATASTOREID", false);
            if (mappingDefinition != null) {
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(idMapping);
                datastoreIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-1, datastoreIdIdx);
            }
        } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = candidateCmd.getPKMemberPositions();
            String alias = "DN_APPID";
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                JavaTypeMapping pkMapping = candidateTbl.getMemberMapping(pkMmd);
                SQLTable sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, stmt.getPrimaryTable(), pkMapping);
                if (pkPositions.length > 1) {
                    alias = "DN_APPID" + i;
                }
                int[] colNumbers = stmt.select(sqlTbl, pkMapping, alias, false);
                if (mappingDefinition == null) continue;
                StatementMappingIndex appIdIdx = new StatementMappingIndex(pkMapping);
                appIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(pkPositions[i], appIdIdx);
            }
        }
        JavaTypeMapping verMapping = candidateTbl.getVersionMapping(true);
        if (verMapping != null) {
            SQLTable versionSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, stmt.getPrimaryTable(), verMapping);
            int[] colNumbers = stmt.select(versionSqlTbl, verMapping, "DN_VERSION", false);
            if (mappingDefinition != null) {
                StatementMappingIndex versionIdx = new StatementMappingIndex(verMapping);
                versionIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-2, versionIdx);
            }
        }
        if ((discrimMapping = candidateTbl.getDiscriminatorMapping(true)) != null) {
            SQLTable discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, stmt.getPrimaryTable(), discrimMapping);
            int[] colNumbers = stmt.select(discrimSqlTbl, discrimMapping, "DN_DISCRIM", false);
            if (mappingDefinition != null) {
                StatementMappingIndex discrimIdx = new StatementMappingIndex(discrimMapping);
                discrimIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-3, discrimIdx);
            }
        }
        if ((unionStmts = stmt.getUnions()) != null) {
            for (SelectStatement unionStmt : unionStmts) {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(unionStmt, null, candidateCmd);
            }
        }
    }

    public static void selectFetchPlanOfCandidateInStatement(SelectStatement stmt, StatementClassMapping mappingDefinition, AbstractClassMetaData candidateCmd, FetchPlan fetchPlan, int maxFetchDepth) {
        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, mappingDefinition, fetchPlan, stmt.getPrimaryTable(), candidateCmd, maxFetchDepth);
    }

    public static void selectFetchPlanOfSourceClassInStatement(SelectStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractClassMetaData sourceCmd, int maxFetchDepth) {
        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, mappingDefinition, fetchPlan, sourceSqlTbl, sourceCmd, maxFetchDepth, null);
    }

    public static void selectFetchPlanOfSourceClassInStatement(SelectStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractClassMetaData sourceCmd, int maxFetchDepth, SQLJoin.JoinType inputJoinType) {
        JavaTypeMapping discrimMapping;
        JavaTypeMapping verMapping;
        DatastoreClass sourceTbl = (DatastoreClass)sourceSqlTbl.getTable();
        int[] fieldNumbers = fetchPlan != null ? fetchPlan.getFetchPlanForClass(sourceCmd).getMemberNumbers() : sourceCmd.getDFGMemberPositions();
        ClassLoaderResolver clr = stmt.getRDBMSManager().getNucleusContext().getClassLoaderResolver(null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = sourceCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            SQLStatementHelper.selectMemberOfSourceInStatement(stmt, mappingDefinition, fetchPlan, sourceSqlTbl, mmd, clr, maxFetchDepth, inputJoinType);
        }
        if (sourceCmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping idMapping = sourceTbl.getDatastoreIdMapping();
            int[] colNumbers = stmt.select(sourceSqlTbl, idMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(idMapping);
                datastoreIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-1, datastoreIdIdx);
            }
        }
        if ((verMapping = sourceTbl.getVersionMapping(true)) != null) {
            SQLTable versionSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, verMapping);
            int[] colNumbers = stmt.select(versionSqlTbl, verMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex versionIdx = new StatementMappingIndex(verMapping);
                versionIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-2, versionIdx);
            }
        }
        if ((discrimMapping = sourceTbl.getDiscriminatorMapping(true)) != null) {
            SQLTable discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, discrimMapping);
            int[] colNumbers = stmt.select(discrimSqlTbl, discrimMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex discrimIdx = new StatementMappingIndex(discrimMapping);
                discrimIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(-3, discrimIdx);
            }
        }
    }

    public static void selectMemberOfSourceInStatement(SelectStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractMemberMetaData mmd, ClassLoaderResolver clr, int maxFetchPlanLimit, SQLJoin.JoinType inputJoinType) {
        boolean selectSubobjects = false;
        if (maxFetchPlanLimit > 0) {
            selectSubobjects = true;
        }
        String tableGroupName = sourceSqlTbl.getGroupName() + "." + mmd.getName();
        JavaTypeMapping m = sourceSqlTbl.getTable().getMemberMapping(mmd);
        if (m != null && m.includeInFetchStatement()) {
            RelationType relationType = mmd.getRelationType(clr);
            RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
            DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
            if (!dba.validToSelectMappingInStatement(stmt, m)) {
                return;
            }
            MetaDataManager mmgr = storeMgr.getMetaDataManager();
            StatementMappingIndex stmtMapping = new StatementMappingIndex(m);
            if (m.getNumberOfDatastoreMappings() > 0) {
                SQLTable sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, m);
                boolean selectFK = true;
                if (selectSubobjects && (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI && mmd.getMappedBy() == null) && !mmd.isSerialized() && !mmd.isEmbedded()) {
                    selectFK = SQLStatementHelper.selectFetchPlanFieldsOfFKRelatedObject(stmt, mappingDefinition, fetchPlan, sourceSqlTbl, mmd, clr, maxFetchPlanLimit, m, tableGroupName, stmtMapping, sqlTbl, inputJoinType);
                } else if (selectSubobjects && !mmd.isEmbedded() && !mmd.isSerialized() && relationType == RelationType.MANY_TO_ONE_BI) {
                    AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
                    if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                        Table joinTable = storeMgr.getTable(relatedMmds[0]);
                        DatastoreElementContainer collTable = (DatastoreElementContainer)joinTable;
                        JavaTypeMapping selectMapping = collTable.getOwnerMapping();
                        SQLTable joinSqlTbl = null;
                        if (stmt.getPrimaryTable().getTable() != joinTable) {
                            JavaTypeMapping referenceMapping = collTable.getElementMapping();
                            joinSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIdMapping(), collTable, null, referenceMapping, null, tableGroupName);
                        } else {
                            joinSqlTbl = stmt.getPrimaryTable();
                        }
                        int[] colNumbers = stmt.select(joinSqlTbl, selectMapping, null);
                        stmtMapping.setColumnPositions(colNumbers);
                    } else {
                        selectFK = SQLStatementHelper.selectFetchPlanFieldsOfFKRelatedObject(stmt, mappingDefinition, fetchPlan, sourceSqlTbl, mmd, clr, maxFetchPlanLimit, m, tableGroupName, stmtMapping, sqlTbl, inputJoinType);
                    }
                }
                if (selectFK) {
                    int[] colNumbers = stmt.select(sqlTbl, m, null);
                    stmtMapping.setColumnPositions(colNumbers);
                }
            } else if (relationType == RelationType.ONE_TO_ONE_BI && mmd.getMappedBy() != null) {
                int[] colNumbers;
                AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
                AbstractMemberMetaData relatedMmd = relatedMmds[0];
                String[] clsNames = null;
                if (mmd.getType().isInterface()) {
                    if (mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1) {
                        Class fldTypeCls = clr.classForName(mmd.getFieldTypes()[0]);
                        clsNames = fldTypeCls.isInterface() ? mmgr.getClassesImplementingInterface(mmd.getFieldTypes()[0], clr) : new String[]{mmd.getFieldTypes()[0]};
                    }
                    if (clsNames == null) {
                        clsNames = mmgr.getClassesImplementingInterface(mmd.getTypeName(), clr);
                    }
                } else {
                    String typeName = mmd.isSingleCollection() ? mmd.getCollection().getElementType() : mmd.getTypeName();
                    clsNames = new String[]{typeName};
                }
                DatastoreClass relatedTbl = storeMgr.getDatastoreClass((String)clsNames[0], clr);
                JavaTypeMapping relatedMapping = relatedTbl.getMemberMapping(relatedMmd);
                JavaTypeMapping relatedDiscrimMapping = relatedTbl.getDiscriminatorMapping(true);
                Object[] discrimValues = null;
                JavaTypeMapping relatedTypeMapping = null;
                AbstractClassMetaData relatedCmd = relatedMmd.getAbstractClassMetaData();
                if (!(relatedDiscrimMapping == null || relatedCmd.getSuperAbstractClassMetaData() == null && relatedCmd.getFullClassName().equals(mmd.getTypeName()))) {
                    List discValueList = null;
                    for (int i = 0; i < clsNames.length; ++i) {
                        List values = SQLStatementHelper.getDiscriminatorValuesForMember(clsNames[i], relatedDiscrimMapping, storeMgr, clr);
                        if (discValueList == null) {
                            discValueList = values;
                            continue;
                        }
                        discValueList.addAll(values);
                    }
                    if (discValueList != null) {
                        discrimValues = discValueList.toArray(new Object[discValueList.size()]);
                    }
                } else if (relatedTbl != relatedMapping.getTable()) {
                    relatedTypeMapping = relatedTbl.getIdMapping();
                }
                SQLTable relatedSqlTbl = null;
                if (relatedTypeMapping == null) {
                    SQLJoin.JoinType joinType = SQLStatementHelper.getJoinTypeForOneToOneRelationJoin(sourceSqlTbl.getTable().getIdMapping(), sourceSqlTbl, inputJoinType);
                    if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || joinType == SQLJoin.JoinType.RIGHT_OUTER_JOIN) {
                        inputJoinType = joinType;
                    }
                    relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, sourceSqlTbl.getTable().getIdMapping(), sourceSqlTbl, relatedMapping, relatedTbl, null, discrimValues, tableGroupName, joinType);
                    colNumbers = stmt.select(relatedSqlTbl, relatedTbl.getIdMapping(), null);
                    stmtMapping.setColumnPositions(colNumbers);
                } else {
                    DatastoreClass relationTbl = (DatastoreClass)relatedMapping.getTable();
                    if (relatedTbl != relatedMapping.getTable()) {
                        if (relatedMapping.isNullable()) {
                            relatedSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIdMapping(), relatedMapping.getTable(), null, relatedMapping, null, tableGroupName);
                            relatedSqlTbl = stmt.innerJoin(relatedSqlTbl, relatedMapping.getTable().getIdMapping(), relatedTbl, null, relatedTbl.getIdMapping(), null, tableGroupName);
                        } else {
                            relatedSqlTbl = stmt.innerJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIdMapping(), relatedMapping.getTable(), null, relatedMapping, null, tableGroupName);
                            relatedSqlTbl = stmt.innerJoin(relatedSqlTbl, relatedMapping.getTable().getIdMapping(), relatedTbl, null, relatedTbl.getIdMapping(), null, tableGroupName);
                        }
                    } else {
                        SQLJoin.JoinType joinType = SQLStatementHelper.getJoinTypeForOneToOneRelationJoin(sourceSqlTbl.getTable().getIdMapping(), sourceSqlTbl, inputJoinType);
                        if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || joinType == SQLJoin.JoinType.RIGHT_OUTER_JOIN) {
                            inputJoinType = joinType;
                        }
                        relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, sourceSqlTbl.getTable().getIdMapping(), sourceSqlTbl, relatedMapping, relationTbl, null, null, tableGroupName, joinType);
                    }
                    relatedSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, relatedSqlTbl, relatedTbl.getIdMapping());
                    colNumbers = stmt.select(relatedSqlTbl, relatedTbl.getIdMapping(), null);
                    stmtMapping.setColumnPositions(colNumbers);
                }
                if (selectSubobjects && !mmd.isSerialized() && !mmd.isEmbedded()) {
                    StatementClassMapping subMappingDefinition = new StatementClassMapping(null, mmd.getName());
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, subMappingDefinition, fetchPlan, relatedSqlTbl, relatedMmd.getAbstractClassMetaData(), maxFetchPlanLimit - 1, inputJoinType);
                    if (mappingDefinition != null) {
                        mappingDefinition.addMappingDefinitionForMember(mmd.getAbsoluteFieldNumber(), subMappingDefinition);
                    }
                }
            } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
                if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                    Table joinTable = storeMgr.getTable(relatedMmds[0]);
                    DatastoreElementContainer collTable = (DatastoreElementContainer)joinTable;
                    JavaTypeMapping selectMapping = collTable.getOwnerMapping();
                    SQLTable joinSqlTbl = null;
                    if (stmt.getPrimaryTable().getTable() != joinTable) {
                        JavaTypeMapping referenceMapping = collTable.getElementMapping();
                        if (referenceMapping instanceof ReferenceMapping) {
                            ReferenceMapping refMap = (ReferenceMapping)referenceMapping;
                            Class implType = clr.classForName(mmd.getClassName(true));
                            referenceMapping = refMap.getJavaTypeMappingForType(implType);
                        }
                        joinSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIdMapping(), collTable, null, referenceMapping, null, tableGroupName + "_JOIN");
                    } else {
                        joinSqlTbl = stmt.getPrimaryTable();
                    }
                    int[] colNumbers = stmt.select(joinSqlTbl, selectMapping, null);
                    stmtMapping.setColumnPositions(colNumbers);
                }
            } else if (relationType == RelationType.MANY_TO_ONE_UNI) {
                PersistableJoinTable joinTable = (PersistableJoinTable)storeMgr.getTable(mmd);
                SQLTable joinSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIdMapping(), joinTable, null, joinTable.getOwnerMapping(), null, tableGroupName + "_JOIN");
                int[] colNumbers = stmt.select(joinSqlTbl, joinTable.getRelatedMapping(), null);
                stmtMapping.setColumnPositions(colNumbers);
            }
            if (mappingDefinition != null) {
                mappingDefinition.addMappingForMember(mmd.getAbsoluteFieldNumber(), stmtMapping);
            }
        }
    }

    private static boolean selectFetchPlanFieldsOfFKRelatedObject(SelectStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractMemberMetaData mmd, ClassLoaderResolver clr, int maxFetchPlanLimit, JavaTypeMapping m, String tableGroupName, StatementMappingIndex stmtMapping, SQLTable sqlTbl, SQLJoin.JoinType inputJoinType) {
        boolean selectFK = true;
        if (!mmd.fetchFKOnly()) {
            AbstractClassMetaData relatedCmd;
            JavaTypeMapping[] subMappings;
            ReferenceMapping refMapping;
            Class type;
            RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
            Class clazz = type = mmd.isSingleCollection() ? clr.classForName(mmd.getCollection().getElementType()) : mmd.getType();
            if (m instanceof ReferenceMapping && (refMapping = (ReferenceMapping)m).getMappingStrategy() == 0 && refMapping.getJavaTypeMapping().length == 1 && (subMappings = refMapping.getJavaTypeMapping()) != null && subMappings.length == 1) {
                type = clr.classForName(refMapping.getJavaTypeMapping()[0].getType());
            }
            if ((relatedCmd = storeMgr.getMetaDataManager().getMetaDataForClass(type, clr)) != null) {
                SQLTable relatedSqlTbl;
                DatastoreClass relatedTbl;
                if (relatedCmd.isEmbeddedOnly()) {
                    return true;
                }
                if (relatedCmd.getBaseAbstractClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                    Collection relSubclassNames = storeMgr.getSubClassesForClass(relatedCmd.getFullClassName(), true, clr);
                    if (relatedCmd.isMappedSuperclass() && relSubclassNames.size() > 1) {
                        return true;
                    }
                    if (!relatedCmd.isMappedSuperclass() && relSubclassNames.size() > 0) {
                        return true;
                    }
                }
                if ((relatedTbl = storeMgr.getDatastoreClass(relatedCmd.getFullClassName(), clr)) == null) {
                    AbstractClassMetaData[] ownerParentCmds = storeMgr.getClassesManagingTableForClass(relatedCmd, clr);
                    if (ownerParentCmds.length > 1) {
                        NucleusLogger.QUERY.info((Object)("Relation (" + mmd.getFullFieldName() + ") with multiple related tables (using subclass-table). Not supported so selecting FK of related object only"));
                        return true;
                    }
                    relatedTbl = storeMgr.getDatastoreClass(ownerParentCmds[0].getFullClassName(), clr);
                }
                String requiredGroupName = null;
                if (sourceSqlTbl.getGroupName() != null) {
                    requiredGroupName = sourceSqlTbl.getGroupName() + "." + mmd.getName();
                }
                if ((relatedSqlTbl = stmt.getTable(relatedTbl, requiredGroupName)) == null) {
                    SQLJoin.JoinType joinType = SQLStatementHelper.getJoinTypeForOneToOneRelationJoin(m, sqlTbl, inputJoinType);
                    if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || joinType == SQLJoin.JoinType.RIGHT_OUTER_JOIN) {
                        inputJoinType = joinType;
                    }
                    relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, m, sqlTbl, relatedTbl.getIdMapping(), relatedTbl, null, null, tableGroupName, joinType);
                }
                StatementClassMapping subMappingDefinition = new StatementClassMapping(mmd.getClassName(), mmd.getName());
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, subMappingDefinition, fetchPlan, relatedSqlTbl, relatedCmd, maxFetchPlanLimit - 1, inputJoinType);
                if (mappingDefinition != null) {
                    if (relatedCmd.getIdentityType() == IdentityType.APPLICATION) {
                        int[] pkFields = relatedCmd.getPKMemberPositions();
                        int[] pkCols = new int[m.getNumberOfDatastoreMappings()];
                        int pkColNo = 0;
                        for (int i = 0; i < pkFields.length; ++i) {
                            StatementMappingIndex pkIdx = subMappingDefinition.getMappingForMemberPosition(pkFields[i]);
                            int[] pkColNumbers = pkIdx.getColumnPositions();
                            for (int j = 0; j < pkColNumbers.length; ++j) {
                                pkCols[pkColNo] = pkColNumbers[j];
                                ++pkColNo;
                            }
                        }
                        selectFK = false;
                        stmtMapping.setColumnPositions(pkCols);
                    } else if (relatedCmd.getIdentityType() == IdentityType.DATASTORE) {
                        StatementMappingIndex pkIdx = subMappingDefinition.getMappingForMemberPosition(-1);
                        selectFK = false;
                        stmtMapping.setColumnPositions(pkIdx.getColumnPositions());
                    }
                    mappingDefinition.addMappingDefinitionForMember(mmd.getAbsoluteFieldNumber(), subMappingDefinition);
                }
            }
        }
        return selectFK;
    }

    public static SQLTable addJoinForOneToOneRelation(SQLStatement stmt, JavaTypeMapping sourceMapping, SQLTable sourceSqlTbl, JavaTypeMapping targetMapping, Table targetTable, String targetAlias, Object[] discrimValues, String targetTablegroupName, SQLJoin.JoinType joinType) {
        if (joinType == null) {
            joinType = SQLStatementHelper.getJoinTypeForOneToOneRelationJoin(sourceMapping, sourceSqlTbl, joinType);
        }
        SQLTable targetSqlTbl = null;
        if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
            targetSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceMapping, targetTable, targetAlias, targetMapping, discrimValues, targetTablegroupName);
        } else if (joinType == SQLJoin.JoinType.INNER_JOIN) {
            targetSqlTbl = stmt.innerJoin(sourceSqlTbl, sourceMapping, targetTable, targetAlias, targetMapping, discrimValues, targetTablegroupName);
        } else if (joinType == SQLJoin.JoinType.RIGHT_OUTER_JOIN) {
            targetSqlTbl = stmt.rightOuterJoin(sourceSqlTbl, sourceMapping, targetTable, targetAlias, targetMapping, discrimValues, targetTablegroupName);
        } else if (joinType == SQLJoin.JoinType.CROSS_JOIN) {
            targetSqlTbl = stmt.crossJoin(targetTable, targetAlias, targetTablegroupName);
        }
        return targetSqlTbl;
    }

    public static SQLJoin.JoinType getJoinTypeForOneToOneRelationJoin(JavaTypeMapping sourceMapping, SQLTable sourceSqlTbl, SQLJoin.JoinType joinType) {
        if (joinType == null) {
            joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
            if (sourceMapping != sourceSqlTbl.getTable().getIdMapping()) {
                joinType = sourceMapping.isNullable() ? SQLJoin.JoinType.LEFT_OUTER_JOIN : SQLJoin.JoinType.INNER_JOIN;
            }
        }
        return joinType;
    }

    public static BooleanExpression getExpressionForDiscriminatorForClass(SQLStatement stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, SQLTable discrimSqlTbl, ClassLoaderResolver clr) {
        Object discriminatorValue = SQLStatementHelper.getDiscriminatorValueForClass((NucleusContext)stmt.getRDBMSManager().getNucleusContext(), className, dismd, discriminatorMapping, clr);
        SQLExpression discrExpr = stmt.getSQLExpressionFactory().newExpression(stmt, discrimSqlTbl, discriminatorMapping);
        SQLExpression discrVal = stmt.getSQLExpressionFactory().newLiteral(stmt, discriminatorMapping, discriminatorValue);
        return discrExpr.eq(discrVal);
    }

    public static Object getDiscriminatorValueForClass(NucleusContext nucleusCtx, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, ClassLoaderResolver clr) {
        Object discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = nucleusCtx.getMetaDataManager().getMetaDataForClass(className, clr);
            String strValue = null;
            if (targetCmd.getInheritanceMetaData() != null && targetCmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                strValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
            if (strValue == null) {
                strValue = className;
            }
            if (discriminatorMapping instanceof DiscriminatorMapping.DiscriminatorLongMapping) {
                try {
                    discriminatorValue = Integer.valueOf(strValue);
                }
                catch (NumberFormatException nfe) {
                    throw new NucleusUserException("Discriminator for " + className + " is not integer-based but needs to be!");
                }
            } else {
                discriminatorValue = strValue;
            }
        }
        return discriminatorValue;
    }

    public static List getDiscriminatorValuesForMember(String className, JavaTypeMapping discMapping, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ArrayList<String> discrimValues = new ArrayList<String>();
        DiscriminatorStrategy strategy = discMapping.getTable().getDiscriminatorMetaData().getStrategy();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimValues.add(className);
            Collection subclasses = storeMgr.getSubClassesForClass(className, true, clr);
            if (subclasses != null && subclasses.size() > 0) {
                discrimValues.addAll(subclasses);
            }
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            MetaDataManager mmgr = storeMgr.getMetaDataManager();
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
            Collection subclasses = storeMgr.getSubClassesForClass(className, true, clr);
            discrimValues.add(cmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            if (subclasses != null && subclasses.size() > 0) {
                for (String subclassName : subclasses) {
                    AbstractClassMetaData subclassCmd = mmgr.getMetaDataForClass(subclassName, clr);
                    discrimValues.add(subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                }
            }
        }
        return discrimValues;
    }
}

