/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractDataNucleusMojo
extends AbstractMojo {
    protected File metadataDirectory;
    protected String metadataIncludes;
    protected String metadataExcludes;
    private List classpathElements;
    protected List pluginArtifacts;
    protected String log4jConfiguration;
    protected String jdkLogConfiguration;
    protected boolean verbose;
    protected boolean fork;
    protected String persistenceUnitName;
    protected String api;

    public void execute() throws MojoExecutionException {
        if (!this.metadataDirectory.exists()) {
            this.getLog().warn((CharSequence)("No files to run DataNucleus tool '" + this.getToolName() + "'" + " since specified metadata directory '" + this.metadataDirectory.getAbsolutePath() + "'" + " is not available."));
            return;
        }
        List files = this.findMetadataFiles();
        if (files.size() == 0) {
            this.getLog().warn((CharSequence)("No files to run DataNucleus tool '" + this.getToolName() + "'"));
            return;
        }
        this.getLog().debug((CharSequence)("Metadata Directory is : " + this.metadataDirectory.getAbsolutePath()));
        try {
            this.executeDataNucleusTool(this.pluginArtifacts, files);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing the DataNucleus tool '" + this.getToolName() + "'.", (Exception)((Object)e));
        }
    }

    protected URL getLog4JConfiguration() {
        if (this.log4jConfiguration != null) {
            URL log4jURL = ((Object)((Object)this)).getClass().getResource(this.log4jConfiguration);
            if (log4jURL == null && this.log4jConfiguration != null) {
                try {
                    log4jURL = new URL("file:" + this.log4jConfiguration);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return log4jURL;
        }
        return null;
    }

    protected URL getJdkLogConfiguration() {
        if (this.jdkLogConfiguration != null) {
            URL jdkLogURL = ((Object)((Object)this)).getClass().getResource(this.jdkLogConfiguration);
            if (jdkLogURL == null && this.jdkLogConfiguration != null) {
                try {
                    jdkLogURL = new URL("file:" + this.jdkLogConfiguration);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return jdkLogURL;
        }
        return null;
    }

    protected List findMetadataFiles() throws MojoExecutionException {
        List files;
        try {
            files = FileUtils.getFiles((File)this.metadataDirectory, (String)this.metadataIncludes, (String)this.metadataExcludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for metadata files in '" + this.metadataDirectory.getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    protected List getUniqueClasspathElements() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.metadataDirectory.getAbsolutePath());
        for (String pathelem : this.classpathElements) {
            if (ret.contains(new File(pathelem).getAbsolutePath())) continue;
            ret.add(pathelem);
        }
        return ret;
    }

    protected abstract void executeDataNucleusTool(List var1, List var2) throws CommandLineException, MojoExecutionException;

    protected abstract String getToolName();

    protected void executeCommandLine(Commandline cl) throws CommandLineException, MojoExecutionException {
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        this.getLog().debug((CharSequence)("Exit code: " + exitCode));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)(" Standard output from the DataNucleus tool " + this.getToolName() + " :"));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().info((CharSequence)stdout.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)(" Standard error from the DataNucleus tool + " + this.getToolName() + " :"));
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)stderr.getOutput());
            this.getLog().error((CharSequence)"--------------------");
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("The DataNucleus tool " + this.getToolName() + " exited with a non-null exit code.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInJvm(String className, List args, List cpEntries, boolean quiet) throws MojoExecutionException {
        try {
            URL[] urls = new URL[cpEntries.size()];
            int urlIdx = 0;
            for (String n : cpEntries) {
                try {
                    if (!quiet && this.verbose) {
                        this.getLog().info((CharSequence)("  CP: " + n));
                    }
                    urls[urlIdx++] = new File(n).toURI().toURL();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Cannot convert to url: " + n, e);
                }
            }
            URLClassLoader loader = new URLClassLoader(urls, null);
            Class<?> c = loader.loadClass(className);
            Method m = c.getMethod("main", String[].class);
            ClassLoader tl = Thread.currentThread().getContextClassLoader();
            String oldProp = System.getProperty("log4j.configuration");
            try {
                Thread.currentThread().setContextClassLoader(loader);
                URL log4jURL = this.getLog4JConfiguration();
                if (log4jURL != null) {
                    System.setProperty("log4j.configuration", log4jURL.toString());
                } else {
                    URL jdkLogURL = this.getJdkLogConfiguration();
                    if (jdkLogURL != null) {
                        System.setProperty("java.util.logging.config.file", jdkLogURL.toString());
                    }
                }
                m.invoke(null, new Object[]{args.toArray(new String[args.size()])});
            }
            finally {
                Thread.currentThread().setContextClassLoader(tl);
                if (oldProp != null) {
                    System.setProperty("log4j.configuration", oldProp);
                } else {
                    System.getProperties().remove("log4j.configuration");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing DataNucleus tool " + this.getToolName(), e);
        }
    }
}

