/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid.raster;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageWriter;
import it.geosolutions.imageio.plugins.arcgrid.raster.AsciiGridRaster;
import it.geosolutions.imageio.utilities.StringToDouble;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

final class EsriAsciiGridRaster
extends AsciiGridRaster {
    public static final String NO_DATA_MARKER = "-9999";
    public static final String NCOLS = "NCOLS";
    public static final String NROWS = "NROWS";
    public static final String XLLCORNER = "XLLCORNER";
    public static final String YLLCORNER = "YLLCORNER";
    public static final String XLLCENTER = "XLLCENTER";
    public static final String YLLCENTER = "YLLCENTER";
    public static final String CELLSIZE = "CELLSIZE";
    public static final String NODATA_VALUE = "NODATA_VALUE";
    private String noDataMarker;

    public EsriAsciiGridRaster(ImageInputStream iis) {
        super(iis);
    }

    public EsriAsciiGridRaster(ImageOutputStream ios) {
        super(ios);
    }

    public EsriAsciiGridRaster(ImageOutputStream ios, AsciiGridsImageWriter writer) {
        super(ios, writer);
    }

    public EsriAsciiGridRaster(ImageInputStream iis, AsciiGridsImageReader reader) {
        super(iis, reader);
    }

    @Override
    public void parseHeader() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("Header Parsed: ");
        }
        boolean keepParsing = true;
        this.imageIS.mark();
        int requiredFields = 0;
        String sKey = null;
        boolean cornerInitialized = false;
        int maxNumBytes = 100;
        double value = 0.0;
        StringToDouble doubleConverter = StringToDouble.acquire();
        while (keepParsing && !((sKey = this.getKey(this.imageIS, maxNumBytes, 12, (byte)-1)) == null | sKey.length() == 0) && sKey != "" && !Double.isNaN(value = this.getValue(this.imageIS, 300, 150, doubleConverter)) && !Double.isNaN(value)) {
            if (NCOLS.equalsIgnoreCase(sKey)) {
                this.nCols = (int)value;
                ++requiredFields;
                continue;
            }
            if (NROWS.equalsIgnoreCase(sKey)) {
                this.nRows = (int)value;
                ++requiredFields;
                continue;
            }
            if (XLLCORNER.equalsIgnoreCase(sKey)) {
                this.xllCellCoordinate = value;
                if (!cornerInitialized) {
                    this.isCorner = true;
                    cornerInitialized = true;
                }
                ++requiredFields;
                continue;
            }
            if (YLLCORNER.equalsIgnoreCase(sKey)) {
                this.yllCellCoordinate = value;
                ++requiredFields;
                continue;
            }
            if (XLLCENTER.equalsIgnoreCase(sKey)) {
                this.xllCellCoordinate = value;
                if (!cornerInitialized) {
                    this.isCorner = false;
                    cornerInitialized = true;
                }
                ++requiredFields;
                continue;
            }
            if (YLLCENTER.equalsIgnoreCase(sKey)) {
                this.yllCellCoordinate = value;
                ++requiredFields;
                continue;
            }
            if (CELLSIZE.equalsIgnoreCase(sKey)) {
                this.cellSizeX = this.cellSizeY = value;
                ++requiredFields;
                continue;
            }
            if (NODATA_VALUE.equalsIgnoreCase(sKey)) {
                this.noData = value;
                ++requiredFields;
                keepParsing = false;
                continue;
            }
            keepParsing = false;
        }
        StringToDouble.release(doubleConverter);
        if (requiredFields < 5) {
            this.imageIS.reset();
            throw new IOException("This file is not a valid ESRI ascii grid file.");
        }
        if (requiredFields == 6) {
            byte b;
            int limit = 0;
            do {
                b = (byte)(this.imageIS.read() & 0xFF);
                if (++limit > 100) {
                    this.imageIS.reset();
                    throw new IOException("This file is not a valid ESRI ascii grid file.");
                }
                if (b != -1) continue;
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            } while (b == 32 || b == 9 || b == 10 || b == 13 || (b < 48 || b > 57) && !(b == 43 | b == 45));
            this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
        } else if (requiredFields == 5) {
            this.imageIS.seek(this.imageIS.getStreamPosition() - 1L);
            byte b = (byte)(this.imageIS.read() & 0xFF);
            if (b >= 48 && b <= 57 || b == 43 | b == 45) {
                this.dataStartAt = this.imageIS.getStreamPosition() - 1L;
            } else {
                this.imageIS.reset();
                throw new IOException("This file is not a valid ESRI ascii grid file.");
            }
        }
        this.imageIS.reset();
        this.imageIS.mark();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("\tnCols:" + this.nCols);
            LOGGER.info("\tnRows:" + this.nRows);
        }
    }

    @Override
    public void writeHeader(String columns, String rows, String xll, String yll, String cellsizeX, String cellsizeY, String rasterSpaceType, String noDataValue) throws IOException {
        this.imageOS.writeBytes(new StringBuffer(NCOLS).append(" ").append(columns).append(newline).toString());
        this.imageOS.writeBytes(new StringBuffer(NROWS).append(" ").append(rows).append(newline).toString());
        if (rasterSpaceType.equalsIgnoreCase("pixelIsPoint")) {
            this.imageOS.writeBytes(new StringBuffer(XLLCENTER).append(" ").append(xll).append(newline).toString());
            this.imageOS.writeBytes(new StringBuffer(YLLCENTER).append(" ").append(yll).append(newline).toString());
        } else {
            this.imageOS.writeBytes(new StringBuffer(XLLCORNER).append(" ").append(xll).append(newline).toString());
            this.imageOS.writeBytes(new StringBuffer(YLLCORNER).append(" ").append(yll).append(newline).toString());
        }
        this.imageOS.writeBytes(new StringBuffer(CELLSIZE).append(" ").append(cellsizeX).append(newline).toString());
        if (noDataValue != null) {
            this.imageOS.writeBytes(new StringBuffer(NODATA_VALUE).append(" ").append(noDataValue.equalsIgnoreCase("nan") ? NO_DATA_MARKER : noDataValue).append(newline).toString());
            this.noData = Double.parseDouble(noDataValue);
        }
    }

    @Override
    public String getNoDataMarker() {
        if (this.noDataMarker == null) {
            this.noDataMarker = !Double.isNaN(this.noData) ? Double.toString(this.noData) : NO_DATA_MARKER;
        }
        return this.noDataMarker;
    }

    @Override
    public AsciiGridRaster.AsciiGridRasterType getRasterType() {
        return AsciiGridRaster.AsciiGridRasterType.ESRI;
    }
}

