/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.plugins.cog.CogImageReadParam;
import it.geosolutions.imageio.utilities.SoftValueHashMap;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStream;
import it.geosolutions.imageioimpl.plugins.cog.CogTileInfo;
import it.geosolutions.imageioimpl.plugins.cog.ContiguousRangeComposer;
import it.geosolutions.imageioimpl.plugins.cog.RangeReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public class DefaultCogImageInputStream
extends ImageInputStreamImpl
implements CogImageInputStream {
    private boolean initialized = false;
    protected URI uri;
    protected CogTileInfo header;
    protected RangeReader rangeReader;
    protected Map<Long, byte[]> data;
    private static final Logger LOGGER = Logger.getLogger(DefaultCogImageInputStream.class.getName());

    public DefaultCogImageInputStream(String url) {
        this(URI.create(url));
    }

    public DefaultCogImageInputStream(URL url) {
        this(URI.create(url.toString()));
    }

    public DefaultCogImageInputStream(URI uri) {
        this.uri = uri;
    }

    public DefaultCogImageInputStream(BasicAuthURI cogUri) {
        this.uri = cogUri.getUri();
    }

    public DefaultCogImageInputStream(URI uri, RangeReader rangeReader) {
        this.uri = uri;
        this.init(rangeReader);
    }

    @Override
    public void init(RangeReader rangeReader) {
        this.rangeReader = rangeReader;
        this.initializeHeader(rangeReader.getHeaderLength());
    }

    @Override
    public void init(CogImageReadParam param) {
        Class<? extends RangeReader> rangeReaderClass = param.getRangeReaderClass();
        if (null != rangeReaderClass) {
            try {
                this.rangeReader = rangeReaderClass.getDeclaredConstructor(URI.class, Integer.TYPE).newInstance(this.uri, param.getHeaderLength());
            }
            catch (Exception e) {
                LOGGER.severe("Unable to instantiate range reader class " + rangeReaderClass.getCanonicalName());
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Range reader class not specified in CogImageReadParam.");
        }
        if (this.rangeReader == null) {
            throw new RuntimeException("Unable to instantiate range reader class " + rangeReaderClass.getCanonicalName());
        }
        this.initializeHeader(param.getHeaderLength());
    }

    protected void initializeHeader() {
        this.initializeHeader(CogImageReadParam.DEFAULT_HEADER_LENGTH);
    }

    protected void initializeHeader(int headerLength) {
        this.header = new CogTileInfo(headerLength);
        this.data = new SoftValueHashMap<Long, byte[]>(0);
        this.data.put(0L, this.rangeReader.readHeader());
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public CogTileInfo getHeader() {
        return this.header;
    }

    @Override
    public void readRanges(CogTileInfo cogTileInfo) {
        ContiguousRangeComposer contiguousRangeComposer = new ContiguousRangeComposer(0L, cogTileInfo.getHeaderLength() - 1);
        cogTileInfo.getTileRanges().forEach((tileIndex, tileRange) -> {
            if (tileIndex == -100) {
                return;
            }
            contiguousRangeComposer.addTileRange(tileRange.getStart(), tileRange.getEnd());
        });
        this.rangeReader.setHeaderLength(cogTileInfo.getHeaderLength());
        Set<long[]> ranges = contiguousRangeComposer.getRanges();
        LOGGER.fine("Submitting " + ranges.size() + " range request(s)");
        this.data = this.rangeReader.read(ranges);
    }

    public String getUrl() {
        return this.uri.toString();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b, 0, 1);
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] contiguousRange = null;
        long rangeStart = -1L;
        for (Map.Entry<Long, byte[]> entry : this.data.entrySet()) {
            long start = entry.getKey();
            long end = entry.getKey() + (long)entry.getValue().length;
            if (this.streamPos < start || this.streamPos + (long)len > end) continue;
            contiguousRange = entry.getValue();
            rangeStart = entry.getKey();
            break;
        }
        if (contiguousRange == null || rangeStart == -1L) {
            if (this.data.size() == 1 && this.streamPos + (long)len >= (long)this.data.get(0L).length) {
                while (this.streamPos + (long)len >= (long)this.data.get(0L).length) {
                    this.data.put(0L, this.rangeReader.fetchHeader());
                }
                contiguousRange = this.data.get(0L);
                this.header.setHeaderLength(contiguousRange.length);
                rangeStart = 0L;
            } else {
                LOGGER.severe("The requested offset is not present in the available data.  Requested offset: " + off + " - requested length: " + len + " - streamPos: " + this.streamPos);
                throw new IOException("No COG data available for the requested byte location.");
            }
        }
        int relativeStreamPos = (int)(this.streamPos - rangeStart);
        System.arraycopy(contiguousRange, relativeStreamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.data != null && !this.data.isEmpty()) {
            this.data.clear();
        }
    }
}

