/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.binarize;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.binarize.JaiI18N;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.iterator.RandomIter;

public class BinarizeOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final boolean hasNoData;
    private Range noData;
    private boolean[] lut;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private final Rectangle roiBounds;
    private PlanarImage roiImage;
    private static byte[] byteTable = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static int[] bitsUp = null;
    private double threshold;

    public BinarizeOpImage(RenderedImage source, Map config, ImageLayout layout, double threshold, ROI roi, Range nodata) {
        super(source, BinarizeOpImage.layoutHelper(source, layout, config), config, true);
        if (source.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("BinarizeOpImage0"));
        }
        this.threshold = threshold;
        if (nodata != null) {
            this.hasNoData = true;
            this.noData = nodata;
        } else {
            this.hasNoData = false;
        }
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        int dataType = source.getSampleModel().getDataType();
        if (dataType == 0) {
            this.initBooleanTable();
        }
    }

    private static ImageLayout layoutHelper(RenderedImage source, ImageLayout il, Map config) {
        ColorModel cm;
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        SampleModel sm = layout.getSampleModel(source);
        if (!ImageUtil.isBinary(sm)) {
            sm = new MultiPixelPackedSampleModel(0, layout.getTileWidth(source), layout.getTileHeight(source), 1);
            layout.setSampleModel(sm);
        }
        if ((cm = layout.getColorModel(null)) == null || !JDKWorkarounds.areCompatibleDataModels(sm, cm)) {
            layout.setColorModel(ImageUtil.getCompatibleColorModel(sm, config));
        }
        return layout;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (sources[0].getSampleModel().getDataType()) {
                case 0: {
                    this.byteLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.ushortLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.shortLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.intLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.floatLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.doubleLoop(sources[0], dest, destRect, roiIter, roiContainsTile);
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("BinarizeOpImage1"));
                }
            }
        }
    }

    private void byteLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        if (this.threshold <= 0.0 && (!this.hasROI || this.hasROI && roiContainsTile) && !this.hasNoData) {
            this.setTo1(dest, destRect);
            return;
        }
        if (this.threshold > 255.0) {
            return;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 0, false);
        int srcOffset = srcImD.bandOffsets[0];
        byte[] srcData = ((byte[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.hasROI && !roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && this.lut[srcData[s] & 0xFF]) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (this.lut[srcData[s] & 0xFF]) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void ushortLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        if (this.threshold <= 0.0 && (!this.hasROI || this.hasROI && roiContainsTile) && !this.hasNoData) {
            this.setTo1(dest, destRect);
            return;
        }
        if (this.threshold > 65535.0) {
            return;
        }
        int thresholdI = (int)Math.ceil(this.threshold);
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 1, false);
        int srcOffset = srcImD.bandOffsets[0];
        short[] srcData = ((short[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if ((srcData[s] & 0xFFFF) >= thresholdI) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && (srcData[s] & 0xFFFF) >= thresholdI) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseC || this.hasNoData && this.hasROI & roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (!this.noData.contains(srcData[s]) && (srcData[s] & 0xFFFF) >= thresholdI) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && !this.noData.contains(srcData[s]) && (srcData[s] & 0xFFFF) >= thresholdI) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void shortLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        if (this.threshold <= -32768.0 && (!this.hasROI || this.hasROI && roiContainsTile) && !this.hasNoData) {
            this.setTo1(dest, destRect);
            return;
        }
        if (this.threshold > 32767.0) {
            return;
        }
        short thresholdS = (short)Math.ceil(this.threshold);
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 2, false);
        int srcOffset = srcImD.bandOffsets[0];
        short[] srcData = ((short[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (srcData[s] >= thresholdS) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && srcData[s] >= thresholdS) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseC || this.hasNoData && this.hasROI & roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (!this.noData.contains(srcData[s]) && srcData[s] >= thresholdS) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && !this.noData.contains(srcData[s]) && srcData[s] >= thresholdS) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void intLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        if (this.threshold <= -2.147483648E9 && (!this.hasROI || this.hasROI && roiContainsTile) && !this.hasNoData) {
            this.setTo1(dest, destRect);
            return;
        }
        if (this.threshold > 2.147483647E9) {
            return;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 3, false);
        int srcOffset = srcImD.bandOffsets[0];
        int[] srcData = ((int[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if ((double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseC || this.hasNoData && this.hasROI & roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (!this.noData.contains(srcData[s]) && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && !this.noData.contains(srcData[s]) && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void floatLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 4, false);
        int srcOffset = srcImD.bandOffsets[0];
        float[] srcData = ((float[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if ((double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseC || this.hasNoData && this.hasROI & roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (!this.noData.contains(srcData[s]) && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && !this.noData.contains(srcData[s]) && (double)srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void doubleLoop(Raster source, WritableRaster dest, Rectangle destRect, RandomIter roiIter, boolean roiContainsTile) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 5, false);
        int srcOffset = srcImD.bandOffsets[0];
        double[] srcData = ((double[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        int x0 = 0;
        int y0 = 0;
        int srcX = source.getMinX();
        int srcY = source.getMinY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else if (this.caseC || this.hasNoData && this.hasROI & roiContainsTile) {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    if (!this.noData.contains(srcData[s]) && srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        } else {
            for (int h = 0; h < destRect.height; ++h) {
                int indE = ind0 + destRect.width;
                int b = ind0;
                int s = srcOffset;
                while (b < indE) {
                    x0 = srcX + b - ind0;
                    y0 = srcY + h;
                    if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0 && !this.noData.contains(srcData[s]) && srcData[s] >= this.threshold) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                    ++b;
                    s += pixelStride;
                }
                offset += pid.lineStride;
                srcOffset += srcImD.lineStride;
            }
        }
        pa.setPackedPixels(pid);
    }

    private void setTo1(Raster dest, Rectangle destRect) {
        BinarizeOpImage.initBitsUp();
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels(dest, destRect, true, false);
        int offset = pid.offset;
        for (int h = 0; h < destRect.height; ++h) {
            int ind0 = pid.bitOffset;
            int indE = ind0 + destRect.width - 1;
            if (indE < 8) {
                pid.data[offset] = (byte)(pid.data[offset] | bitsUp[indE]);
            } else {
                pid.data[offset] = (byte)(pid.data[offset] | bitsUp[7]);
                for (int b = offset + 1; b <= offset + (indE - 7) / 8; ++b) {
                    pid.data[b] = -1;
                }
                int remBits = indE % 8;
                if (remBits % 8 != 7) {
                    indE = offset + indE / 8;
                    pid.data[indE] = (byte)(pid.data[indE] | bitsUp[remBits]);
                }
            }
            offset += pid.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private static synchronized void initBitsUp() {
        if (bitsUp != null) {
            return;
        }
        bitsUp = new int[64];
        for (int i = 0; i < 8; ++i) {
            for (int j = i; j < 8; ++j) {
                int bi = 255 >> i;
                int bj = 255 << 7 - j;
                BinarizeOpImage.bitsUp[j + (i << 3)] = bi & bj;
            }
        }
    }

    private void initBooleanTable() {
        if (this.lut != null) {
            return;
        }
        short thresholdI = (short)Math.ceil(this.threshold);
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            this.lut[i] = this.hasNoData && this.noData.contains((byte)i) ? false : (i & 0xFF) >= thresholdI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            BinarizeOpImage binarizeOpImage = this;
            synchronized (binarizeOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

