/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DomainElement1D;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;

public class DefaultDomainElement1D
implements DomainElement1D {
    private static final long serialVersionUID = -2520449231656622013L;
    private String name;
    private double inputMinimum;
    private double inputMaximum;
    private Range range;
    private boolean inputMinimumInf;
    private boolean inputMaximumInf;
    private boolean inputMaximumNaN;
    private boolean inputMinimumNaN;
    private int hashCode = -1;

    @Override
    public int compareTo(DomainElement1D o) {
        if (o instanceof DefaultDomainElement1D) {
            return new Double(this.inputMinimum).compareTo(((DefaultDomainElement1D)o).inputMinimum);
        }
        return new Double(this.inputMinimum).compareTo(o.getRange().getMin().doubleValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultDomainElement1D) {
            return false;
        }
        DefaultDomainElement1D that = (DefaultDomainElement1D)obj;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.inputMinimum, that.inputMinimum)) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.inputMaximum, that.inputMaximum)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.range.equals(that.range);
    }

    protected Class<?> getEquivalenceClass() {
        return DefaultDomainElement1D.class;
    }

    @Override
    public boolean contains(Number value) {
        return this.range.containsN(value);
    }

    @Override
    public boolean contains(Range range) {
        return this.range.contains(range);
    }

    @Override
    public boolean contains(double value) {
        return value <= this.inputMaximum && value >= this.inputMinimum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(this.inputMinimum);
    }

    public DefaultDomainElement1D(CharSequence name, Range inputRange) throws IllegalArgumentException {
        PiecewiseUtilities.ensureNonNull("name", name);
        PiecewiseUtilities.ensureNonNull("range", inputRange);
        this.name = name + "";
        this.range = RangeFactory.convertToDoubleRange(inputRange);
        Class<? extends Number> type = inputRange.getDataType().getClassValue();
        boolean minInc = inputRange.isMinIncluded();
        boolean maxInc = inputRange.isMaxIncluded();
        double tempMin = inputRange.getMin().doubleValue();
        double tempMax = inputRange.getMax().doubleValue();
        if (Double.isInfinite(tempMin)) {
            this.inputMinimum = tempMin;
            this.inputMinimumInf = true;
        } else {
            this.inputMinimum = PiecewiseUtilities.doubleValue(type, inputRange.getMin().doubleValue(), minInc ? 0 : 1);
        }
        if (Double.isInfinite(tempMax)) {
            this.inputMaximum = tempMax;
            this.inputMaximumInf = true;
        } else {
            this.inputMaximum = PiecewiseUtilities.doubleValue(type, inputRange.getMax().doubleValue(), maxInc ? 0 : -1);
        }
        this.inputMinimumNaN = Double.isNaN(this.inputMinimum);
        this.inputMaximumNaN = Double.isNaN(this.inputMaximum);
        if (this.inputMinimumNaN && !this.inputMaximumNaN || !this.inputMinimumNaN && this.inputMaximumNaN) {
            throw new IllegalArgumentException("Bad Range format: " + inputRange.getMin() + "/ " + inputRange.getMax());
        }
    }

    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash(this.name, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.range, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.inputMaximum, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.inputMinimum, this.hashCode);
        return this.hashCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getInputMaximum() {
        return this.inputMaximum;
    }

    public boolean isInputMaximumInfinite() {
        return this.inputMaximumInf;
    }

    public boolean isInputMaximumNaN() {
        return this.inputMaximumNaN;
    }

    public double getInputMinimum() {
        return this.inputMinimum;
    }

    public boolean isInputMinimumInfinite() {
        return this.inputMinimumInf;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    public boolean isInputMinimumNaN() {
        return this.inputMinimumNaN;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Domain description:");
        buffer.append("\n").append("name=").append(this.name);
        buffer.append("\n").append("input range=").append(this.range);
        return buffer.toString();
    }
}

